/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import java.util.ArrayList;
import java.util.List;

public class BinaryUtils {
    public static byte[] parseBinaryString(String data) {
        if (data.trim().length() > 0) {
            String[] bytes = data.split(" ");
            ArrayList<Byte> result = new ArrayList<Byte>();
            for (String element : bytes) {
                if (element.startsWith("0x")) {
                    result.add(Integer.decode(element).byteValue());
                    continue;
                }
                for (int i = 0; i < element.length(); i += 2) {
                    String hexByte = element.substring(i, Math.min(element.length(), i + 2));
                    result.add((byte)Integer.parseInt(hexByte, 16));
                }
            }
            return BinaryUtils.toByteArray(result);
        }
        return new byte[0];
    }

    public static String formatBinary(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte b : data) {
            builder.append(String.format("%#04x ", b));
        }
        return builder.toString().trim();
    }

    public static String formatBinaryInTable(byte[] data, int rowLength, boolean showRowAddress, boolean showAscii) {
        return BinaryUtils.formatBinaryInTable(data, data.length, rowLength, showRowAddress, showAscii);
    }

    public static String formatBinaryInTable(byte[] data, int dataSize, int rowLength, boolean showRowAddress, boolean showAscii) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < dataSize; ++i) {
            int j;
            if (showRowAddress && i % rowLength == 0) {
                builder.append(String.format("%04x  ", i));
            }
            builder.append(String.format("%02x", data[i]));
            if ((i + 1) % rowLength == 0) {
                if (showAscii) {
                    builder.append("  ");
                    for (j = i + 1 - rowLength; j <= i; ++j) {
                        if (BinaryUtils.isPrintableChar((char)data[j])) {
                            builder.append((char)data[j]);
                        } else {
                            builder.append(".");
                        }
                        if ((j + 1) % rowLength % 8 != 0 || (j + 1) % rowLength == 0) continue;
                        builder.append(" ");
                    }
                }
                builder.append("\n");
                continue;
            }
            if ((i + 1) % rowLength % 8 == 0) {
                builder.append("  ");
                continue;
            }
            if (i != dataSize - 1) {
                builder.append(" ");
                continue;
            }
            if (showAscii) {
                j = i + 1;
                while (j % rowLength != 0) {
                    builder.append("   ");
                    if (j % rowLength % 8 == 0) {
                        builder.append(" ");
                    }
                    ++j;
                }
                builder.append("  ");
                for (j = i - i % rowLength; j <= i; ++j) {
                    if (BinaryUtils.isPrintableChar((char)data[j])) {
                        builder.append((char)data[j]);
                    } else {
                        builder.append(".");
                    }
                    if ((j + 1) % rowLength % 8 != 0 || (j + 1) % rowLength == 0) continue;
                    builder.append(" ");
                }
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String formatBinary(byte[] data, int maxBytes, String truncationSuffix) {
        StringBuilder builder = new StringBuilder();
        int byteCount = Math.min(data.length, maxBytes);
        for (int i = 0; i < byteCount; ++i) {
            builder.append(String.format("%#04x ", data[i]));
        }
        if (byteCount < data.length) {
            return builder.toString().trim() + truncationSuffix;
        }
        return builder.toString().trim();
    }

    public static boolean contains(byte[] source, byte[] value) {
        if (value.length == 0) {
            return false;
        }
        for (int i = 0; i < source.length; ++i) {
            if (value[0] != source[i]) continue;
            boolean equal = true;
            for (int j = 0; equal && j < value.length; ++j) {
                if (i + j < source.length && value[j] == source[i + j]) continue;
                equal = false;
            }
            if (!equal) continue;
            return true;
        }
        return false;
    }

    private static byte[] toByteArray(List<Byte> bytes) {
        byte[] result = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            result[i] = bytes.get(i);
        }
        return result;
    }

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

