/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.BinaryUtils;
import eu.luminis.jmeter.wssampler.DataPayloadType;
import eu.luminis.jmeter.wssampler.GuiUtils;
import eu.luminis.jmeter.wssampler.JMeterUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.jmeter.gui.util.FileDialoger;

public class DataPanel
extends JPanel {
    public static final String BINARY = "Binary";
    public static final String TEXT = "Text";
    public static final String TEXT_STOMP = "STOMP Text (having ^@)";
    private JTextArea requestDataField;
    private JComboBox typeSelector;
    private JLabel messageField;
    private final JLabel requestDataLabel;
    private final JLabel fileLabel;
    private final JTextField filePathField;
    private final JButton browseButton;
    private final JCheckBox enableFile;

    public DataPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Data"));
        this.setLayout(new BoxLayout(this, 1));
        JPanel topBar = new JPanel();
        topBar.setLayout(new BoxLayout(topBar, 0));
        String[] typeOptions = new String[]{TEXT, BINARY, TEXT_STOMP};
        this.typeSelector = new JComboBox<String>(typeOptions);
        this.typeSelector.setMaximumSize(this.typeSelector.getMinimumSize());
        this.typeSelector.addActionListener(e -> this.checkBinary());
        topBar.add(this.typeSelector);
        topBar.add(Box.createHorizontalStrut(10));
        this.messageField = new JLabel();
        this.messageField.setForeground(GuiUtils.getLookAndFeelColor("TextField.errorForeground"));
        topBar.add(this.messageField);
        topBar.add(Box.createHorizontalGlue());
        topBar.setAlignmentX(0.0f);
        this.add(topBar);
        this.add(Box.createVerticalStrut(10));
        JPanel dataZone = new JPanel();
        dataZone.setLayout(new BoxLayout(dataZone, 0));
        dataZone.add(Box.createHorizontalStrut(5));
        this.requestDataLabel = new JLabel("Request data: ");
        this.requestDataLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.requestDataLabel.setMaximumSize(new Dimension(this.requestDataLabel.getMaximumSize().width, Integer.MAX_VALUE));
        this.requestDataLabel.setVerticalAlignment(1);
        dataZone.add(this.requestDataLabel);
        this.requestDataField = new JTextArea();
        this.requestDataField.setColumns(40);
        this.requestDataField.setRows(10);
        this.requestDataField.setLineWrap(true);
        this.requestDataField.setBorder(BorderFactory.createEmptyBorder());
        this.requestDataField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DataPanel.this.checkBinary();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DataPanel.this.checkBinary();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DataPanel.this.checkBinary();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.requestDataField);
        scrollPane.setMaximumSize(new Dimension(scrollPane.getMaximumSize().width, Integer.MAX_VALUE));
        scrollPane.setBorder(new JTextField().getBorder());
        scrollPane.setAlignmentY(0.5f);
        dataZone.add(scrollPane);
        dataZone.setAlignmentX(0.0f);
        this.add(dataZone);
        this.add(Box.createVerticalStrut(10));
        JPanel filePathPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.enableFile = new JCheckBox();
        this.enableFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPanel.this.enableSelectFileOption(DataPanel.this.enableFile.isSelected());
            }
        });
        filePathPanel.add(this.enableFile);
        this.fileLabel = new JLabel("Read request data from file: ");
        filePathPanel.add(this.fileLabel);
        this.filePathField = new JTextField();
        this.filePathField.setColumns(30);
        filePathPanel.add(this.filePathField);
        this.browseButton = new JButton("Browse...");
        filePathPanel.add(this.browseButton);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = FileDialoger.promptToOpenFile();
                if (fileChooser != null && fileChooser.getSelectedFile() != null) {
                    DataPanel.this.filePathField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.enableSelectFileOption(false);
        filePathPanel.setAlignmentX(0.0f);
        this.add(filePathPanel);
    }

    void enableSelectFileOption(boolean enable) {
        this.requestDataLabel.setEnabled(!enable);
        this.requestDataField.setEnabled(!enable);
        this.fileLabel.setEnabled(enable);
        this.filePathField.setEnabled(enable);
        this.browseButton.setEnabled(enable);
    }

    void clearGui() {
        this.requestDataField.setText("");
        this.messageField.setText("");
        this.enableFile.setSelected(false);
    }

    public String getRequestData() {
        return this.requestDataField.getText();
    }

    public void setRequestData(String requestData) {
        this.requestDataField.setText(requestData);
    }

    public DataPayloadType getType() {
        Object selected = this.typeSelector.getSelectedItem();
        if (Objects.equals(selected, BINARY)) {
            return DataPayloadType.Binary;
        }
        if (Objects.equals(selected, TEXT)) {
            return DataPayloadType.Text;
        }
        if (Objects.equals(selected, TEXT_STOMP)) {
            return DataPayloadType.TextStomp;
        }
        throw new RuntimeException("Unknown type: " + selected);
    }

    public void setType(DataPayloadType type) {
        switch (type) {
            case Binary: {
                this.typeSelector.setSelectedItem(BINARY);
                break;
            }
            case TextStomp: {
                this.typeSelector.setSelectedItem(TEXT_STOMP);
                break;
            }
            case Text: {
                this.typeSelector.setSelectedItem(TEXT);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: '" + (Object)((Object)type) + "'");
            }
        }
    }

    public boolean getReadDataFromFile() {
        return this.enableFile.isSelected();
    }

    public void setReadDataFromFile(boolean enable) {
        this.enableFile.setSelected(enable);
        this.enableSelectFileOption(enable);
    }

    public String getDataFile() {
        return this.filePathField.getText();
    }

    public void setDataFile(String file) {
        this.filePathField.setText(file);
    }

    private void checkBinary() {
        if (this.typeSelector.getSelectedItem() == BINARY) {
            try {
                BinaryUtils.parseBinaryString(JMeterUtils.stripJMeterVariables(this.requestDataField.getText()));
                this.messageField.setText("");
            }
            catch (NumberFormatException notNumber) {
                this.messageField.setText("Error: request data is not in binary format; use format like '0xca 0xfe' or 'ba be' (JMeter variables like ${var} are allowed).");
            }
        } else {
            this.messageField.setText("");
        }
    }
}

