/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.DataPanel;
import eu.luminis.jmeter.wssampler.DataPayloadType;
import eu.luminis.jmeter.wssampler.GuiUtils;
import eu.luminis.jmeter.wssampler.WebSocketSamplerGuiPanel;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class RequestResponseWebSocketSamplerGuiPanel
extends WebSocketSamplerGuiPanel {
    private DataPanel dataPanel;

    public RequestResponseWebSocketSamplerGuiPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel connectionPanel = this.createConnectionPanel();
        this.add(connectionPanel);
        connectionPanel.setAlignmentX(0.0f);
        JSplitPane splitter = new JSplitPane(0);
        this.dataPanel = new DataPanel();
        JPanel requestSettingsPanel = new JPanel(new FlowLayout(0));
        requestSettingsPanel.add(new JLabel("Response (read) timeout (ms): "));
        this.readTimeoutField = new JTextField();
        this.readTimeoutField.setColumns(10);
        JLabel readTimeoutErrorField = new JLabel();
        readTimeoutErrorField.setForeground(GuiUtils.getLookAndFeelColor("TextField.errorForeground"));
        this.addIntegerRangeCheck(this.readTimeoutField, 0, 9999999, readTimeoutErrorField);
        requestSettingsPanel.add(this.readTimeoutField);
        requestSettingsPanel.add(readTimeoutErrorField);
        requestSettingsPanel.setAlignmentX(0.0f);
        this.dataPanel.add(requestSettingsPanel);
        splitter.setTopComponent(this.dataPanel);
        splitter.setBottomComponent(RequestResponseWebSocketSamplerGuiPanel.createAboutPanel(this));
        splitter.setBorder(null);
        this.add(splitter);
        splitter.setAlignmentX(0.0f);
        JPanel stuffIt = new JPanel();
        this.add(stuffIt);
        stuffIt.setAlignmentX(0.0f);
    }

    @Override
    void clearGui() {
        super.clearGui();
        this.dataPanel.clearGui();
        this.setCreateNewConnection(true);
    }

    public String getRequestData() {
        return this.dataPanel.getRequestData();
    }

    public void setRequestData(String requestData) {
        this.dataPanel.setRequestData(requestData);
    }

    public DataPayloadType getType() {
        return this.dataPanel.getType();
    }

    public void setType(DataPayloadType type) {
        this.dataPanel.setType(type);
    }

    public boolean getReadDataFromFile() {
        return this.dataPanel.getReadDataFromFile();
    }

    public void setReadDataFromFile(boolean enable) {
        this.dataPanel.setReadDataFromFile(enable);
    }

    public String getDataFile() {
        return this.dataPanel.getDataFile();
    }

    public void setDataFile(String file) {
        this.dataPanel.setDataFile(file);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 400);
        frame.getContentPane().add(new RequestResponseWebSocketSamplerGuiPanel());
        frame.setVisible(true);
    }
}

