/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.GuiUtils;
import eu.luminis.jmeter.wssampler.SingleReadWebSocketSampler;
import eu.luminis.jmeter.wssampler.WebSocketSamplerGuiPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SingleReadWebSocketSamplerGuiPanel
extends WebSocketSamplerGuiPanel {
    public static final String BINARY = "Binary";
    public static final String TEXT = "Text";
    public static final String ANY = "Text or Binary";
    JComboBox typeSelector;
    JCheckBox optionalSampler;

    public SingleReadWebSocketSamplerGuiPanel() {
        this.init();
        this.setCreateNewConnection(false);
    }

    private void init() {
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 1));
        JPanel connectionPanel = this.createConnectionPanel();
        boxPanel.add(connectionPanel);
        JPanel dataPanel = new JPanel();
        dataPanel.setBorder(BorderFactory.createTitledBorder("Response"));
        dataPanel.setLayout(new BoxLayout(dataPanel, 1));
        JPanel topBar = new JPanel();
        topBar.setLayout(new BoxLayout(topBar, 0));
        String[] typeOptions = new String[]{TEXT, BINARY, ANY};
        this.typeSelector = new JComboBox<String>(typeOptions);
        this.typeSelector.setMaximumSize(this.typeSelector.getMinimumSize());
        topBar.add(this.typeSelector);
        topBar.add(Box.createHorizontalStrut(10));
        topBar.add(Box.createHorizontalGlue());
        dataPanel.add(topBar);
        JPanel requestSettingsPanel = new JPanel(new FlowLayout(0));
        requestSettingsPanel.add(new JLabel("Response (read) timeout (ms): "));
        this.readTimeoutField = new JTextField();
        this.readTimeoutField.setColumns(10);
        JLabel readTimeoutErrorField = new JLabel();
        readTimeoutErrorField.setForeground(GuiUtils.getLookAndFeelColor("TextField.errorForeground"));
        this.addIntegerRangeCheck(this.readTimeoutField, 0, 9999999, readTimeoutErrorField);
        requestSettingsPanel.add(this.readTimeoutField);
        requestSettingsPanel.add(readTimeoutErrorField);
        dataPanel.add(requestSettingsPanel);
        JPanel optionalSettingsPanel = new JPanel(new FlowLayout(0));
        this.optionalSampler = new JCheckBox("Optional read (read timeout will not lead to sampler error)");
        optionalSettingsPanel.add(this.optionalSampler);
        dataPanel.add(optionalSettingsPanel);
        boxPanel.add(dataPanel);
        boxPanel.add(SingleReadWebSocketSamplerGuiPanel.createAboutPanel(this));
        this.setLayout(new BorderLayout());
        this.add((Component)boxPanel, "North");
    }

    @Override
    void clearGui() {
        this.serverField.setText("");
        this.portField.setText("");
        this.pathField.setText("");
        this.setCreateNewConnection(false);
    }

    public SingleReadWebSocketSampler.DataType getType() {
        if (this.typeSelector.getSelectedItem().equals(TEXT)) {
            return SingleReadWebSocketSampler.DataType.Text;
        }
        if (this.typeSelector.getSelectedItem().equals(BINARY)) {
            return SingleReadWebSocketSampler.DataType.Binary;
        }
        if (this.typeSelector.getSelectedItem().equals(ANY)) {
            return SingleReadWebSocketSampler.DataType.Any;
        }
        throw new IllegalStateException();
    }

    public void setType(SingleReadWebSocketSampler.DataType dataType) {
        switch (dataType) {
            case Text: {
                this.typeSelector.setSelectedItem(TEXT);
                break;
            }
            case Binary: {
                this.typeSelector.setSelectedItem(BINARY);
                break;
            }
            case Any: {
                this.typeSelector.setSelectedItem(ANY);
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 400);
        frame.getContentPane().add(new SingleReadWebSocketSamplerGuiPanel());
        frame.setVisible(true);
    }
}

