/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.SamplingAbortedException;
import eu.luminis.jmeter.wssampler.WebsocketGeneralSampler;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.UnexpectedFrameException;
import eu.luminis.websocket.WebSocketClient;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SingleWriteWebSocketSampler
extends WebsocketGeneralSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public SingleWriteWebSocketSampler() {
        super.setName("Single Write WebSocket Sampler");
    }

    @Override
    protected WebSocketClient prepareWebSocketClient(SampleResult result) {
        if (this.getCreateNewConnection()) {
            this.dispose((WebSocketClient)threadLocalCachedConnection.get());
            try {
                URL url = new URL(this.getTLS() ? "https" : "http", this.getServer(), Integer.parseInt(this.getPort()), this.getPath());
                return new WebSocketClient(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException();
            }
        }
        WebSocketClient wsClient = (WebSocketClient)threadLocalCachedConnection.get();
        if (wsClient != null) {
            return wsClient;
        }
        log.error("Sampler '" + this.getName() + "': there is no connection to re-use");
        result.setResponseCode("Sampler error");
        result.setResponseMessage("Sampler configured for using existing connection, but there is no connection");
        return null;
    }

    @Override
    protected Frame doSample(WebSocketClient wsClient, SampleResult result) throws IOException, UnexpectedFrameException, SamplingAbortedException {
        this.sendFrame(wsClient, result, this.getType(), this.getRequestData(), this.getLoadDataFromFile() ? new File(this.getDataFile()) : null);
        return null;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected String validateArguments() {
        String errorMsg = null;
        if (this.getCreateNewConnection() && (errorMsg = this.validatePortNumber(this.getPort())) == null) {
            errorMsg = this.validateConnectionTimeout(this.getConnectTimeout());
        }
        return errorMsg;
    }

    public String getServer() {
        return this.getPropertyAsString("server");
    }

    public void setServer(String server) {
        this.setProperty("server", server);
    }

    public String getPort() {
        return this.getPropertyAsString("port", "80").trim();
    }

    public void setPort(String port) {
        this.setProperty("port", port);
    }

    public String getPath() {
        return this.getPropertyAsString("path");
    }

    public void setPath(String path) {
        this.setProperty("path", path);
    }

    public String getRequestData() {
        return this.getPropertyAsString("requestData");
    }

    public void setRequestData(String requestData) {
        this.setProperty("requestData", requestData);
    }

    public String toString() {
        return "WS Single Write sampler '" + this.getName() + "'";
    }

    public boolean getCreateNewConnection() {
        return this.getPropertyAsBoolean("createNewConnection");
    }

    public void setCreateNewConnection(boolean value) {
        this.setProperty("createNewConnection", value);
    }

    @Override
    public void setReadTimeout(String readTimeout) {
        throw new UnsupportedOperationException();
    }

    public boolean getLoadDataFromFile() {
        return this.getPropertyAsBoolean("loadDataFromFile");
    }

    public void setLoadDataFromFile(boolean value) {
        this.setProperty("loadDataFromFile", value);
    }

    public String getDataFile() {
        return this.getPropertyAsString("dataFile");
    }

    public void setDataFile(String dataFile) {
        this.setProperty("dataFile", dataFile);
    }
}

