/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.BinaryUtils;
import eu.luminis.jmeter.wssampler.DataPayloadType;
import eu.luminis.jmeter.wssampler.FrameFilter;
import eu.luminis.jmeter.wssampler.SamplingAbortedException;
import eu.luminis.websocket.BinaryFrame;
import eu.luminis.websocket.DataFrame;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.HttpUpgradeException;
import eu.luminis.websocket.TextFrame;
import eu.luminis.websocket.UnexpectedFrameException;
import eu.luminis.websocket.WebSocketClient;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class WebsocketSampler
extends AbstractSampler
implements ThreadListener {
    private static final String VAR_WEBSOCKET_LAST_FRAME_FINAL = "websocket.last_frame_final";
    public static final String WS_THREAD_STOP_POLICY_PROPERTY = "websocket.thread.stop.policy";
    public static final int MIN_CONNECTION_TIMEOUT = 1;
    public static final int MAX_CONNECTION_TIMEOUT = 999999;
    public static final int MIN_READ_TIMEOUT = 0;
    public static final int MAX_READ_TIMEOUT = 9999999;
    public static final int DEFAULT_WS_PORT = 80;
    protected static final boolean USE_CACHED_SSL_CONTEXT = JMeterUtils.getPropDefault((String)"https.use.cached.ssl.context", (boolean)true);
    protected static final ThreadLocal<WebSocketClient> threadLocalCachedConnection = new ThreadLocal();
    protected HeaderManager headerManager;
    protected CookieManager cookieManager;
    protected List<FrameFilter> frameFilters = new ArrayList<FrameFilter>();
    protected int readTimeout;
    protected int connectTimeout;
    private static String proxyHost;
    private static int proxyPort;
    private static List<String> nonProxyHosts;
    private static List<String> nonProxyWildcards;
    private static String proxyUsername;
    private static String proxyPassword;
    private static ThreadStopPolicy threadStopPolicy;
    private static final Function<String, String> PREPROCESSOR_NOOP;
    private static final Function<String, String> PREPROCESSOR_STOMP;

    protected abstract String validateArguments();

    protected abstract WebSocketClient prepareWebSocketClient(SampleResult var1);

    public void clearTestElementChildren() {
        this.frameFilters.clear();
    }

    public SampleResult sample(Entry entry) {
        Logger log = this.getLogger();
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        String validationError = this.validateArguments();
        if (validationError != null) {
            result.setResponseCode("Sampler error");
            result.setResponseMessage("Sampler error: " + validationError);
            return result;
        }
        this.readTimeout = Integer.parseInt(this.getReadTimeout());
        this.connectTimeout = Integer.parseInt(this.getConnectTimeout());
        WebSocketClient wsClient = this.prepareWebSocketClient(result);
        if (wsClient == null) {
            return result;
        }
        if (!(wsClient.isConnected() || this.headerManager == null && this.cookieManager == null)) {
            Map<String, String> additionalHeaders = this.convertHeaders(this.headerManager);
            String cookieHeaderValue = this.getCookieHeaderValue(this.cookieManager, wsClient.getConnectUrl());
            if (cookieHeaderValue != null) {
                additionalHeaders.put("Cookie", cookieHeaderValue);
            }
            wsClient.setAdditionalUpgradeRequestHeaders(additionalHeaders);
            result.setRequestHeaders(additionalHeaders.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining("\n")));
        }
        boolean gotNewConnection = false;
        result.sampleStart();
        try {
            Map<String, String> responseHeaders = null;
            if (!wsClient.isConnected()) {
                if (this.useTLS() && !USE_CACHED_SSL_CONTEXT) {
                    ((JsseSSLManager)SSLManager.getInstance()).resetContext();
                }
                if (this.useProxy(wsClient.getConnectUrl().getHost())) {
                    wsClient.useProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
                }
                result.setSamplerData("Connect URL:\n" + this.getConnectUrl(wsClient.getConnectUrl()) + "\n");
                WebSocketClient.HttpResult httpResult = wsClient.connect(this.connectTimeout, this.readTimeout);
                responseHeaders = httpResult.responseHeaders;
                result.connectEnd();
                result.setHeadersSize(httpResult.responseSize);
                result.setSentBytes((long)httpResult.requestSize);
                gotNewConnection = true;
            } else {
                result.setSamplerData("Connect URL:\n" + this.getConnectUrl(wsClient.getConnectUrl()) + "\n(using existing connection)\n");
            }
            Frame response = this.doSample(wsClient, result);
            result.sampleEnd();
            if (response != null) {
                result.setHeadersSize(result.getHeadersSize() + response.getSize() - response.getPayloadSize());
                result.setBodySize(result.getBodySize() + response.getPayloadSize());
            }
            if (gotNewConnection) {
                result.setResponseCode("101");
                result.setResponseMessage("Switching Protocols");
                result.setResponseHeaders(responseHeaders.entrySet().stream().map(header -> (String)header.getKey() + ": " + (String)header.getValue()).collect(Collectors.joining("\n")));
            } else {
                result.setResponseCodeOK();
                result.setResponseMessage("OK");
            }
            this.postProcessResponse(response, result);
            result.setSuccessful(true);
        }
        catch (UnexpectedFrameException e2) {
            this.handleUnexpectedFrameException(e2, result);
        }
        catch (MalformedURLException e3) {
            throw new RuntimeException(e3);
        }
        catch (HttpUpgradeException upgradeError) {
            result.sampleEnd();
            this.getLogger().debug("Http upgrade error in sampler '" + this.getName() + "'.", (Throwable)upgradeError);
            result.setResponseCode(upgradeError.getStatusCodeAsString());
            result.setResponseMessage(upgradeError.getMessage());
        }
        catch (IOException ioExc) {
            if (result.getEndTime() == 0L) {
                result.sampleEnd();
            }
            this.getLogger().debug("I/O Error in sampler '" + this.getName() + "'.", (Throwable)ioExc);
            result.setResponseCode("Websocket I/O error");
            result.setResponseMessage("WebSocket I/O error: " + ioExc.getMessage());
        }
        catch (SamplingAbortedException abort) {
            if (result.getEndTime() == 0L) {
                result.sampleEnd();
            }
        }
        catch (Exception error) {
            if (result.getEndTime() == 0L) {
                result.sampleEnd();
            }
            this.getLogger().error("Unhandled error in sampler '" + this.getName() + "'.", (Throwable)error);
            result.setResponseCode("Sampler error");
            result.setResponseMessage("Sampler error: " + error);
        }
        if (gotNewConnection) {
            threadLocalCachedConnection.set(wsClient);
        } else if (!wsClient.isConnected()) {
            threadLocalCachedConnection.set(null);
        }
        return result;
    }

    protected abstract Frame doSample(WebSocketClient var1, SampleResult var2) throws IOException, UnexpectedFrameException, SamplingAbortedException;

    protected void postProcessResponse(Frame response, SampleResult result) {
    }

    protected void handleUnexpectedFrameException(UnexpectedFrameException e, SampleResult result) {
        result.sampleEnd();
        this.getLogger().error("Unexpected frame type received in sampler '" + this.getName() + "': " + e.getReceivedFrame());
        result.setResponseCode("Sampler error: unexpected frame type (" + e.getReceivedFrame().getTypeAsString() + ").");
        result.setResponseMessage("Received: " + e.getReceivedFrame());
    }

    protected Frame sendBinaryFrame(WebSocketClient wsClient, SampleResult result, String requestData, File requestDataFile) throws IOException, SamplingAbortedException {
        String printableRequestData;
        byte[] binRequestData;
        try {
            if (requestDataFile != null) {
                binRequestData = Files.readAllBytes(requestDataFile.toPath());
                printableRequestData = BinaryUtils.formatBinary(binRequestData, 100, "...");
            } else {
                binRequestData = BinaryUtils.parseBinaryString(requestData);
                printableRequestData = requestData;
            }
        }
        catch (NumberFormatException noNumber) {
            result.sampleEnd();
            this.getLogger().error("Sampler '" + this.getName() + "': request data is not binary: " + requestData);
            result.setResponseCode("Sampler Error");
            result.setResponseMessage("Request data is not binary: " + requestData);
            throw new SamplingAbortedException();
        }
        result.setSamplerData(result.getSamplerData() + "\nRequest data:\n" + printableRequestData + "\n");
        return wsClient.sendBinaryFrame(binRequestData);
    }

    protected Frame sendTextFrame(WebSocketClient wsClient, SampleResult result, String requestData, File requestDataFile, Function<String, String> requestPreprocessor) throws IOException {
        String rawRequestData = requestDataFile != null ? new String(Files.readAllBytes(requestDataFile.toPath()), StandardCharsets.UTF_8) : requestData;
        String processedRequestData = requestPreprocessor == null ? rawRequestData : requestPreprocessor.apply(rawRequestData);
        result.setSamplerData(result.getSamplerData() + "\nRequest data:\n" + processedRequestData + "\n");
        return wsClient.sendTextFrame(processedRequestData);
    }

    protected void sendFrame(WebSocketClient wsClient, SampleResult result, DataPayloadType type, String requestData, File requestDataFile) throws SamplingAbortedException, IOException {
        try {
            Frame sentFrame;
            switch (type) {
                case Binary: {
                    sentFrame = this.sendBinaryFrame(wsClient, result, requestData, requestDataFile);
                    break;
                }
                case TextStomp: {
                    sentFrame = this.sendTextFrame(wsClient, result, requestData, requestDataFile, PREPROCESSOR_STOMP);
                    break;
                }
                default: {
                    sentFrame = this.sendTextFrame(wsClient, result, requestData, requestDataFile, PREPROCESSOR_NOOP);
                }
            }
            result.setSentBytes((long)sentFrame.getSize());
        }
        catch (AccessDeniedException | NoSuchFileException fileError) {
            result.sampleEnd();
            String rootCause = "";
            if (fileError instanceof NoSuchFileException) {
                rootCause = "file '" + fileError.getFile() + "' not found";
            } else if (fileError instanceof AccessDeniedException) {
                rootCause = "file '" + fileError.getFile() + "' not readable";
            }
            this.getLogger().error("Sampler '" + this.getName() + "': can't load request data; " + rootCause);
            result.setResponseCode("Sampler Error");
            result.setResponseMessage("Request data cannot be loaded, " + rootCause);
            throw new SamplingAbortedException();
        }
    }

    protected Frame readFrame(WebSocketClient wsClient, SampleResult result, DataPayloadType type) throws IOException, UnexpectedFrameException {
        Frame receivedFrame = this.readFrame(wsClient, result);
        switch (type) {
            case Binary: {
                if (receivedFrame.isBinary()) break;
                this.getLogger().warn("Expected type is " + (Object)((Object)type) + ", but received frame is not a binary");
                throw new UnexpectedFrameException(receivedFrame);
            }
            case TextStomp: 
            case Text: {
                if (!receivedFrame.isBinary()) break;
                this.getLogger().warn("Expected type is " + (Object)((Object)type) + ", but received frame is a binary");
                throw new UnexpectedFrameException(receivedFrame);
            }
            default: {
                this.getLogger().warn("Unexpected type: '" + (Object)((Object)type) + "'");
                throw new UnexpectedFrameException(receivedFrame);
            }
        }
        return receivedFrame;
    }

    protected Frame readFrame(WebSocketClient wsClient, SampleResult result) throws IOException, UnexpectedFrameException {
        Frame receivedFrame = !this.frameFilters.isEmpty() ? this.frameFilters.get(0).receiveFrame(this.frameFilters.subList(1, this.frameFilters.size()), wsClient, this.readTimeout, result) : wsClient.receiveFrame(this.readTimeout);
        return receivedFrame;
    }

    public void addTestElement(TestElement element) {
        if (element instanceof HeaderManager) {
            this.headerManager = this.getMergedHeaderManager((HeaderManager)element);
        } else if (element instanceof CookieManager) {
            this.cookieManager = (CookieManager)element;
        } else if (element instanceof FrameFilter) {
            if (!this.frameFilters.contains(element)) {
                this.frameFilters.add((FrameFilter)element);
                this.getLogger().debug("Added filter " + element + " to sampler " + (Object)((Object)this) + "; filter list is now " + this.frameFilters);
            } else {
                this.getLogger().debug("Ignoring additional filter " + element + "; already present in chain.");
            }
        } else {
            super.addTestElement(element);
        }
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        WebSocketClient webSocketClient;
        if (threadStopPolicy != ThreadStopPolicy.NONE && (webSocketClient = threadLocalCachedConnection.get()) != null) {
            if (threadStopPolicy.equals((Object)ThreadStopPolicy.WSCLOSE)) {
                try {
                    this.getLogger().debug("Test thread finished: closing WebSocket connection");
                    webSocketClient.sendClose(1000, "test thread finished");
                }
                catch (Exception e) {
                    this.getLogger().error("Closing WebSocket connection failed", (Throwable)e);
                }
            } else {
                this.getLogger().debug("Test thread finsished: closing connection");
            }
            webSocketClient.dispose();
            threadLocalCachedConnection.remove();
        }
    }

    public HeaderManager getMergedHeaderManager(HeaderManager value) {
        HeaderManager currentHeaderMgr = this.getHeaderManager();
        HeaderManager mergedHeaderMgr = value;
        if (currentHeaderMgr != null) {
            mergedHeaderMgr = currentHeaderMgr.merge((TestElement)value, true);
            this.getLogger().debug("Existing HeaderManager " + currentHeaderMgr.getName() + " merged with " + mergedHeaderMgr.getName());
            for (int i = 0; i < mergedHeaderMgr.getHeaders().size(); ++i) {
                this.getLogger().debug(mergedHeaderMgr.getHeader(i).getName() + " = " + mergedHeaderMgr.getHeader(i).getValue());
            }
        }
        return mergedHeaderMgr;
    }

    public HeaderManager getHeaderManager() {
        return this.headerManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    protected String getConnectUrl(URL url) {
        String path = url.getFile();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ("http".equals(url.getProtocol())) {
            return "ws://" + url.getHost() + ":" + url.getPort() + path;
        }
        if ("https".equals(url.getProtocol())) {
            return "wss://" + url.getHost() + ":" + url.getPort() + path;
        }
        this.getLogger().error("Invalid protocol in sampler '" + this.getName() + "': " + url.getProtocol());
        return "";
    }

    protected void processDefaultReadResponse(DataFrame response, DataPayloadType type, SampleResult result) {
        switch (type) {
            case Binary: {
                byte[] responseData = ((BinaryFrame)response).getBinaryData();
                result.setResponseData(responseData);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Sampler '" + this.getName() + "' received " + response.getTypeAsString() + " frame with data: " + BinaryUtils.formatBinary(responseData));
                }
                result.setDataType("bin");
                break;
            }
            default: {
                result.setResponseData(((TextFrame)response).getText(), StandardCharsets.UTF_8.name());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Sampler '" + this.getName() + "' received " + response.getTypeAsString() + " frame with text: '" + ((TextFrame)response).getText() + "'");
                }
                result.setDataType("text");
            }
        }
        JMeterContextService.getContext().getVariables().put(VAR_WEBSOCKET_LAST_FRAME_FINAL, String.valueOf(response.isFinalFragment()));
    }

    protected String validatePortNumber(String value) {
        try {
            int port = Integer.parseInt(value);
            if (port <= 0 || port > 65535) {
                return "Port number '" + value + "' is not valid.";
            }
            if (port == 80 && this.useTLS()) {
                this.getLogger().warn("Sampler '" + this.getName() + "' is using wss protocol (with TLS) on port 80; this might indicate a configuration error");
            }
            if (port == 443 && !this.useTLS()) {
                this.getLogger().warn("Sampler '" + this.getName() + "' is using ws protocol (without TLS) on port 443; this might indicate a configuration error");
            }
        }
        catch (NumberFormatException notAnumber) {
            return "Port number '" + value + "' is not a number.";
        }
        return null;
    }

    protected String validateConnectionTimeout(String value) {
        try {
            int connectTimeout = Integer.parseInt(value);
            if (connectTimeout < 1 || connectTimeout > 999999) {
                return "Connection timeout '" + connectTimeout + "' is not valid; should between " + 1 + " and " + 999999;
            }
        }
        catch (NumberFormatException notAnumber) {
            return "Connection timeout '" + value + "' is not a number.";
        }
        return null;
    }

    protected String validateReadTimeout(String value) {
        try {
            int readTimeout = Integer.parseInt(value);
            if (readTimeout < 0 || readTimeout > 9999999) {
                return "Read timeout '" + readTimeout + "' is not valid; should between " + 0 + " and " + 9999999;
            }
        }
        catch (NumberFormatException notAnumber) {
            return "Read timeout '" + value + "' is not a number.";
        }
        return null;
    }

    protected void dispose(WebSocketClient webSocketClient) {
        if (webSocketClient != null) {
            this.getLogger().debug("Sampler  '" + this.getName() + "': closing streams for existing websocket connection");
            webSocketClient.dispose();
        }
    }

    private Map<String, String> convertHeaders(HeaderManager headerManager) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (headerManager != null) {
            for (int i = 0; i < headerManager.size(); ++i) {
                Header header = headerManager.get(i);
                if (header.getName().trim().length() > 0) {
                    headers.put(header.getName(), header.getValue());
                    continue;
                }
                this.getLogger().debug("Ignoring header with no name");
            }
        }
        return headers;
    }

    private String getCookieHeaderValue(CookieManager cookieManager, URL url) {
        if (cookieManager != null) {
            return cookieManager.getCookieHeaderForURL(url);
        }
        return null;
    }

    static void initProxyConfiguration() {
        proxyHost = System.getProperty("http.proxyHost", null);
        proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "0"));
        List<String> nonProxyHostList = Arrays.asList(System.getProperty("http.nonProxyHosts", "").split("\\|"));
        nonProxyHosts = nonProxyHostList.stream().filter(h -> !h.startsWith("*")).collect(Collectors.toList());
        nonProxyWildcards = nonProxyHostList.stream().filter(h -> h.startsWith("*")).map(w -> w.substring(1)).collect(Collectors.toList());
        proxyUsername = JMeterUtils.getPropDefault((String)"http.proxyUser", null);
        proxyPassword = JMeterUtils.getPropDefault((String)"http.proxyPass", null);
    }

    boolean useProxy(String host) {
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            return !nonProxyHosts.contains(host) && nonProxyWildcards.stream().filter(wildcard -> host.endsWith((String)wildcard)).count() == 0L;
        }
        return false;
    }

    static void initThreadStopPolicy() {
        String propertyValue = JMeterUtils.getPropDefault((String)WS_THREAD_STOP_POLICY_PROPERTY, (String)"none");
        try {
            threadStopPolicy = ThreadStopPolicy.valueOf(propertyValue.trim().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean useTLS() {
        return this.getTLS();
    }

    public String getConnectTimeout() {
        return this.getPropertyAsString("connectTimeout", "20000").trim();
    }

    public void setConnectTimeout(String connectTimeout) {
        this.setProperty("connectTimeout", connectTimeout);
    }

    public String getReadTimeout() {
        return this.getPropertyAsString("readTimeout", "6000").trim();
    }

    public void setReadTimeout(String readTimeout) {
        this.setProperty("readTimeout", readTimeout);
    }

    public boolean getTLS() {
        return this.getPropertyAsBoolean("TLS");
    }

    public void setTLS(boolean value) {
        this.setProperty("TLS", value);
    }

    protected abstract Logger getLogger();

    private static void checkForOtherWebsocketPlugins() {
        try {
            WebsocketSampler.class.getClassLoader().loadClass("JMeter.plugins.functional.samplers.websocket.WebSocketSampler");
            LoggingManager.getLoggerForClass().warn("Detected Maciej Zaleski's WebSocket Sampler plugin is installed too, which is not compatible with this plugin (but both can co-exist).");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            LoggingManager.getLoggerForClass().error("Error while loading class", (Throwable)e);
        }
    }

    private static void checkJMeterVersion() {
        try {
            String jmeterVersion = JMeterUtils.getJMeterVersion();
            Matcher m = Pattern.compile("(\\d+)\\.(\\d+).*").matcher(jmeterVersion);
            if (m.matches()) {
                int major = Integer.parseInt(m.group(1));
                int minor = Integer.parseInt(m.group(2));
                if (major < 3 || major == 3 && minor < 1) {
                    String errorMsg = "This version of the WebSocketSamplers plugin requires JMeter 3.1 or later.";
                    if (GuiPackage.getInstance() != null) {
                        SwingUtilities.invokeLater(() -> GuiPackage.showErrorMessage((String)errorMsg, (String)"Incompatible versions"));
                    } else {
                        LoggingManager.getLoggerForClass().error(errorMsg);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        threadStopPolicy = ThreadStopPolicy.NONE;
        PREPROCESSOR_NOOP = text -> text;
        PREPROCESSOR_STOMP = text -> text.replaceAll("\\^@", "\u0000");
        WebsocketSampler.checkJMeterVersion();
        WebsocketSampler.initProxyConfiguration();
        WebsocketSampler.checkForOtherWebsocketPlugins();
        WebsocketSampler.initThreadStopPolicy();
    }

    static enum ThreadStopPolicy {
        NONE,
        TCPCLOSE,
        WSCLOSE;

    }
}

