/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private InputStream wrappedStream;
    private int count = 0;

    public CountingInputStream(InputStream in) {
        this.wrappedStream = in;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int read = this.wrappedStream.read();
        ++this.count;
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.wrappedStream.read(b);
        ++this.count;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.wrappedStream.read(b, off, len);
        this.count += len;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.wrappedStream.available();
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.wrappedStream.markSupported();
    }
}

