/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.assertions;

import eu.luminis.jmeter.assertions.BinaryContentAssertion;
import eu.luminis.jmeter.assertions.BinaryContentAssertionGuiPanel;
import java.awt.BorderLayout;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.testelement.TestElement;

public class BinaryContentAssertionGUI
extends AbstractAssertionGui {
    private BinaryContentAssertionGuiPanel settingsPanel;

    public BinaryContentAssertionGUI() {
        this.init();
    }

    public void clearGui() {
        super.clearGui();
        this.settingsPanel.clearGui();
    }

    public String getStaticLabel() {
        return "Binary Response Assertion";
    }

    public String getLabelResource() {
        return null;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.settingsPanel = new BinaryContentAssertionGuiPanel();
        this.add(this.settingsPanel, "Center");
    }

    public TestElement createTestElement() {
        BinaryContentAssertion element = new BinaryContentAssertion();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof BinaryContentAssertion) {
            BinaryContentAssertion ra = (BinaryContentAssertion)el;
            ra.setComparisonValue(this.settingsPanel.binaryContent.getText());
            if (this.settingsPanel.containsButton.isSelected() && this.settingsPanel.doesButton.isSelected()) {
                ra.setComparisonType(BinaryContentAssertion.ComparisonType.Contains);
            } else if (this.settingsPanel.containsButton.isSelected() && !this.settingsPanel.doesButton.isSelected()) {
                ra.setComparisonType(BinaryContentAssertion.ComparisonType.NotContains);
            } else if (this.settingsPanel.equalsButton.isSelected() && this.settingsPanel.doesButton.isSelected()) {
                ra.setComparisonType(BinaryContentAssertion.ComparisonType.Equals);
            } else if (this.settingsPanel.equalsButton.isSelected() && !this.settingsPanel.doesButton.isSelected()) {
                ra.setComparisonType(BinaryContentAssertion.ComparisonType.NotEquals);
            } else if (this.settingsPanel.startsWithButton.isSelected() && this.settingsPanel.doesButton.isSelected()) {
                ra.setComparisonType(BinaryContentAssertion.ComparisonType.StartsWith);
            } else if (this.settingsPanel.startsWithButton.isSelected() && !this.settingsPanel.doesButton.isSelected()) {
                ra.setComparisonType(BinaryContentAssertion.ComparisonType.NotStartsWith);
            } else {
                throw new RuntimeException("Program error");
            }
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        BinaryContentAssertion assertion = (BinaryContentAssertion)element;
        this.settingsPanel.binaryContent.setText(assertion.getComparisonValue());
        this.settingsPanel.setDoes(assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.Contains || assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.Equals || assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.StartsWith);
        if (assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.Contains || assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.NotContains) {
            this.settingsPanel.setContains();
        } else if (assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.Equals || assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.NotEquals) {
            this.settingsPanel.setEquals();
        } else if (assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.StartsWith || assertion.getComparisonType() == BinaryContentAssertion.ComparisonType.NotStartsWith) {
            this.settingsPanel.setStartsWith();
        } else {
            throw new RuntimeException("Program error");
        }
    }
}

