/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.WebsocketSampler;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.UnexpectedFrameException;
import eu.luminis.websocket.WebSocketClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class OpenWebSocketSampler
extends WebsocketSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    protected WebSocketClient prepareWebSocketClient(SampleResult result) {
        this.dispose((WebSocketClient)threadLocalCachedConnection.get());
        try {
            URL url = new URL(this.getTLS() ? "https" : "http", this.getServer(), Integer.parseInt(this.getPort()), this.getPath());
            return new WebSocketClient(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException();
        }
    }

    @Override
    protected Frame doSample(WebSocketClient wsClient, SampleResult result) throws IOException, UnexpectedFrameException {
        return null;
    }

    @Override
    protected String validateArguments() {
        String errorMsg = this.validatePortNumber(this.getPort());
        if (errorMsg == null) {
            errorMsg = this.validateConnectionTimeout(this.getConnectTimeout());
        }
        if (errorMsg == null) {
            errorMsg = this.validateReadTimeout(this.getReadTimeout());
        }
        return errorMsg;
    }

    @Override
    public void addTestElement(TestElement element) {
        if (element instanceof HeaderManager) {
            this.headerManager = (HeaderManager)element;
        } else {
            super.addTestElement(element);
        }
    }

    private Map<String, String> convertHeaders(HeaderManager headerManager) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (int i = 0; i < headerManager.size(); ++i) {
            Header header = headerManager.get(i);
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    public String getServer() {
        return this.getPropertyAsString("server");
    }

    public void setServer(String server) {
        this.setProperty("server", server);
    }

    public String getPort() {
        return this.getPropertyAsString("port", "80").trim();
    }

    public void setPort(String port) {
        this.setProperty("port", port);
    }

    public String getPath() {
        return this.getPropertyAsString("path");
    }

    public void setPath(String path) {
        this.setProperty("path", path);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

