/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.FrameFilter;
import eu.luminis.jmeter.wssampler.WebsocketSampler;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.UnexpectedFrameException;
import eu.luminis.websocket.WebSocketClient;
import java.io.IOException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PingPongSampler
extends WebsocketSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    protected WebSocketClient prepareWebSocketClient(SampleResult result) {
        WebSocketClient wsClient = (WebSocketClient)threadLocalCachedConnection.get();
        if (wsClient == null) {
            log.error("Sampler '" + this.getName() + "': there is no connection to re-use");
            result.setResponseCode("Sampler error");
            result.setResponseMessage("Sampler must use existing connection, but there is no connection");
            return null;
        }
        return wsClient;
    }

    @Override
    public Frame doSample(WebSocketClient wsClient, SampleResult result) throws IOException, UnexpectedFrameException {
        if (this.getType().equals((Object)Type.PingPong)) {
            Frame sentFrame = wsClient.sendPingFrame();
            result.setSentBytes((long)sentFrame.getSize());
            if (!this.frameFilters.isEmpty()) {
                Frame receivedFrame = ((FrameFilter)((Object)this.frameFilters.get(0))).receiveFrame(this.frameFilters.subList(1, this.frameFilters.size()), wsClient, this.readTimeout, result);
                if (receivedFrame.isPong()) {
                    return receivedFrame;
                }
                throw new UnexpectedFrameException(receivedFrame);
            }
            return wsClient.receivePong(this.readTimeout);
        }
        Frame sentFrame = wsClient.sendPongFrame();
        result.setSentBytes((long)sentFrame.getSize());
        return null;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected String validateArguments() {
        String errorMsg = this.validateReadTimeout(this.getReadTimeout());
        return errorMsg;
    }

    public Type getType() {
        return Type.valueOf(this.getPropertyAsString("type", Type.PingPong.name()));
    }

    public void setType(Type type) {
        this.setProperty("type", type.name());
    }

    static enum Type {
        PingPong,
        Pong;

    }
}

