/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.PingPongSampler;
import eu.luminis.jmeter.wssampler.WebSocketSamplerGuiPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PingPongSamplerGuiPanel
extends JPanel {
    JTextField readTimeoutField;
    private final JRadioButton pingPongOption;
    private JLabel timeoutLabel;
    private final JRadioButton pongOption;

    public PingPongSamplerGuiPanel() {
        this.setLayout(new BorderLayout());
        JPanel requestSettingsPanel = new JPanel();
        requestSettingsPanel.setLayout(new BoxLayout(requestSettingsPanel, 1));
        requestSettingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Behaviour"), BorderFactory.createEmptyBorder(5, 5, 0, 0)));
        this.pingPongOption = new JRadioButton("ping/pong (send ping, expect pong)");
        requestSettingsPanel.add(this.pingPongOption);
        this.pingPongOption.setAlignmentX(0.0f);
        this.pongOption = new JRadioButton("pong (just send pong)");
        requestSettingsPanel.add(this.pongOption);
        this.pongOption.setAlignmentX(0.0f);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.pingPongOption);
        buttonGroup.add(this.pongOption);
        JPanel readTimeoutPanel = new JPanel(new FlowLayout(0));
        this.timeoutLabel = new JLabel("Pong (read) timeout (ms): ");
        readTimeoutPanel.add(this.timeoutLabel);
        this.readTimeoutField = new JTextField();
        this.readTimeoutField.setColumns(5);
        readTimeoutPanel.add(this.readTimeoutField);
        readTimeoutPanel.setAlignmentX(0.0f);
        requestSettingsPanel.add(readTimeoutPanel);
        this.pingPongOption.addItemListener(e -> this.updateEnabledState(e.getStateChange() == 1));
        this.pingPongOption.setSelected(true);
        this.updateEnabledState(true);
        this.add((Component)requestSettingsPanel, "North");
        this.add(WebSocketSamplerGuiPanel.createAboutPanel(this));
    }

    public void clearGui() {
        this.readTimeoutField.setText("");
    }

    private void updateEnabledState(boolean isPingPong) {
        this.readTimeoutField.setEnabled(isPingPong);
        this.timeoutLabel.setEnabled(isPingPong);
    }

    public PingPongSampler.Type getType() {
        if (this.pingPongOption.isSelected()) {
            return PingPongSampler.Type.PingPong;
        }
        return PingPongSampler.Type.Pong;
    }

    public void setType(PingPongSampler.Type type) {
        boolean isPingPong = type.equals((Object)PingPongSampler.Type.PingPong);
        this.pingPongOption.setSelected(isPingPong);
        this.pongOption.setSelected(!isPingPong);
        this.updateEnabledState(isPingPong);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 400);
        frame.setLocation(new Point(400, 400));
        frame.getContentPane().add(new PingPongSamplerGuiPanel());
        frame.setVisible(true);
    }
}

