/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import eu.luminis.websocket.ControlFrame;
import java.nio.charset.StandardCharsets;

public class CloseFrame
extends ControlFrame {
    private Integer closeStatus;
    private String closeReason;
    private int payloadSize;

    public CloseFrame(int status, String requestData) {
        this.closeStatus = status;
        this.closeReason = requestData;
        this.payloadSize = requestData.getBytes().length;
    }

    public CloseFrame() {
    }

    public CloseFrame(byte[] payload, int size) {
        super(size);
        this.payloadSize = payload.length;
        if (payload.length >= 2) {
            this.closeStatus = payload[0] << 8 | payload[1] & 0xFF;
        }
        if (payload.length > 2) {
            this.closeReason = new String(payload, 2, payload.length - 2);
        }
    }

    public Integer getCloseStatus() {
        return this.closeStatus;
    }

    public String getCloseReason() {
        return this.closeReason;
    }

    @Override
    public boolean isClose() {
        return true;
    }

    public String toString() {
        return "Close frame with status code " + this.closeStatus + " and close reason '" + this.closeReason + "'";
    }

    @Override
    protected byte[] getPayload() {
        if (this.closeStatus != null) {
            byte[] data = this.closeReason != null ? this.closeReason.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            byte[] payload = new byte[2 + data.length];
            System.arraycopy(data, 0, payload, 2, data.length);
            payload[0] = (byte)(this.closeStatus >> 8);
            payload[1] = (byte)(this.closeStatus & 0xFF);
            return payload;
        }
        return new byte[0];
    }

    @Override
    protected byte getOpCode() {
        return 8;
    }

    @Override
    public String getTypeAsString() {
        return "close";
    }

    @Override
    public int getPayloadSize() {
        return this.payloadSize;
    }
}

