/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class FontDataOutputStream
extends DataOutputStream {
    public static final Charset OPEN_TYPE_CHARSET = Charset.forName("ISO-8859-1");
    private final Charset encoding;

    public FontDataOutputStream(Charset encoding) {
        super(new ByteArrayOutputStream());
        this.encoding = encoding;
    }

    public FontDataOutputStream() {
        super(new ByteArrayOutputStream());
        this.encoding = OPEN_TYPE_CHARSET;
    }

    public byte[] toByteArray() {
        return ((ByteArrayOutputStream)this.out).toByteArray();
    }

    public void writeString(String string) throws IOException {
        byte[] bytes = string.getBytes(this.encoding);
        this.out.write(bytes);
    }

    public void writeUnsignedShort(int num) throws IOException {
        this.writeShort(num);
    }

    public void writeUnsignedInt(int num) throws IOException {
        this.writeInt(num);
    }

    public void writeUnsignedInt8(int num) throws IOException {
        byte int8 = (byte)(num >>> 24);
        this.writeByte(int8);
    }

    public void write32Fixed(float num) throws IOException {
        this.writeShort((int)num);
        float decimalOnlyVal = num - (float)((int)num);
        int decimalVal = (int)(decimalOnlyVal * 65536.0f);
        this.writeUnsignedShort(decimalVal);
    }

    public int currentPosition() {
        return ((ByteArrayOutputStream)this.out).size();
    }
}

