/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.LinkedList;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.opentype.GlyphTable;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.opentype.TtfGlyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlyphLocationTable
extends OpenTypeTable {
    private static final Logger log = LoggerFactory.getLogger(GlyphLocationTable.class);
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, isArray=true, ignoreIf="isLongOffsets", arrayLength="getNumGlyphs")
    Integer[] shortOffsets;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG, isArray=true, includeIf="isLongOffsets", arrayLength="getNumGlyphs")
    Long[] longOffsets;

    @Override
    public String getTableType() {
        return "loca";
    }

    public int getNumGlyphs() {
        return this.font.getMxap().getNumGlyphs() + 1;
    }

    public boolean isLongOffsets() {
        return this.font.getHead().isLongIndexToLocFormat();
    }

    @Override
    void normalize() throws IOException {
        GlyphTable glyf = this.font.getGlyfTable();
        if (glyf == null) {
            return;
        }
        LinkedList<Long> offsets = new LinkedList<Long>();
        offsets.add(0L);
        int posOn = 0;
        for (TtfGlyph glyphOn : glyf.getGlyphs()) {
            posOn = (int)((long)posOn + (long)glyphOn.generateData().length);
            offsets.add(Long.valueOf(posOn));
        }
        if (this.isLongOffsets()) {
            this.longOffsets = offsets.toArray(new Long[offsets.size()]);
        } else {
            this.shortOffsets = new Integer[offsets.size()];
            for (int i = 0; i < offsets.size(); ++i) {
                this.shortOffsets[i] = (int)((Long)offsets.get(i) / 2L);
            }
        }
    }

    public Long[] getOffsets() {
        if (this.isLongOffsets()) {
            return this.longOffsets;
        }
        Long[] calcedShortOffsets = new Long[this.shortOffsets.length];
        for (int i = 0; i < this.shortOffsets.length; ++i) {
            calcedShortOffsets[i] = this.shortOffsets[i] * 2;
        }
        return calcedShortOffsets;
    }
}

