/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.NameRecord;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.opentype.OtfNameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameTable
extends OpenTypeTable {
    static final int NAME_TABLE_HEADER_SIZE = 6;
    private static Logger log = LoggerFactory.getLogger(NameTable.class);
    private static final OtfNameConstants.Language defaultLanguage = OtfNameConstants.Language.UNITED_STATES;
    private List<NameRecord> nameRecords = new ArrayList<NameRecord>();
    private int formatSelector = 0;

    public static NameTable createDefaultTable() {
        NameTable table = new NameTable();
        table.setCopyright("Default Copyright");
        table.setFontFamily("DefaultFamily");
        table.setFontSubFamily("Normal");
        table.setVersion("Version 1.1");
        table.setUniqueId(UUID.randomUUID().toString().replace("-", ""));
        table.setFontFullName("DefaultFontFullName");
        table.setPostScriptName("DefaultPostScriptName");
        return table;
    }

    @Override
    protected boolean isParsingImplemented() {
        return false;
    }

    @Override
    public String getTableType() {
        return "name";
    }

    public String getName(OtfNameConstants.RecordType type) {
        for (NameRecord recordOn : this.nameRecords) {
            if (recordOn.nameID != type.getValue()) continue;
            return recordOn.getRawString();
        }
        return null;
    }

    private void addName(String name, OtfNameConstants.RecordType type, OtfNameConstants.Language language) {
        this.deleteExisting(type, language);
        NameRecord windowsRecord = NameRecord.createWindowsRecord(name, type, language);
        this.nameRecords.add(windowsRecord);
        NameRecord macRecord = NameRecord.createMacRecord(name, type, language);
        this.nameRecords.add(macRecord);
    }

    private void deleteExisting(OtfNameConstants.RecordType type, OtfNameConstants.Language language) {
        LinkedList<NameRecord> deleteList = new LinkedList<NameRecord>();
        for (NameRecord recordOn : this.nameRecords) {
            if (recordOn.nameID != type.getValue()) continue;
            deleteList.add(recordOn);
        }
        for (NameRecord recordOn : deleteList) {
            this.nameRecords.remove(recordOn);
        }
    }

    @Override
    protected byte[] generateUnpaddedData() throws IOException {
        FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        writer.writeUnsignedShort(this.formatSelector);
        writer.writeUnsignedShort(this.nameRecords.size());
        writer.writeUnsignedShort(this.getOffsetToStringStorage());
        this.calculateOffsets();
        Collections.sort(this.nameRecords, new Comparator<NameRecord>(){

            @Override
            public int compare(NameRecord o1, NameRecord o2) {
                if (o1.platformID != o2.platformID) {
                    return o1.platformID < o2.platformID ? -1 : 1;
                }
                return o1.nameID < o2.nameID ? -1 : (o1.nameID == o2.nameID ? 0 : 1);
            }
        });
        for (NameRecord record : this.nameRecords) {
            writer.write(record.getRecordData());
        }
        for (NameRecord record : this.nameRecords) {
            writer.write(record.getStringData());
        }
        return writer.toByteArray();
    }

    private void calculateOffsets() throws IOException {
        int offset = 0;
        for (NameRecord recordOn : this.nameRecords) {
            recordOn.setOffset(offset);
            offset += recordOn.getLength();
        }
    }

    private int getOffsetToStringStorage() {
        return 6 + 12 * this.nameRecords.size();
    }

    private String formatVersion(String version) {
        Matcher noPeriodVersionRegex;
        String versionNumber = "";
        Matcher versionRegex = Pattern.compile("[1-9][0-9]*[.][0-9]*").matcher(version);
        if (versionRegex.find()) {
            versionNumber = versionRegex.group(0);
        }
        if (versionNumber.isEmpty() && (noPeriodVersionRegex = Pattern.compile("[0-9]+").matcher(version)).find()) {
            versionNumber = noPeriodVersionRegex.group(0) + ".0";
        }
        if (versionNumber.isEmpty()) {
            versionNumber = "1.1";
        }
        return "Version " + versionNumber;
    }

    public void setFontFamily(String family) {
        this.addName(family, OtfNameConstants.RecordType.FONT_FAMILY, defaultLanguage);
    }

    public void setCopyright(String name) {
        this.addName(name, OtfNameConstants.RecordType.COPYRIGHT, defaultLanguage);
    }

    public void setFontSubFamily(String name) {
        this.addName(name, OtfNameConstants.RecordType.FONT_SUB_FAMILY, defaultLanguage);
    }

    public void setFontFullName(String name) {
        this.addName(name, OtfNameConstants.RecordType.FULL_FONT_NAME, defaultLanguage);
    }

    public void setUniqueId(String name) {
        this.addName(name, OtfNameConstants.RecordType.UNIQUE_FONT_ID, defaultLanguage);
    }

    public void setPostScriptName(String name) {
        this.addName(name, OtfNameConstants.RecordType.POSTSCRIPT_NAME, defaultLanguage);
    }

    public void setVersion(String name) {
        this.addName(this.formatVersion(name), OtfNameConstants.RecordType.VERSION_STRING, defaultLanguage);
    }
}

