/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions;

import java.io.IOException;
import java.util.Stack;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;

public class InstructionStack
extends Stack<Byte> {
    public long popUint32() throws IOException {
        FontDataInputStream input = this.createDataReader();
        this.pop(4);
        return input.readUnsignedInt();
    }

    public float popF26Dot6() throws IOException {
        FontDataInputStream input = this.createDataReader();
        this.pop(4);
        return input.readFixed32();
    }

    public void pushF26Dot6(float num) throws IOException {
        FontDataOutputStream writer = new FontDataOutputStream();
        writer.write32Fixed(num);
        this.push(writer.toByteArray());
    }

    @Override
    private void push(byte[] bytes) {
        for (byte byteOn : bytes) {
            this.push(byteOn);
        }
    }

    private void pop(int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            this.pop();
        }
    }

    private FontDataInputStream createDataReader() {
        Byte[] list = this.toArray(new Byte[this.size()]);
        return new FontDataInputStream(FontVerterUtils.toPrimative(list));
    }
}

