/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;

public class FontVerterUtils {
    public static Field findPrivateField(String fieldName, Class type) {
        Field[] fields = type.getDeclaredFields();
        Field mapField = null;
        for (Field fieldOn : fields) {
            if (!fieldOn.getName().equals(fieldName)) continue;
            mapField = fieldOn;
            mapField.setAccessible(true);
        }
        return mapField;
    }

    public static Method findPrivateMethod(String methodName, Class type) {
        Method[] methods = type.getDeclaredMethods();
        Method mapMethod = null;
        for (Method methodOn : methods) {
            if (!methodOn.getName().contains(methodName)) continue;
            mapMethod = methodOn;
            mapMethod.setAccessible(true);
        }
        return mapMethod;
    }

    public static boolean bytesStartsWith(byte[] data, String ... startsWith) {
        String dataAsString = new String(data, FontDataOutputStream.OPEN_TYPE_CHARSET);
        for (String matchOn : startsWith) {
            if (!dataAsString.startsWith(matchOn)) continue;
            return true;
        }
        return false;
    }

    public static long getTableChecksum(byte[] tableData) throws IOException {
        FontDataInputStream is = new FontDataInputStream(tableData);
        long checksum = 0L;
        while (is.available() >= 4) {
            checksum += is.readUnsignedInt();
        }
        is.close();
        return checksum;
    }

    public static byte[] tablePaddingNeeded(byte[] tableData) {
        if (tableData.length % 4 == 0) {
            return new byte[0];
        }
        int paddingNeeded = 4 - tableData.length % 4;
        byte[] padding = new byte[paddingNeeded];
        for (int i = 0; i < padding.length; ++i) {
            padding[i] = 0;
        }
        return padding;
    }

    public static int readUpperBits(int inByte, int nBits) throws IOException {
        if (nBits > 8) {
            throw new IOException("Number of bits exceeds 8");
        }
        return inByte >> 8 - nBits;
    }

    public static int readLowerBits(int inByte, int nBits) throws IOException {
        if (nBits > 8) {
            throw new IOException("Number of bits exceeds 8");
        }
        return inByte & 0x1F;
    }

    public static byte[] toPrimative(Byte[] objArray) {
        byte[] primArr = new byte[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            primArr[i] = objArray[i];
        }
        return primArr;
    }

    public static boolean isBitSet(int position, Byte val) {
        return (val >> position & 1) == 1;
    }

    public static boolean isBitSet(int position, Long num) {
        return (num >> position & 1L) == 1L;
    }

    public static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

