/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.opentype.OpenTypeTable;

public class HorizontalHeadTable
extends OpenTypeTable {
    @DataTypeProperty(dataType=DataTypeProperty.DataType.FIXED32)
    public float version;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short ascender;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short descender;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short lineGap;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    public int advanceWidthMax;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short minLeftSideBearing;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short minRightSideBearing;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short xMaxExtent;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short caretSlopeRise;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short caretSlopeRun;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short caretOffset;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short reserved1;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short reserved2;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short reserved3;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short reserved4;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    public short metricDataFormat;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    public int numberOfHMetrics;

    @Override
    public String getTableType() {
        return "hhea";
    }

    public static HorizontalHeadTable createDefaultTable() {
        HorizontalHeadTable table = new HorizontalHeadTable();
        table.version = 1.0f;
        table.ascender = (short)796;
        table.descender = (short)-133;
        table.lineGap = (short)90;
        table.advanceWidthMax = 1430;
        table.minLeftSideBearing = 0;
        table.minRightSideBearing = 0;
        table.xMaxExtent = (short)1193;
        table.caretSlopeRise = 1;
        table.caretSlopeRun = 0;
        table.caretOffset = 0;
        table.reserved1 = 0;
        table.reserved2 = 0;
        table.reserved3 = 0;
        table.reserved4 = 0;
        table.metricDataFormat = 0;
        table.numberOfHMetrics = 0;
        return table;
    }

    @Override
    void normalize() throws IOException {
        if (this.font.getHmtx().isFromParsedFont) {
            return;
        }
        this.font.getHmtx().normalize();
        int[] widths = this.font.getHmtx().getAdvanceWidths();
        this.numberOfHMetrics = widths.length;
        List<Integer> widthsList = Arrays.asList(ArrayUtils.toObject((int[])widths));
        if (widthsList.size() > 0) {
            this.advanceWidthMax = Collections.max(widthsList);
        }
    }
}

