/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.validator.RuleValidator;
import org.mabb.fontverter.woff.Woff1Font;
import org.mabb.fontverter.woff.Woff2Font;
import org.mabb.fontverter.woff.WoffHeader;
import org.mabb.fontverter.woff.WoffTable;

public abstract class WoffFont
implements FVFont {
    protected WoffHeader header;
    protected List<WoffTable> tables = new ArrayList<WoffTable>();
    protected List<FVFont> fonts = new ArrayList<FVFont>();

    public static WoffFont createBlankFont(int version) {
        WoffFont font;
        if (version == 1) {
            font = new Woff1Font();
            font.header = WoffHeader.createWoff1Header();
        } else {
            font = new Woff2Font();
            font.header = WoffHeader.createWoff2Header();
        }
        return font;
    }

    public abstract WoffTable createTable();

    public abstract void addFontTable(byte[] var1, String var2, long var3);

    @Override
    public byte[] getData() throws IOException {
        this.header.calculateValues(this);
        return this.getRawData();
    }

    byte[] getRawData() throws IOException {
        FontDataOutputStream out = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        Collections.sort(this.tables, new Comparator<WoffTable>(){

            @Override
            public int compare(WoffTable o1, WoffTable o2) {
                String c1 = o1.getTag();
                String c2 = o2.getTag();
                return c1.compareTo(c2);
            }
        });
        out.write(this.header.getData());
        out.write(this.getTableDirectoryData());
        out.write(this.getCompressedDataBlock());
        return out.toByteArray();
    }

    byte[] getTableDirectoryData() throws IOException {
        FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        for (WoffTable tableOn : this.tables) {
            writer.write(tableOn.getDirectoryData());
        }
        return writer.toByteArray();
    }

    byte[] getCompressedDataBlock() throws IOException {
        FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        for (WoffTable tableOn : this.tables) {
            writer.write(tableOn.getCompressedData());
        }
        return writer.toByteArray();
    }

    public void addFont(FVFont adapter) {
        this.fonts.add(adapter);
    }

    public List<FVFont> getFonts() {
        return this.fonts;
    }

    public List<WoffTable> getTables() {
        return this.tables;
    }

    public int getCompressedSize() throws IOException {
        return this.getCompressedDataBlock().length;
    }

    @Override
    public String getName() {
        if (this.fonts.size() == 0) {
            return "Unknown Font Name";
        }
        return this.fonts.get(0).getName();
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public List<RuleValidator.FontValidatorError> getValidationErrors() {
        return new ArrayList<RuleValidator.FontValidatorError>();
    }
}

