/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.IOException;
import org.mabb.fontverter.io.DataTypeBindingSerializer;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.woff.WoffFont;

public class WoffHeader {
    static final int WOFF_1_SIGNATURE = 2001684038;
    static final int WOFF_2_SIGNATURE = 2001684018;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int signature = 2001684018;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int flavorSfntVersion;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int length;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short numTables;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short reserved = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int totalSfntSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT, ignoreIf="isVersionOne")
    int totalCompressedSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short majorVersion;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    short minorVersion;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int metaOffset = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int metaLength = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int metaOrigLength = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int privOffset = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.INT)
    int privLength = 0;

    public static WoffHeader createWoff2Header() {
        WoffHeader header = new WoffHeader();
        header.signature = 2001684018;
        header.majorVersion = (short)2;
        header.minorVersion = 0;
        return header;
    }

    public static WoffHeader createWoff1Header() {
        WoffHeader header = new WoffHeader();
        header.signature = 2001684038;
        header.majorVersion = 1;
        header.minorVersion = 0;
        return header;
    }

    public byte[] getData() throws IOException {
        DataTypeBindingSerializer serializer = new DataTypeBindingSerializer();
        return serializer.serialize(this);
    }

    public void calculateValues(WoffFont woffFont) throws IOException {
        this.length = woffFont.getRawData().length;
        this.numTables = (short)woffFont.getTables().size();
        this.totalCompressedSize = woffFont.getCompressedSize();
        this.totalSfntSize = woffFont.getFonts().get(0).getData().length;
        this.flavorSfntVersion = 0x4F54544F;
    }

    public boolean isVersionOne() {
        this.clean();
        return this.majorVersion == 1;
    }

    private void clean() {
        this.majorVersion = this.getWoffSignatureVersion();
    }

    short getWoffSignatureVersion() {
        if (this.signature == 2001684038) {
            return 1;
        }
        if (this.signature == 2001684018) {
            return 2;
        }
        return -1;
    }

    public boolean isSignatureValid() {
        return this.signature == 2001684018 || this.signature == 2001684038;
    }
}

