/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.io;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.List;
import org.mabb.fontverter.io.DataTypeAnnotationReader;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.io.DataTypeSerializerException;
import org.mabb.fontverter.io.FontDataInput;
import org.mabb.fontverter.io.FontDataInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeBindingDeserializer {
    private static Logger log = LoggerFactory.getLogger(DataTypeBindingDeserializer.class);
    private DataTypeAnnotationReader propReader = new DataTypeAnnotationReader();
    private FontDataInput input;
    private boolean recoverFromEOF;
    private boolean stopDeserializeEarly = false;

    public Object deserialize(byte[] data, Class toClass) throws DataTypeSerializerException {
        return this.deserialize((FontDataInput)new FontDataInputStream(data), toClass);
    }

    public Object deserialize(FontDataInput dataInput, Class toClass) throws DataTypeSerializerException {
        try {
            return this.deserialize(dataInput, toClass.newInstance());
        }
        catch (Exception ex) {
            throw new DataTypeSerializerException(ex);
        }
    }

    public Object deserialize(FontDataInput dataInput, Object toObj) throws DataTypeSerializerException {
        try {
            this.input = dataInput;
            Class<?> toClass = toObj.getClass();
            List<AccessibleObject> properties = this.propReader.getProperties(toClass);
            for (AccessibleObject propertyOn : properties) {
                if (this.stopDeserializeEarly) break;
                try {
                    this.deserializeProperty(propertyOn, toObj);
                }
                catch (Exception ex) {
                    throw new DataTypeSerializerException(propertyOn.toString() + " " + toObj.getClass().getCanonicalName(), ex);
                }
            }
            return toObj;
        }
        catch (Exception ex) {
            throw new DataTypeSerializerException(toObj.getClass().getCanonicalName(), ex);
        }
    }

    public Object deserialize(byte[] data, Object toObj) throws DataTypeSerializerException {
        return this.deserialize((FontDataInput)new FontDataInputStream(data), toObj);
    }

    private void deserializeProperty(AccessibleObject propertyOn, Object object) throws Exception {
        if (!propertyOn.isAnnotationPresent(DataTypeProperty.class)) {
            return;
        }
        DataTypeProperty annotation = propertyOn.getAnnotation(DataTypeProperty.class);
        DataTypeProperty binding = annotation;
        if (this.propReader.isIgnoreProperty(binding, object)) {
            return;
        }
        Object inValue = null;
        inValue = binding.isArray() ? this.readArrayValue((Field)propertyOn, object, binding) : this.readSingleValue(binding);
        if (!(propertyOn instanceof Field)) {
            throw new IOException("Method property deserialization not implemented" + propertyOn.toString());
        }
        ((Field)propertyOn).set(object, inValue);
    }

    private Object readSingleValue(DataTypeProperty property) throws IOException {
        switch (property.dataType()) {
            case SHORT: {
                return this.input.readShort();
            }
            case USHORT: {
                return this.input.readUnsignedShort();
            }
            case LONG: {
                return this.input.readInt();
            }
            case ULONG: {
                return this.input.readUnsignedInt();
            }
            case FIXED32: {
                return Float.valueOf(this.input.readFixed32());
            }
            case INT: {
                return this.input.readInt();
            }
            case UINT: {
                return this.input.readUnsignedInt();
            }
            case BYTE: {
                return this.input.readByte();
            }
            case STRING: {
                return this.input.readString(property.constLength());
            }
            case BYTE_ARRAY: {
                return this.input.readBytes(property.constLength());
            }
            case LONG_DATE_TIME: {
                Calendar date = Calendar.getInstance();
                date.setTimeInMillis(this.input.readLong() * 1000L);
                return date;
            }
            case UINT_BASE_128: {
                return this.input.readUIntBase128();
            }
            case PASCAL_STRING: {
                int strLength = this.input.readUnsignedByte();
                return this.input.readString(strLength);
            }
        }
        throw new IOException("Deserialize not implemented for peroperty type: " + (Object)((Object)property.dataType()));
    }

    private Object readArrayValue(Field propertyOn, Object object, DataTypeProperty binding) throws NoSuchFieldException, IllegalAccessException, IOException, InvocationTargetException {
        int arrayLength = this.propReader.getPropertyArrayLength(binding, object);
        if (arrayLength < 0) {
            throw new IOException("Array length must be set for array data types.");
        }
        Object[] array = (Object[])Array.newInstance(propertyOn.getType().getComponentType(), arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            try {
                array[i] = this.readSingleValue(binding);
                continue;
            }
            catch (Exception ex) {
                String message = String.format("Array length ran over input data length. Index on: %d Array Length: %d", i, arrayLength);
                if (this.isRecoverFromEOF()) {
                    this.stopDeserializeEarly = true;
                    log.debug(message);
                    return array;
                }
                throw new IOException(message);
            }
        }
        return array;
    }

    public void setRecoverFromEOF(boolean recoverFromEOF) {
        this.recoverFromEOF = recoverFromEOF;
    }

    public boolean isRecoverFromEOF() {
        return this.recoverFromEOF;
    }
}

