/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions.graphicsengine;

public class RoundSettings {
    public double period = 0.0;
    public double phase = 0.0;
    public double threshold = 0.0;

    public void updateForFlags(Long flags) {
        byte periodFlag = (byte)(flags >> 6 & 3L);
        this.setPeriodFromFlag(periodFlag);
        byte phaseFlag = (byte)(flags >> 4 & 3L);
        this.setPhaseFromFlag(phaseFlag);
        byte thresholdFlag = (byte)(flags & 0xFL);
        this.setThresholdFromFlag(thresholdFlag);
    }

    public void updateFor45DegreeFlags(Long flags) {
        this.set45DegPeriodFromFlag((byte)(flags >> 6 & 3L));
        this.setPhaseFromFlag((byte)(flags >> 4 & 3L));
        this.setThresholdFromFlag((byte)(flags & 0xFL));
    }

    private void setPeriodFromFlag(byte periodFlag) {
        if (periodFlag == 0) {
            this.period = 0.5;
        } else if (periodFlag == 1) {
            this.period = 1.0;
        } else if (periodFlag == 2) {
            this.period = 2.0;
        }
    }

    private void set45DegPeriodFromFlag(byte periodFlag) {
        if (periodFlag == 0) {
            this.period = Math.sqrt(2.0) / 2.0;
        } else if (periodFlag == 1) {
            this.period = Math.sqrt(2.0);
        } else if (periodFlag == 2) {
            this.period = 2.0 * Math.sqrt(2.0);
        }
    }

    private void setPhaseFromFlag(byte phaseFlag) {
        if (phaseFlag == 0) {
            this.phase = 0.0;
        } else if (phaseFlag == 1) {
            this.phase = this.period / 4.0;
        } else if (phaseFlag == 2) {
            this.phase = this.period / 2.0;
        } else if (phaseFlag == 3) {
            this.phase = this.period * 0.0;
        }
    }

    private void setThresholdFromFlag(byte thresholdFlag) {
        if (thresholdFlag == 0) {
            this.threshold = this.period - 1.0;
        } else {
            int periodDividend = -3;
            this.threshold = (double)(periodDividend += thresholdFlag - 1) / 8.0 * this.period;
        }
    }

    public static enum RoundState {
        OFF,
        ROUND,
        ROUND_TO_GRID,
        ROUND_DOWN_TO_GRID,
        ROUND_UP_TO_GRID,
        ROUND_TO_DOUBLE_GRID,
        ROUND_TO_HALF_GRID,
        SUPER_ROUND,
        SUPER_ROUND_45_DEG;

    }
}

