/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.association.CompressedDoubleMatrix;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.association.WeightedMLMPlugin;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.stats.EMMA.EMMAforDoubleMatrix;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SymmetricMatrixInverterDM;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixBuilder;
import net.maizegenetics.taxa.tree.UPGMATree;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.log4j.Logger;

public class CompressedMLMusingDoubleMatrix {
    private static final Logger myLogger = Logger.getLogger(CompressedMLMusingDoubleMatrix.class);
    private static final List<String> homGenotypes = Arrays.asList("A", "C", "G", "T", "Z");
    private static final List<String> hetGenotypes = Arrays.asList("R", "W", "K", "Y", "S", "M", "0");
    private final boolean useCompression;
    private final boolean useP3D;
    private final double compression;
    private boolean outputResiduals = true;
    private final GenotypePhenotype myGenoPheno;
    private final Phenotype myPhenotype;
    private final GenotypeTable myGenotype;
    private final boolean hasGenotype;
    private final MLMPlugin parentPlugin;
    private final DistanceMatrix kinshipMatrix;
    private double resvar;
    private double genvar;
    private double lnlk;
    private boolean testMarkers = true;
    private SymmetricMatrixInverterDM Vminus = null;
    private String datasetName;
    private List<PhenotypeAttribute> factorAttributeList;
    private List<PhenotypeAttribute> covariateAttributeList;
    private final Phenotype myWeightMatrix;
    private final TableReportBuilder siteReportBuilder;
    private final TableReportBuilder alleleReportBuilder;
    private final TableReportBuilder compressionReportBuilder;
    private boolean useGenotypeCalls = true;
    private boolean useReferenceProbability = false;
    private boolean useAlleleProbabilities = false;

    public CompressedMLMusingDoubleMatrix(MLMPlugin parentPlugin, Datum dataset, DistanceMatrix kinshipMatrix, boolean useCompression, boolean useP3D, double compression) {
        this.parentPlugin = parentPlugin;
        this.kinshipMatrix = kinshipMatrix;
        this.useCompression = useCompression;
        this.useP3D = useP3D;
        this.compression = compression;
        this.myWeightMatrix = null;
        this.datasetName = dataset.getName();
        if (dataset.getData().getClass().equals(GenotypePhenotype.class)) {
            this.myGenoPheno = (GenotypePhenotype)dataset.getData();
            this.myPhenotype = this.myGenoPheno.phenotype();
            this.myGenotype = this.myGenoPheno.genotypeTable();
            this.hasGenotype = true;
        } else if (dataset.getData() instanceof Phenotype) {
            this.myGenoPheno = null;
            this.myPhenotype = (Phenotype)dataset.getData();
            this.myGenotype = null;
            this.hasGenotype = false;
        } else {
            this.myGenoPheno = null;
            this.myPhenotype = null;
            this.myGenotype = null;
            this.hasGenotype = false;
        }
        Object[] headerMain = new String[]{"Trait", "Marker", "Chr", "Pos", "df", "F", "p", "add_effect", "add_F", "add_p", "dom_effect", "dom_F", "dom_p", "errordf", "MarkerR2", "Genetic Var", "Residual Var", "-2LnLikelihood"};
        Object[] headerAlleles = new String[]{"Trait", "Marker", "Locus", "Site", "Allele", "Effect", "Obs"};
        Object[] headerCompression = new String[]{"Trait", "# groups", "Compression", "-2LnLk", "Var_genetic", "Var_error"};
        if (parentPlugin.isWriteOutputToFile()) {
            String outputbase = parentPlugin.getOutputName();
            String datasetNameNoSpace = this.datasetName.trim().replaceAll("\\ ", "_");
            StringBuilder sb = new StringBuilder();
            sb.append(outputbase).append("_").append(datasetNameNoSpace).append("_stats.txt");
            this.siteReportBuilder = TableReportBuilder.getInstance("Marker Statistics - " + this.datasetName, headerMain, sb.toString());
            sb = new StringBuilder();
            sb.append(outputbase).append("_").append(datasetNameNoSpace).append("_effects.txt");
            this.alleleReportBuilder = TableReportBuilder.getInstance("Allele Estimates - " + this.datasetName, headerAlleles, sb.toString());
            sb = new StringBuilder();
            sb.append(outputbase).append("_").append(datasetNameNoSpace).append("_compression.txt");
            this.compressionReportBuilder = useCompression ? TableReportBuilder.getInstance("Compression - " + this.datasetName, headerCompression, sb.toString()) : null;
        } else {
            this.siteReportBuilder = TableReportBuilder.getInstance("Marker Statistics - " + this.datasetName, headerMain);
            this.alleleReportBuilder = TableReportBuilder.getInstance("Allele Estimates - " + this.datasetName, headerAlleles);
            this.compressionReportBuilder = useCompression ? TableReportBuilder.getInstance("Compression - " + this.datasetName, headerCompression) : null;
        }
    }

    public CompressedMLMusingDoubleMatrix(WeightedMLMPlugin parentPlugin, Datum dataset, DistanceMatrix kinshipMatrix, Datum weights, boolean useCompression, boolean useP3D, double compression) {
        this.parentPlugin = parentPlugin;
        this.kinshipMatrix = kinshipMatrix;
        this.useCompression = useCompression;
        this.useP3D = useP3D;
        this.compression = compression;
        this.myWeightMatrix = (Phenotype)weights.getData();
        this.datasetName = dataset.getName();
        if (dataset.getData().getClass().equals(GenotypePhenotype.class)) {
            this.myGenoPheno = (GenotypePhenotype)dataset.getData();
            this.myPhenotype = this.myGenoPheno.phenotype();
            this.myGenotype = this.myGenoPheno.genotypeTable();
            this.hasGenotype = true;
        } else if (dataset.getData() instanceof Phenotype) {
            this.myGenoPheno = null;
            this.myPhenotype = (Phenotype)dataset.getData();
            this.myGenotype = null;
            this.hasGenotype = false;
        } else {
            this.myGenoPheno = null;
            this.myPhenotype = null;
            this.myGenotype = null;
            this.hasGenotype = false;
        }
        Object[] headerMain = new String[]{"Trait", "Marker", "Chr", "Pos", "df", "F", "p", "add_effect", "add_F", "add_p", "dom_effect", "dom_F", "dom_p", "errordf", "MarkerR2", "Genetic Var", "Residual Var", "-2LnLikelihood"};
        Object[] headerAlleles = new String[]{"Trait", "Marker", "Locus", "Site", "Allele", "Effect", "Obs"};
        Object[] headerCompression = new String[]{"Trait", "# groups", "Compression", "-2LnLk", "Var_genetic", "Var_error"};
        if (parentPlugin.isWriteOutputToFile()) {
            String outputbase = parentPlugin.getOutputName();
            String datasetNameNoSpace = this.datasetName.trim().replaceAll("\\ ", "_");
            StringBuilder sb = new StringBuilder();
            sb.append(outputbase).append("_").append(datasetNameNoSpace).append("_stats.txt");
            this.siteReportBuilder = TableReportBuilder.getInstance("Marker Statistics - " + this.datasetName, headerMain, sb.toString());
            sb = new StringBuilder();
            sb.append(outputbase).append("_").append(datasetNameNoSpace).append("_effects.txt");
            this.alleleReportBuilder = TableReportBuilder.getInstance("Allele Estimates - " + this.datasetName, headerAlleles, sb.toString());
            sb = new StringBuilder();
            sb.append(outputbase).append("_").append(datasetNameNoSpace).append("_compression.txt");
            this.compressionReportBuilder = useCompression ? TableReportBuilder.getInstance("Compression - " + this.datasetName, headerCompression, sb.toString()) : null;
        } else {
            this.siteReportBuilder = TableReportBuilder.getInstance("Marker Statistics - " + this.datasetName, headerMain);
            this.alleleReportBuilder = TableReportBuilder.getInstance("Allele Estimates - " + this.datasetName, headerAlleles);
            this.compressionReportBuilder = useCompression ? TableReportBuilder.getInstance("Compression - " + this.datasetName, headerCompression) : null;
        }
    }

    public void useGenotypeCalls(boolean use) {
        this.useGenotypeCalls = use;
    }

    public void useReferenceProbability(boolean use) {
        this.useReferenceProbability = use;
    }

    public void useAlleleProbabilities(boolean use) {
        this.useAlleleProbabilities = use;
    }

    public List<Datum> solve() {
        LinkedList<Datum> results = new LinkedList<Datum>();
        int numberOfMarkers = 0;
        if (this.hasGenotype) {
            numberOfMarkers = this.myGenotype.numberOfSites();
        }
        List<PhenotypeAttribute> dataAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        this.factorAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
        this.covariateAttributeList = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate);
        TaxaAttribute myTaxaAttribute = this.myPhenotype.taxaAttribute();
        int numberOfPhenotypes = dataAttributeList.size();
        int expectedIterations = numberOfPhenotypes * numberOfMarkers;
        int iterationsSofar = 0;
        for (PhenotypeAttribute attr : dataAttributeList) {
            myLogger.debug((Object)("Running MLM for " + attr.name()));
            double[] phenotypeData = this.doubleDataFromAttribute(attr);
            Taxon[] theTaxa = myTaxaAttribute.allTaxa();
            OpenBitSet missing = new OpenBitSet(attr.missing());
            for (PhenotypeAttribute factorAttribute : this.factorAttributeList) {
                missing.or(factorAttribute.missing());
            }
            for (PhenotypeAttribute covariateAttribute : this.covariateAttributeList) {
                missing.or(covariateAttribute.missing());
            }
            TaxaList nonmissingIds = this.updateMissingWithKinship(missing, theTaxa);
            DistanceMatrix kin = new DistanceMatrix(this.kinshipMatrix, nonmissingIds);
            int totalObs = attr.size();
            int nonMissingObs = totalObs - (int)missing.cardinality();
            double[] nonMissingData = AssociationUtils.getNonMissingDoubles(phenotypeData, (BitSet)missing);
            Taxon[] nonMissingTaxa = AssociationUtils.getNonMissingValues(theTaxa, (BitSet)missing);
            DoubleMatrix y = DoubleMatrixFactory.DEFAULT.make(nonMissingObs, 1, nonMissingData);
            DoubleMatrix Z = DoubleMatrixFactory.DEFAULT.make(nonMissingObs, kin.numberOfTaxa());
            for (int i = 0; i < nonMissingObs; ++i) {
                Z.set(i, kin.whichIdNumber(nonMissingTaxa[i]), 1.0);
            }
            DoubleMatrix fixed = AssociationUtils.createFixedEffectsArray(this.factorAttributeList, this.covariateAttributeList, missing, nonMissingObs);
            DoubleMatrix W = null;
            DoubleMatrix WOriginal = null;
            EMMAforDoubleMatrix emlm = null;
            DoubleMatrix[] zk = null;
            if (this.myWeightMatrix != null) {
                int weightAttrIndex = this.myWeightMatrix.attributeIndexForName(attr.name());
                if (weightAttrIndex != -1) {
                    PhenotypeAttribute weightAttribute = this.myWeightMatrix.attribute(weightAttrIndex);
                    double[] weightValues = this.doubleDataFromAttribute(weightAttribute);
                    double[] nonMissingWeights = AssociationUtils.getNonMissingDoubles(weightValues, (BitSet)missing);
                    if (nonMissingObs == nonMissingWeights.length) {
                        WOriginal = DoubleMatrixFactory.DEFAULT.diagonal(nonMissingWeights);
                        for (int i = 0; i < nonMissingWeights.length; ++i) {
                            nonMissingWeights[i] = Math.pow(nonMissingWeights[i], -0.5);
                        }
                        W = DoubleMatrixFactory.DEFAULT.diagonal(nonMissingWeights);
                        zk = this.computeZKZ(W.mult(y), W.mult(fixed), W.mult(Z), kin, attr.name());
                        emlm = new EMMAforDoubleMatrix(W.mult(y), W.mult(fixed), zk[1], zk[0], 0, Double.NaN);
                        emlm.solve();
                        zk = this.computeZKZ(y, fixed, Z, kin, attr.name());
                    } else {
                        zk = this.computeZKZ(y, fixed, Z, kin, attr.name());
                        emlm = new EMMAforDoubleMatrix(y, fixed, zk[1], zk[0], 0, Double.NaN);
                        emlm.solve();
                    }
                } else {
                    zk = this.computeZKZ(y, fixed, Z, kin, attr.name());
                    emlm = new EMMAforDoubleMatrix(y, fixed, zk[1], zk[0], 0, Double.NaN);
                    emlm.solve();
                }
            } else {
                zk = this.computeZKZ(y, fixed, Z, kin, attr.name());
                emlm = new EMMAforDoubleMatrix(y, fixed, zk[1], zk[0], 0, Double.NaN);
                emlm.solve();
            }
            this.genvar = emlm.getVarRan();
            this.resvar = emlm.getVarRes();
            this.lnlk = emlm.getLnLikelihood();
            int baseModeldf = emlm.getDfModel();
            if (this.outputResiduals) {
                List<Taxon> phenotypeTaxa = Arrays.asList(nonMissingTaxa);
                Datum residuals = this.createResPhenotype(emlm, phenotypeTaxa, attr.name());
                results.add(residuals);
                if (this.parentPlugin.isWriteOutputToFile()) {
                    ExportPlugin exporter = new ExportPlugin(null, false);
                    String outfile = this.parentPlugin.getOutputName() + "_" + residuals.getName() + "_residuals.txt";
                    exporter.setSaveFile(outfile);
                    exporter.performFunction(new DataSet(residuals, (Plugin)this.parentPlugin));
                }
            }
            Object[] tableRow = new Object[]{attr.name(), "None", "", "", new Integer(0), new Double(Double.NaN), new Double(Double.NaN), new Double(Double.NaN), new Double(Double.NaN), new Double(Double.NaN), new Double(Double.NaN), new Double(Double.NaN), new Double(Double.NaN), new Integer(nonMissingObs - baseModeldf), new Double(Double.NaN), new Double(this.genvar), new Double(this.resvar), new Double(-2.0 * this.lnlk)};
            this.siteReportBuilder.add(tableRow);
            if (this.useP3D) {
                DoubleMatrix ZKZ = zk[0].mult(zk[1]).tcrossproduct(zk[0]);
                this.Vminus = W == null ? new SymmetricMatrixInverterDM(this.calculateV(ZKZ, this.genvar, this.resvar)) : new SymmetricMatrixInverterDM(this.calculateV(ZKZ, WOriginal, this.genvar, this.resvar));
            }
            if (!this.testMarkers) continue;
            for (int m = 0; m < numberOfMarkers; ++m) {
                DoubleMatrix X;
                Object[] genotypes;
                OpenBitSet missingObsForSite = new OpenBitSet(missing);
                missingObsForSite.or(this.missingForSite(m));
                OpenBitSet missingFromZ = new OpenBitSet(nonMissingObs);
                int nonMissingCount = 0;
                for (int i = 0; i < totalObs; ++i) {
                    if (missing.fastGet(i)) continue;
                    if (missingObsForSite.fastGet(i)) {
                        missingFromZ.fastSet(nonMissingCount);
                    }
                    ++nonMissingCount;
                }
                DoubleMatrix ymarker = AssociationUtils.getNonMissingValues(y, (BitSet)missingFromZ);
                DoubleMatrix fixed2 = AssociationUtils.getNonMissingValues(fixed, (BitSet)missingFromZ);
                ArrayList<Byte> markerIds = new ArrayList<Byte>();
                int nAlleles = 0;
                int markerdf = 0;
                int[] alleleCounts = null;
                if (this.useGenotypeCalls) {
                    genotypes = ModelEffectUtils.genotypesToUnphasedSorted(AssociationUtils.getNonMissingBytes(this.myGenoPheno.genotypeAllTaxa(m), missingObsForSite));
                    FactorModelEffect markerEffect = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(genotypes, markerIds), true);
                    X = fixed2.concatenate(markerEffect.getX(), false);
                    nAlleles = markerEffect.getNumberOfLevels();
                    alleleCounts = markerEffect.getLevelCounts();
                    markerdf = nAlleles - 1;
                } else if (this.useReferenceProbability) {
                    genotypes = AssociationUtils.getNonMissingDoubles(this.myGenoPheno.referenceProb(m), (BitSet)missingObsForSite);
                    int nrows = genotypes.length;
                    X = fixed2.concatenate(DoubleMatrixFactory.DEFAULT.make(nrows, 1, (double[])genotypes), false);
                    nAlleles = 1;
                    alleleCounts = new int[]{nrows};
                    markerdf = 1;
                } else {
                    X = null;
                }
                CompressedMLMResult result = new CompressedMLMResult();
                if (this.useP3D) {
                    this.testMarkerUsingP3D(result, ymarker, X, this.Vminus.getInverse(missingFromZ, nonMissingObs), markerdf, markerIds);
                } else {
                    DoubleMatrix Zsel = AssociationUtils.getNonMissingValues(zk[0], (BitSet)missingFromZ);
                    this.testMarkerUsingEMMA(result, ymarker, X, zk[1], Zsel, nAlleles, markerIds);
                    markerdf = result.modeldf - baseModeldf;
                }
                boolean recordTheseResults = true;
                if (this.parentPlugin.isFilterOutput() && result.p > this.parentPlugin.getMaxp()) {
                    recordTheseResults = false;
                }
                if (recordTheseResults) {
                    String markername = this.myGenotype.siteName(m);
                    String chr = "";
                    String pos = "";
                    String locus = this.myGenotype.chromosomeName(m);
                    String site = Integer.toString(this.myGenotype.chromosomalPosition(m));
                    double errordf = ymarker.numberOfRows() - result.modeldf;
                    tableRow = new Object[]{attr.name(), markername, locus, site, new Integer(markerdf), new Double(result.F), new Double(result.p), new Double(result.addEffect), new Double(result.Fadd), new Double(result.padd), new Double(result.domEffect), new Double(result.Fdom), new Double(result.pdom), new Double(errordf), new Double(result.r2), new Double(this.genvar), new Double(this.resvar), new Double(-2.0 * this.lnlk)};
                    this.siteReportBuilder.add(tableRow);
                    int numberOfRowsKept = totalObs - (int)missingObsForSite.cardinality();
                    if (this.useReferenceProbability) {
                        tableRow = new Object[]{attr.name(), markername, locus, site, "", result.beta.get(result.beta.numberOfRows() - 1, 0), numberOfRowsKept};
                        this.alleleReportBuilder.add(tableRow);
                    } else if (nAlleles > 1) {
                        for (int a = 0; a < nAlleles; ++a) {
                            Double estimate = a < nAlleles - 1 ? Double.valueOf(result.beta.get(result.beta.numberOfRows() - nAlleles + 1 + a, 0)) : Double.valueOf(0.0);
                            tableRow = new Object[]{attr.name(), markername, locus, site, NucleotideAlignmentConstants.getNucleotideIUPAC(markerIds.get(a)), estimate, alleleCounts[a]};
                            this.alleleReportBuilder.add(tableRow);
                        }
                    }
                }
                int progress = (int)((double)(++iterationsSofar) / (double)expectedIterations * 100.0);
                progress = Math.min(99, progress);
                this.parentPlugin.updateProgress(progress);
            }
        }
        this.parentPlugin.updateProgress(100);
        results.addAll(this.formatResults());
        return results;
    }

    private BitSet missingForSite(int site) {
        int nobs = this.myGenoPheno.phenotype().numberOfObservations();
        OpenBitSet missing = new OpenBitSet(nobs);
        if (this.useGenotypeCalls) {
            byte[] siteGenotype = this.myGenoPheno.genotypeAllTaxa(site);
            byte missingByte = -1;
            for (int i = 0; i < nobs; ++i) {
                if (siteGenotype[i] != missingByte) continue;
                missing.fastSet(i);
            }
        } else if (this.useReferenceProbability) {
            float[] probs = this.myGenoPheno.referenceProb(site);
            for (int t = 0; t < nobs; ++t) {
                if (probs[t] != Float.NaN) continue;
                missing.fastSet(t);
            }
        } else {
            float[] probs = this.myGenoPheno.alleleProbsOfType(SiteScore.SITE_SCORE_TYPE.DepthA, site);
            for (int t = 0; t < nobs; ++t) {
                if (probs[t] != Float.NaN) continue;
                missing.fastSet(t);
            }
        }
        return missing;
    }

    private double[] doubleDataFromAttribute(PhenotypeAttribute attribute) {
        float[] floatData = (float[])((NumericAttribute)attribute).allValues();
        int n = floatData.length;
        double[] doubleData = new double[n];
        for (int i = 0; i < n; ++i) {
            doubleData[i] = floatData[i];
        }
        return doubleData;
    }

    private String getTabbedStringFromArray(Object[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append(array[0]);
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            sb.append("\t").append(array[i]);
        }
        return sb.toString();
    }

    public List<Datum> formatResults() {
        LinkedList<Datum> output = new LinkedList<Datum>();
        StringBuilder options = new StringBuilder();
        options.append("Use compression = ").append(this.useCompression).append("\n");
        options.append("Use P3D = ").append(this.useP3D).append("\n");
        if (this.useCompression) {
            options.append(", compression level = ").append(this.compression).append("\n");
        }
        if (this.useP3D) {
            options.append("P3D = ").append(this.useP3D).append(". Variance components were estimated only for the model without any markers.\n");
        } else {
            options.append("P3D = ").append(this.useP3D).append(". Variance components were estimated for each marker.\n");
        }
        StringBuilder model = new StringBuilder();
        model.append("Model: trait = mean + ");
        int nFactors = this.factorAttributeList.size();
        for (PhenotypeAttribute phenotypeAttribute : this.factorAttributeList) {
            model.append(phenotypeAttribute.name()).append(" + ");
        }
        int nCovar = this.covariateAttributeList.size();
        for (PhenotypeAttribute cov : this.covariateAttributeList) {
            model.append(cov.name()).append(" + ");
        }
        model.append("marker\n");
        String string = "MLM_statistics_for_" + this.datasetName;
        StringBuilder comment = new StringBuilder();
        comment.append("MLM statistics for compressed MLM\n");
        comment.append("Dataset: ").append(this.datasetName).append("\n");
        comment.append((CharSequence)options).append((CharSequence)model);
        TableReport myTableReport = this.siteReportBuilder.build();
        if (myTableReport != null) {
            output.add(new Datum(string, myTableReport, comment.toString()));
        }
        String string2 = "MLM_effects_for_" + this.datasetName;
        comment = new StringBuilder();
        comment.append("MLM SNP effect estimates\n");
        comment.append("Dataset: ").append(this.datasetName).append("\n");
        comment.append((CharSequence)options).append((CharSequence)model);
        myTableReport = this.alleleReportBuilder.build();
        if (myTableReport != null) {
            output.add(new Datum(string2, myTableReport, comment.toString()));
        }
        if (this.useCompression) {
            String string3 = "MLM_compression_for_" + this.datasetName;
            comment = new StringBuilder();
            comment.append("MLM compression report\n");
            comment.append("Dataset: ").append(this.datasetName).append("\n");
            comment.append((CharSequence)options).append((CharSequence)model);
            myTableReport = this.compressionReportBuilder.build();
            if (myTableReport != null) {
                output.add(new Datum(string3, myTableReport, comment.toString()));
            }
        }
        return output;
    }

    public DoubleMatrix[] computeZKZ(DoubleMatrix data, DoubleMatrix X, DoubleMatrix Z, DistanceMatrix kin, String traitname) {
        int nkin;
        int nrow;
        myLogger.debug((Object)("Running compression for " + traitname));
        DoubleMatrix[] zkMatrices = new DoubleMatrix[2];
        CompressedDoubleMatrix.kinshipMethod kinmethod = CompressedDoubleMatrix.kinshipMethod.avg;
        int ncol = nrow = (nkin = kin.getSize());
        DoubleMatrix K = DoubleMatrixFactory.DEFAULT.make(nrow, ncol);
        for (int r = 0; r < nrow; ++r) {
            for (int c = 0; c < ncol; ++c) {
                K.set(r, c, kin.getDistance(r, c));
            }
        }
        if (!this.useCompression) {
            zkMatrices[0] = Z;
            zkMatrices[1] = K;
        } else if (Double.isNaN(this.compression)) {
            int n = Z.numberOfColumns();
            int count = 0;
            boolean taxaReplicated = false;
            while (count < n && !taxaReplicated) {
                int n2 = count++;
                if (!(Z.columnSum(n2) > 1.5)) continue;
                taxaReplicated = true;
            }
            DistanceMatrix distance = this.calculateDistanceFromKin(kin);
            CompressedDoubleMatrix cm = new CompressedDoubleMatrix(kin, new UPGMATree(distance));
            EMMAforDoubleMatrix emlm = new EMMAforDoubleMatrix(data, X, K, Z, 0, Double.NaN);
            emlm.solve();
            double bestlnlk = emlm.getLnLikelihood();
            int bestCompression = nkin;
            double exponent = 1.0;
            double base = 0.98;
            double maxexponent = Math.log(1.0 / (double)nkin) / Math.log(base);
            this.parentPlugin.updateProgress((int)(exponent * 100.0 / maxexponent));
            int g = nkin;
            while (g > 3) {
                cm.setNumberOfGroups(g);
                DoubleMatrix compressedZ = cm.getCompressedZ(Z);
                DoubleMatrix compressedK = cm.getCompressedMatrix(kinmethod);
                try {
                    emlm = new EMMAforDoubleMatrix(data, X, compressedK, compressedZ, 0, Double.NaN);
                    emlm.solve();
                    this.compressionReportBuilder.add(new Object[]{traitname, g, (double)nkin / (double)g, -2.0 * emlm.getLnLikelihood(), emlm.getVarRan(), emlm.getVarRes()});
                    if (Double.isNaN(bestlnlk) || emlm.getLnLikelihood() > bestlnlk) {
                        bestlnlk = emlm.getLnLikelihood();
                        bestCompression = g;
                        this.resvar = emlm.getVarRes();
                        this.genvar = emlm.getVarRan();
                    }
                }
                catch (Exception e) {
                    System.out.println("Compression failed for g = " + g);
                }
                int prev = g;
                while (g == prev) {
                    int prog = (int)((exponent += 1.0) * 100.0 / maxexponent);
                    prog = Math.min(prog, 99);
                    this.parentPlugin.updateProgress(prog);
                    g = (int)((double)nkin * Math.pow(base, exponent));
                }
            }
            cm.setNumberOfGroups(bestCompression);
            zkMatrices[0] = cm.getCompressedZ(Z);
            zkMatrices[1] = cm.getCompressedMatrix(kinmethod);
            this.parentPlugin.updateProgress(0);
        } else {
            DistanceMatrix distance = this.calculateDistanceFromKin(kin);
            CompressedDoubleMatrix cm = new CompressedDoubleMatrix(kin, new UPGMATree(distance));
            int g = (int)Math.round((double)nkin / this.compression);
            cm.setNumberOfGroups(g);
            zkMatrices[0] = cm.getCompressedZ(Z);
            zkMatrices[1] = cm.getCompressedMatrix(kinmethod);
        }
        return zkMatrices;
    }

    public void testMarkerUsingEMMA(CompressedMLMResult result, DoubleMatrix y, DoubleMatrix X, DoubleMatrix K, DoubleMatrix Z, int nAlleles, ArrayList<Byte> markerIds) {
        boolean markerTest;
        EMMAforDoubleMatrix emlm = new EMMAforDoubleMatrix(y, X, K, Z, nAlleles, Double.NaN);
        emlm.solve();
        result.beta = emlm.getBeta();
        double[] Fp = emlm.getMarkerFp();
        result.F = Fp[0];
        result.p = Fp[1];
        result.modeldf = emlm.getDfModel();
        this.genvar = emlm.getVarRan();
        this.resvar = emlm.getVarRes();
        this.lnlk = emlm.getLnLikelihood();
        this.calculateRsquare(X, y, emlm.getInvH(), result, nAlleles - 1);
        boolean bl = markerTest = markerIds.size() == 3;
        if (markerTest) {
            markerTest = markerTest && !GenotypeTableUtils.isHeterozygous(markerIds.get(0));
            markerTest = markerTest && !GenotypeTableUtils.isHeterozygous(markerIds.get(1));
            boolean bl2 = markerTest = markerTest && GenotypeTableUtils.isHeterozygous(markerIds.get(2));
        }
        if (markerTest && Fp.length == 8) {
            result.addEffect = Fp[2];
            result.Fadd = Fp[3];
            result.padd = Fp[4];
            result.domEffect = Fp[5];
            result.Fdom = Fp[6];
            result.pdom = Fp[7];
        }
    }

    public void testMarkerUsingP3D(CompressedMLMResult result, DoubleMatrix y, DoubleMatrix X, DoubleMatrix invV, int markerdf, ArrayList<Byte> markerIds) {
        DoubleMatrix invXVX = X.crossproduct(invV).mult(X);
        invXVX.invert();
        result.beta = invXVX.mult(X.crossproduct(invV.mult(y)));
        if (markerdf == 0) {
            result.F = Double.NaN;
            result.p = Double.NaN;
            result.r2 = 0.0;
        } else {
            boolean markerTest;
            int nparm = result.beta.numberOfRows();
            DoubleMatrix M = DoubleMatrixFactory.DEFAULT.make(markerdf, nparm, 0.0);
            for (int i = 0; i < markerdf; ++i) {
                M.set(i, nparm - markerdf + i, 1.0);
            }
            DoubleMatrix Mb = M.mult(result.beta);
            DoubleMatrix invMiM = M.mult(invXVX.tcrossproduct(M));
            try {
                invMiM.invert();
                result.F = Mb.crossproduct(invMiM.mult(Mb)).get(0, 0) / (double)markerdf;
            }
            catch (Exception ex) {
                result.F = Double.NaN;
            }
            try {
                result.p = LinearModelUtils.Ftest(result.F, markerdf, y.numberOfRows() - nparm);
            }
            catch (Exception e) {
                result.p = Double.NaN;
            }
            this.calculateRsquare(X, y, invV, result, markerdf);
            boolean bl = markerTest = markerIds.size() == 3;
            if (markerTest) {
                markerTest = markerTest && !GenotypeTableUtils.isHeterozygous(markerIds.get(0));
                markerTest = markerTest && !GenotypeTableUtils.isHeterozygous(markerIds.get(1));
                boolean bl2 = markerTest = markerTest && GenotypeTableUtils.isHeterozygous(markerIds.get(2));
            }
            if (markerdf == 2 && markerTest) {
                M = DoubleMatrixFactory.DEFAULT.make(1, nparm, 0.0);
                M.set(0, nparm - 2, 0.5);
                M.set(0, nparm - 1, -0.5);
                Mb = M.mult(result.beta);
                result.addEffect = Mb.get(0, 0);
                try {
                    result.Fadd = Mb.get(0, 0) * Mb.get(0, 0) / M.mult(invXVX.tcrossproduct(M)).get(0, 0);
                }
                catch (Exception ex) {
                    result.Fadd = Double.NaN;
                }
                try {
                    result.padd = LinearModelUtils.Ftest(result.Fadd, 1.0, y.numberOfRows() - nparm);
                }
                catch (Exception e) {
                    result.padd = Double.NaN;
                }
                M = DoubleMatrixFactory.DEFAULT.make(1, nparm, 0.0);
                M.set(0, nparm - 2, -0.5);
                M.set(0, nparm - 1, -0.5);
                Mb = M.mult(result.beta);
                result.domEffect = Mb.get(0, 0);
                try {
                    result.Fdom = Mb.get(0, 0) * Mb.get(0, 0) / M.mult(invXVX.tcrossproduct(M)).get(0, 0);
                }
                catch (Exception ex) {
                    result.Fdom = Double.NaN;
                }
                try {
                    result.pdom = LinearModelUtils.Ftest(result.Fdom, 1.0, y.numberOfRows() - nparm);
                }
                catch (Exception e) {
                    result.pdom = Double.NaN;
                }
            }
        }
    }

    private void calculateRsquare(DoubleMatrix X, DoubleMatrix y, DoubleMatrix invV, CompressedMLMResult result, int markerdf) {
        int dimX = X.numberOfColumns();
        int dimXreduced = dimX - markerdf;
        int[] colsToKeep = new int[dimXreduced];
        for (int i = 0; i < dimXreduced; ++i) {
            colsToKeep[i] = i;
        }
        DoubleMatrix Xreduced = X.getSelection(null, colsToKeep);
        DoubleMatrix invXVX = Xreduced.crossproduct(invV).mult(Xreduced);
        invXVX.invert();
        DoubleMatrix betaReduced = invXVX.mult(Xreduced.crossproduct(invV.mult(y)));
        DoubleMatrix yhat = X.mult(result.beta);
        DoubleMatrix yhatReduced = Xreduced.mult(betaReduced);
        yhat.minusEquals(yhatReduced);
        double sum = 0.0;
        int n = y.numberOfRows();
        for (int i = 0; i < n; ++i) {
            sum += y.get(i, 0);
        }
        double mean = sum / (double)n;
        DoubleMatrix ydev = y.scalarAdd(-mean);
        double numerator = yhat.crossproduct(invV).mult(yhat).get(0, 0);
        double denominator = ydev.crossproduct(invV).mult(ydev).get(0, 0);
        result.r2 = numerator / denominator;
    }

    public DoubleMatrix calculateV(DoubleMatrix ZKZ, double genvar, double resvar) {
        DoubleMatrix V = ZKZ.scalarMult(genvar);
        int n = V.numberOfRows();
        for (int i = 0; i < n; ++i) {
            V.set(i, i, V.get(i, i) + resvar);
        }
        return V;
    }

    public DoubleMatrix calculateV(DoubleMatrix ZKZ, DoubleMatrix W, double genvar, double resvar) {
        DoubleMatrix V = ZKZ.scalarMult(genvar);
        int n = V.numberOfRows();
        for (int i = 0; i < n; ++i) {
            V.set(i, i, V.get(i, i) + W.get(i, i) * resvar);
        }
        return V;
    }

    public DistanceMatrix calculateDistanceFromKin(DistanceMatrix kin) {
        int n = kin.getSize();
        double max = kin.getDistance(0, 0);
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, (double)kin.getDistance(i, i));
        }
        double constant = max > 2.0 ? max : (max > 1.0 ? 2.0 : 1.0);
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(kin.getTaxaList());
        for (int r = 0; r < n; ++r) {
            builder.set(r, r, constant - (double)kin.getDistance(r, r));
            for (int c = r + 1; c < n; ++c) {
                double newval = constant - (double)kin.getDistance(r, c);
                builder.set(r, c, newval);
            }
        }
        return builder.build();
    }

    public TaxaList updateMissingWithKinship(BitSet missing, Taxon[] phenotypeTaxa) {
        int n = phenotypeTaxa.length;
        for (int i = 0; i < n; ++i) {
            int ndx = this.kinshipMatrix.whichIdNumber(phenotypeTaxa[i]);
            if (ndx >= 0) continue;
            missing.fastSet(i);
        }
        Taxon[] nonMissingTaxa = AssociationUtils.getNonMissingValues(phenotypeTaxa, missing);
        Set taxaSet = Arrays.stream(nonMissingTaxa).collect(Collectors.toCollection(HashSet::new));
        return new TaxaListBuilder().addAll(taxaSet).build();
    }

    public Datum createResPhenotype(EMMAforDoubleMatrix emma, List<Taxon> taxa, String traitName) {
        emma.calculateBlupsPredictedResiduals();
        DoubleMatrix res = emma.getRes();
        int nres = res.numberOfRows();
        float[] resarray = new float[nres];
        for (int i = 0; i < nres; ++i) {
            resarray[i] = (float)res.get(i, 0);
        }
        ArrayList<PhenotypeAttribute> attrList = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> typeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        attrList.add(new TaxaAttribute(taxa));
        typeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        attrList.add(new NumericAttribute(traitName, resarray, new OpenBitSet(nres)));
        typeList.add(Phenotype.ATTRIBUTE_TYPE.data);
        Phenotype residualPheno = new PhenotypeBuilder().fromAttributeList(attrList, typeList).build().get(0);
        String name = String.format("Residuals for %s.", traitName);
        String comment = String.format("Residuals for %s calculated by MLM, no markers fit\nDataset: %s\n", traitName, this.datasetName);
        Datum output = new Datum(name, residualPheno, comment);
        return output;
    }

    public void setTestMarkers(boolean testMarkers) {
        this.testMarkers = testMarkers;
    }

    class CompressedMLMResult {
        DoubleMatrix beta = null;
        double F = Double.NaN;
        double p = Double.NaN;
        double Fadd = Double.NaN;
        double padd = Double.NaN;
        double Fdom = Double.NaN;
        double pdom = Double.NaN;
        double r2 = Double.NaN;
        double addEffect = Double.NaN;
        double domEffect = Double.NaN;
        int modeldf;
        int markerdf;
        int ngroups;

        CompressedMLMResult() {
        }
    }
}

