/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.util.ArrayList;
import net.maizegenetics.analysis.association.AbstractFixedEffectLM;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class DiscreteSitesFELM
extends AbstractFixedEffectLM {
    String[] siteGenotypes;

    public DiscreteSitesFELM(Datum dataset, FixedEffectLMPlugin parentPlugin) {
        super(dataset, parentPlugin);
    }

    @Override
    protected void analyzeSite() {
        double pdom;
        double Fdom;
        double padd;
        double Fadd;
        double p;
        this.myModel = new ArrayList(this.myBaseModel);
        GenotypeTable myGenotype = this.myGenoPheno.genotypeTable();
        Object[] siteGenotypes = AssociationUtils.getNonMissingValues(this.myGenoPheno.getStringGenotype(this.myCurrentSite), (BitSet)this.missingObsForSite);
        ArrayList<String> markerIds = new ArrayList<String>();
        int[] markerLevels = ModelEffectUtils.getIntegerLevelsSortedByGenotype((String[])siteGenotypes, markerIds);
        String siteName = myGenotype.siteName(this.myCurrentSite);
        FactorModelEffect markerEffect = new FactorModelEffect(markerLevels, true, siteName);
        int firstMarkerParm = this.myModel.size();
        this.myModel.add(markerEffect);
        this.taxaEffectNumber = -1;
        if (this.areTaxaReplicated) {
            this.taxaEffectNumber = this.myModel.size();
            this.myModel.add(this.taxaEffect());
        }
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.siteData);
        double[] modelSSdf = sflm.getModelcfmSSdf();
        double[] residSSdf = sflm.getResidualSSdf();
        double[] totalSSdf = new double[]{modelSSdf[0] + residSSdf[0], modelSSdf[1] + residSSdf[1]};
        this.markerSSdf = sflm.getIncrementalSSdf(this.numberOfBaseEffects);
        this.errorSSdf = this.areTaxaReplicated ? sflm.getIncrementalSSdf(this.taxaEffectNumber) : residSSdf;
        double F = this.markerSSdf[0] / this.markerSSdf[1] / this.errorSSdf[0] * this.errorSSdf[1];
        try {
            p = LinearModelUtils.Ftest(F, this.markerSSdf[1], this.errorSSdf[1]);
        }
        catch (Exception e) {
            p = Double.NaN;
        }
        double[] beta = sflm.getBeta();
        this.G = null;
        if (this.permute) {
            this.G = sflm.getInverseOfXtX();
        }
        double domEffect = Double.NaN;
        double addEffect = Double.NaN;
        if (this.appendAddDomEffects && myGenotype.alleles(this.myCurrentSite).length == 2) {
            if (markerIds.size() == 2) {
                addEffect = Math.abs(beta[firstMarkerParm] / 2.0);
            } else if (markerIds.size() == 3) {
                addEffect = Math.abs((beta[firstMarkerParm] - beta[firstMarkerParm + 1]) / 2.0);
                domEffect = -(beta[firstMarkerParm] + beta[firstMarkerParm + 1]) / 2.0;
            }
        }
        ArrayList<ModelEffect> myAdditiveModel = new ArrayList<ModelEffect>(this.myBaseModel);
        byte[] alleles = myGenotype.alleles(this.myCurrentSite);
        int nAlleles = alleles.length;
        if (nAlleles < 2) {
            Fadd = Double.NaN;
            padd = Double.NaN;
            Fdom = Double.NaN;
            pdom = Double.NaN;
        } else {
            double[] domTermSSdf;
            for (int a = 0; a < nAlleles - 1; ++a) {
                String stringAllele = NucleotideAlignmentConstants.getHaplotypeNucleotide(alleles[a]);
                myAdditiveModel.add(new CovariateModelEffect(ModelEffectUtils.getNumericCodingForAdditiveModel(siteGenotypes, stringAllele)));
            }
            int addModelTaxaEffectNumber = -1;
            if (this.areTaxaReplicated) {
                addModelTaxaEffectNumber = myAdditiveModel.size();
                myAdditiveModel.add(this.taxaEffect());
            }
            SweepFastLinearModel sflmAdd = new SweepFastLinearModel(myAdditiveModel, this.siteData);
            double[] additiveErrorSSdf = this.areTaxaReplicated ? sflmAdd.getIncrementalSSdf(addModelTaxaEffectNumber) : sflmAdd.getResidualSSdf();
            double[] addTermSSdf = new double[2];
            for (int a = 0; a < nAlleles - 1; ++a) {
                double[] thisTermSSdf = sflmAdd.getIncrementalSSdf(a + this.numberOfBaseEffects);
                addTermSSdf[0] = addTermSSdf[0] + thisTermSSdf[0];
                addTermSSdf[1] = addTermSSdf[1] + thisTermSSdf[1];
            }
            Fadd = addTermSSdf[0] / addTermSSdf[1] / additiveErrorSSdf[0] * additiveErrorSSdf[1];
            if (Double.isFinite(Fadd)) {
                try {
                    padd = LinearModelUtils.Ftest(Fadd, addTermSSdf[1], additiveErrorSSdf[1]);
                }
                catch (Exception e) {
                    padd = Double.NaN;
                }
            } else {
                padd = Double.NaN;
                Fadd = Double.NaN;
            }
            if (Double.isFinite(Fdom = (domTermSSdf = new double[]{this.markerSSdf[0] - addTermSSdf[0], this.markerSSdf[1] - addTermSSdf[1]})[0] / domTermSSdf[1] / this.errorSSdf[0] * this.errorSSdf[1])) {
                try {
                    pdom = LinearModelUtils.Ftest(Fdom, domTermSSdf[1], this.errorSSdf[1]);
                }
                catch (Exception e) {
                    pdom = Double.NaN;
                }
            } else {
                pdom = Double.NaN;
                Fdom = Double.NaN;
            }
        }
        if (this.maxP == 1.0 || p <= this.maxP) {
            Object[] rowData = new Object[this.numberOfSiteReportColumns];
            int columnCount = 0;
            rowData[columnCount++] = this.currentTraitName;
            rowData[columnCount++] = siteName;
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomeName(this.myCurrentSite);
            rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomalPosition(this.myCurrentSite);
            rowData[columnCount++] = new Double(F);
            rowData[columnCount++] = new Double(p);
            if (this.permute) {
                rowData[columnCount++] = "";
            }
            rowData[columnCount++] = new Double(this.markerSSdf[0] / totalSSdf[0]);
            rowData[columnCount++] = new Double(Fadd);
            rowData[columnCount++] = new Double(padd);
            rowData[columnCount++] = new Double(Fdom);
            rowData[columnCount++] = new Double(pdom);
            rowData[columnCount++] = new Double(this.markerSSdf[1]);
            rowData[columnCount++] = new Double(this.markerSSdf[0] / this.markerSSdf[1]);
            rowData[columnCount++] = new Double(this.errorSSdf[1]);
            rowData[columnCount++] = new Double(this.errorSSdf[0] / this.errorSSdf[1]);
            rowData[columnCount++] = new Double(modelSSdf[1]);
            rowData[columnCount++] = new Double(modelSSdf[0] / modelSSdf[1]);
            rowData[columnCount++] = new Integer(this.myCurrentSiteMinimumClassSize);
            if (this.appendAddDomEffects) {
                rowData[columnCount++] = new Double(addEffect);
                rowData[columnCount++] = new Double(domEffect);
            }
            this.siteReportBuilder.add(rowData);
            if (this.permute) {
                this.siteTableReportRows.add(rowData);
            }
            if (nAlleles > 1) {
                int numberOfAlleles = markerIds.size();
                int[] alleleCounts = markerEffect.getLevelCounts();
                int firstEstimateIndex = beta.length - numberOfAlleles + 1;
                for (int a = 0; a < numberOfAlleles; ++a) {
                    rowData = new Object[this.numberOfAlleleReportColumns];
                    columnCount = 0;
                    rowData[columnCount++] = this.currentTraitName;
                    rowData[columnCount++] = siteName;
                    rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomeName(this.myCurrentSite);
                    rowData[columnCount++] = this.myGenoPheno.genotypeTable().chromosomalPosition(this.myCurrentSite);
                    rowData[columnCount++] = new Integer(alleleCounts[a]);
                    rowData[columnCount++] = markerIds.get(a);
                    rowData[columnCount++] = a < numberOfAlleles - 1 ? new Double(beta[firstEstimateIndex + a]) : new Double(0.0);
                    this.alleleReportBuilder.add(rowData);
                }
            }
        }
    }

    @Override
    protected void getGenotypeAndUpdateMissing(BitSet missingObsBeforeSite) {
        String[] allSiteGenotypes = this.myGenoPheno.getStringGenotype(this.myCurrentSite);
        int n = allSiteGenotypes.length;
        this.missingObsForSite = new OpenBitSet(missingObsBeforeSite);
        for (int i = 0; i < n; ++i) {
            if (!allSiteGenotypes[i].contains("N")) continue;
            this.missingObsForSite.fastSet(i);
        }
        this.siteGenotypes = AssociationUtils.getNonMissingValues(allSiteGenotypes, (BitSet)this.missingObsForSite);
    }

    @Override
    protected void getGenotypeAfterUpdatingMissing() {
        this.siteGenotypes = AssociationUtils.getNonMissingValues(this.myGenoPheno.getStringGenotype(this.myCurrentSite), (BitSet)this.missingObsForSite);
    }
}

