/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.b4r;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.gobii.GOBIIPostgresConnection;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeUtils;

public class B4RPhenotypeUtils {
    public static Phenotype getPhenotypeFromB4RMergeDuplicates(String dbURL, String db, String userName, String password, String studyName, String taxaName, String variableName) throws Exception {
        Connection conn = B4RPhenotypeUtils.setupB4RConnection(dbURL, db, userName, password);
        String query = B4RPhenotypeUtils.buildSQLQuery(studyName, taxaName, variableName);
        System.out.println(query);
        ArrayList<ArrayList<String>> phenotypesArrayList = B4RPhenotypeUtils.pullPhenotypes(conn, query, studyName, taxaName, variableName);
        System.out.println("Create the Phenotype Object");
        Phenotype pheno = PhenotypeUtils.createPhenotypeObjectFromDB(phenotypesArrayList);
        return pheno;
    }

    public static Phenotype getPhenotypeFromB4RWithDuplicates(String dbURL, String db, String userName, String password, String studyName, String taxaName, String variableName) throws Exception {
        Connection conn = B4RPhenotypeUtils.setupB4RConnection(dbURL, db, userName, password);
        String query = B4RPhenotypeUtils.buildSQLQuery(studyName, taxaName, variableName);
        System.out.println(query);
        ArrayList<ArrayList<String>> phenotypesArrayList = B4RPhenotypeUtils.pullPhenotypes(conn, query, studyName, taxaName, variableName);
        System.out.println("Create the Phenotype Object");
        Phenotype pheno = PhenotypeUtils.createPhenotypeObjectFromDB2(phenotypesArrayList);
        return pheno;
    }

    public static Phenotype getPhenotypeFromB4RWithRepNumber(String dbURL, String db, String userName, String password, String studyName, String taxaName, String variableName, String repNumber) throws Exception {
        Connection conn = B4RPhenotypeUtils.setupB4RConnection(dbURL, db, userName, password);
        String query = B4RPhenotypeUtils.buildSQLQueryWithRep(studyName, taxaName, variableName, repNumber);
        ArrayList<ArrayList<String>> phenotypesArrayList = B4RPhenotypeUtils.pullPhenotypes(conn, query, studyName, taxaName, variableName, repNumber);
        System.out.println("Create the Phenotype Object");
        Phenotype pheno = PhenotypeUtils.createPhenotypeObjectFromDB2(phenotypesArrayList);
        return pheno;
    }

    private static Connection setupB4RConnection(String dbURL, String db, String userName, String password) {
        return GOBIIPostgresConnection.connection(dbURL, userName, password, db);
    }

    private static String buildSQLQuery(String studyName, String taxaName, String variableName) {
        String query = "SELECT S.title, E.product_name, P.plotno, Var.name, PD.value\nFROM operational.study AS S\nINNER JOIN operational.entry AS E ON S.id = E.study_id\nINNER JOIN operational.plot AS P ON S.id = P.study_id AND E.id = P.entry_id\nINNER JOIN operational.plot_data AS PD ON S.id = PD.study_id AND E.id = PD.entry_id AND P.id = PD.plot_id\nINNER JOIN master.variable AS Var ON PD.variable_id = Var.id\n";
        ArrayList<String> whereTerms = new ArrayList<String>();
        if (studyName.length() > 0) {
            whereTerms.add("S.title = ? ");
        }
        if (taxaName.length() > 0) {
            whereTerms.add("E.product_name = ? ");
        }
        if (variableName.length() > 0) {
            whereTerms.add("var.name = ? ");
        }
        if (whereTerms.size() == 0) {
            return query;
        }
        String whereComponent = whereTerms.stream().collect(Collectors.joining(" AND "));
        return query + " WHERE " + whereComponent;
    }

    private static String buildSQLQueryWithRep(String studyName, String taxaName, String variableName, String repNum) {
        String query = "SELECT S.title, E.product_name, P.plotno, Var.name, PD.value\nFROM operational.study AS S\nINNER JOIN operational.entry AS E ON S.id = E.study_id\nINNER JOIN operational.plot AS P ON S.id = P.study_id AND E.id = P.entry_id\nINNER JOIN operational.plot_data AS PD ON S.id = PD.study_id AND E.id = PD.entry_id AND P.id = PD.plot_id\nINNER JOIN master.variable AS Var ON PD.variable_id = Var.id\n";
        ArrayList<String> whereTerms = new ArrayList<String>();
        if (studyName.length() > 0) {
            whereTerms.add("S.title = ? ");
        }
        if (taxaName.length() > 0) {
            whereTerms.add("E.product_name = ? ");
        }
        if (variableName.length() > 0) {
            whereTerms.add("var.name = ? ");
        }
        if (repNum.length() > 0) {
            whereTerms.add("P.rep = ? ");
        }
        if (whereTerms.size() == 0) {
            return query;
        }
        String whereComponent = whereTerms.stream().collect(Collectors.joining(" AND "));
        return query + " WHERE " + whereComponent;
    }

    private static ArrayList<ArrayList<String>> pullPhenotypes(Connection connection, String query, String studyName, String taxaName, String variableName) throws Exception {
        ArrayList<ArrayList<String>> phenotypeObject = new ArrayList<ArrayList<String>>();
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        PreparedStatement phenoPS = connection.prepareStatement(query);
        int psCounter = 1;
        if (studyName.length() > 0) {
            phenoPS.setString(psCounter, studyName);
            ++psCounter;
        }
        if (taxaName.length() > 0) {
            phenoPS.setString(psCounter, taxaName);
            ++psCounter;
        }
        if (variableName.length() > 0) {
            phenoPS.setString(psCounter, variableName);
            ++psCounter;
        }
        ResultSet phenoResults = phenoPS.executeQuery();
        System.out.println("Retrieved Result Set from DB");
        while (phenoResults.next()) {
            for (int i = 0; i < phenotypeObject.size(); ++i) {
                phenotypeObject.get(i).add(phenoResults.getString(i + 1));
            }
        }
        return phenotypeObject;
    }

    private static ArrayList<ArrayList<String>> pullPhenotypes(Connection connection, String query, String studyName, String taxaName, String variableName, String repNo) throws Exception {
        ArrayList<ArrayList<String>> phenotypeObject = new ArrayList<ArrayList<String>>();
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        phenotypeObject.add(new ArrayList());
        PreparedStatement phenoPS = connection.prepareStatement(query);
        int psCounter = 1;
        if (studyName.length() > 0) {
            phenoPS.setString(psCounter, studyName);
            ++psCounter;
        }
        if (taxaName.length() > 0) {
            phenoPS.setString(psCounter, taxaName);
            ++psCounter;
        }
        if (variableName.length() > 0) {
            phenoPS.setString(psCounter, variableName);
            ++psCounter;
        }
        if (repNo.length() > 0) {
            phenoPS.setInt(psCounter, Integer.parseInt(repNo));
            ++psCounter;
        }
        ResultSet phenoResults = phenoPS.executeQuery();
        System.out.println("Retrieved Result Set from DB");
        while (phenoResults.next()) {
            for (int i = 0; i < phenotypeObject.size(); ++i) {
                phenotypeObject.get(i).add(phenoResults.getString(i + 1));
            }
        }
        return phenotypeObject;
    }

    private static void printPhenos(ArrayList<ArrayList<String>> phenos) {
        System.out.println("tissueName\ttaxaName\tplotno\tvarName\tvalue");
        for (int i = 0; i < phenos.get(0).size(); ++i) {
            for (int j = 0; j < phenos.size(); ++j) {
                System.out.print(phenos.get(j).get(i) + "\t");
            }
            System.out.println();
        }
    }
}

