/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PlotOptionsQQDialog
extends JDialog {
    boolean isCanceled = true;
    String[] myTraits;
    private JPanel mainPanel = new JPanel();
    private JButton okayButton = new JButton();
    private JButton cancelButton = new JButton();
    private JLabel sliderLabel1 = new JLabel();
    private JSlider slider = new JSlider();
    private JLabel countLabel1 = new JLabel();
    private JLabel listLabel1 = new JLabel();
    private JLabel listLabel2 = new JLabel();
    private JTextField countTextField = new JTextField();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JList list1 = new JList();
    private JList list2 = new JList();
    private JButton addAllButton = new JButton();
    private JButton addOneButton = new JButton();
    private JButton removeAllButton = new JButton();
    private JButton removeOneButton = new JButton();

    public PlotOptionsQQDialog(Frame f, String[] traits, ArrayList<Integer> indexes) {
        super(f, "QQ Plot Options", true);
        this.myTraits = traits;
        int numSites = indexes.get(1) - indexes.get(0);
        this.slider.setMinimum(1);
        this.slider.setMaximum(numSites);
        this.slider.setValue((int)((double)numSites * 0.01));
        this.countTextField.setText("" + (int)((double)numSites * 0.01));
        try {
            this.initUI();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void initUI() throws Exception {
        this.mainPanel.setMinimumSize(new Dimension(400, 230));
        this.mainPanel.setPreferredSize(new Dimension(400, 230));
        this.mainPanel.setLayout(this.gridBagLayout2);
        this.listLabel1.setText("Available Traits");
        this.listLabel2.setText("Traits to Plot");
        this.list1.setSelectionMode(2);
        this.list1.setLayoutOrientation(0);
        this.list1.setVisibleRowCount(5);
        this.list1.setMinimumSize(new Dimension(100, 104));
        this.list1.setBackground(Color.white);
        this.list1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.list2.setListData(this.myTraits);
        this.list2.setSelectionMode(2);
        this.list2.setLayoutOrientation(0);
        this.list2.setVisibleRowCount(5);
        this.list2.setMinimumSize(new Dimension(100, 104));
        this.list2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.addAllButton.setText(">>");
        this.addAllButton.setMaximumSize(new Dimension(63, 27));
        this.addAllButton.setMinimumSize(new Dimension(63, 27));
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsQQDialog.this.addAllButton_actionPerformed(e);
            }
        });
        this.addOneButton.setText(">");
        this.addOneButton.setMaximumSize(new Dimension(63, 27));
        this.addOneButton.setMinimumSize(new Dimension(63, 27));
        this.addOneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsQQDialog.this.addOneButton_actionPerformed(e);
            }
        });
        this.removeOneButton.setText("<");
        this.removeOneButton.setMaximumSize(new Dimension(63, 27));
        this.removeOneButton.setMinimumSize(new Dimension(63, 27));
        this.removeOneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsQQDialog.this.removeOneButton_actionPerformed(e);
            }
        });
        this.removeAllButton.setText("<<");
        this.removeAllButton.setMaximumSize(new Dimension(63, 27));
        this.removeAllButton.setMinimumSize(new Dimension(63, 27));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsQQDialog.this.removeAllButton_actionPerformed(e);
            }
        });
        this.sliderLabel1.setText("Plot Density:");
        this.sliderLabel1.setToolTipText("Plot Density is then number of Significant Points plotted without removing data. The rest of the data is plotted at a regular interval to maintain the trend without drawing all the points.");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                PlotOptionsQQDialog.this.slider_actionPerformed(ce);
            }
        });
        if (this.myTraits.length == 1) {
            this.mainPanel.setMinimumSize(new Dimension(400, 100));
            this.mainPanel.setPreferredSize(new Dimension(400, 100));
            this.listLabel1.setVisible(false);
            this.listLabel2.setVisible(false);
            this.list1.setVisible(false);
            this.list2.setVisible(false);
            this.addAllButton.setVisible(false);
            this.addOneButton.setVisible(false);
            this.removeOneButton.setVisible(false);
            this.removeAllButton.setVisible(false);
        }
        this.countTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent ke) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                PlotOptionsQQDialog.this.countTextField_keyTyped(ke);
            }
        });
        this.countLabel1.setText("of " + this.slider.getMaximum() + " points per trait.");
        this.okayButton.setMaximumSize(new Dimension(95, 27));
        this.okayButton.setMinimumSize(new Dimension(95, 27));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsQQDialog.this.okayButton_actionPerformed(e);
            }
        });
        this.cancelButton.setMaximumSize(new Dimension(95, 27));
        this.cancelButton.setMinimumSize(new Dimension(95, 27));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotOptionsQQDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.mainPanel.add((Component)this.listLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.listLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.mainPanel.add((Component)new JScrollPane(this.list1), new GridBagConstraints(0, 1, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.mainPanel.add((Component)new JScrollPane(this.list2), new GridBagConstraints(2, 1, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.addAllButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.addOneButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.removeOneButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.removeAllButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.sliderLabel1, new GridBagConstraints(0, 5, 1, 2, 0.0, 0.0, 22, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.slider, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.countTextField, new GridBagConstraints(1, 6, 1, 1, 0.7, 0.7, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.countLabel1, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.okayButton, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.mainPanel, "Center");
    }

    private void addAllButton_actionPerformed(ActionEvent e) {
        this.list1.setListData(new Object[0]);
        this.list2.setListData(this.myTraits);
        this.okayButton.setEnabled(true);
    }

    private void addOneButton_actionPerformed(ActionEvent e) {
        Object[] selected = this.list1.getSelectedValues();
        ListModel listModel = this.list2.getModel();
        String[] toList = new String[listModel.getSize() + selected.length];
        String[] fromList = new String[this.myTraits.length - toList.length];
        int j = 0;
        int k = 0;
        int l = 0;
        int m = 0;
        for (int i = 0; i < this.myTraits.length; ++i) {
            if (j < selected.length && this.myTraits[i].equals(selected[j])) {
                toList[l] = this.myTraits[i];
                ++j;
                ++l;
                continue;
            }
            if (k < listModel.getSize() && this.myTraits[i].equals(listModel.getElementAt(k))) {
                toList[l] = this.myTraits[i];
                ++k;
                ++l;
                continue;
            }
            fromList[m] = this.myTraits[i];
            ++m;
        }
        this.list1.setListData(fromList);
        this.list2.setListData(toList);
        if (toList.length > 0) {
            this.okayButton.setEnabled(true);
        }
    }

    private void removeOneButton_actionPerformed(ActionEvent e) {
        Object[] selected = this.list2.getSelectedValues();
        ListModel listModel = this.list1.getModel();
        String[] toList = new String[listModel.getSize() + selected.length];
        String[] fromList = new String[this.myTraits.length - toList.length];
        int j = 0;
        int k = 0;
        int l = 0;
        int m = 0;
        for (int i = 0; i < this.myTraits.length; ++i) {
            if (j < selected.length && this.myTraits[i].equals(selected[j])) {
                toList[l] = this.myTraits[i];
                ++j;
                ++l;
                continue;
            }
            if (k < listModel.getSize() && this.myTraits[i].equals(listModel.getElementAt(k))) {
                toList[l] = this.myTraits[i];
                ++k;
                ++l;
                continue;
            }
            fromList[m] = this.myTraits[i];
            ++m;
        }
        this.list2.setListData(fromList);
        this.list1.setListData(toList);
        if (fromList.length < 1) {
            this.okayButton.setEnabled(false);
        }
    }

    private void removeAllButton_actionPerformed(ActionEvent e) {
        this.list2.setListData(new Object[0]);
        this.list1.setListData(this.myTraits);
        this.okayButton.setEnabled(false);
    }

    private void okayButton_actionPerformed(ActionEvent e) {
        this.isCanceled = false;
        this.setVisible(false);
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.isCanceled = true;
        this.setVisible(false);
    }

    private void slider_actionPerformed(ChangeEvent cd) {
        this.countTextField.setText("" + this.slider.getValue());
    }

    private void countTextField_keyTyped(KeyEvent e) {
        try {
            if (!this.countTextField.getText().equals("")) {
                int value = Integer.valueOf(this.countTextField.getText());
                if (value >= this.slider.getMinimum() && value <= this.slider.getMaximum()) {
                    this.slider.setValue(value);
                } else if (value <= this.slider.getMinimum()) {
                    this.slider.setValue(this.slider.getMinimum());
                    this.countTextField.setText("" + this.slider.getMinimum());
                } else if (value >= this.slider.getMaximum()) {
                    this.slider.setValue(this.slider.getMaximum());
                    this.countTextField.setText("" + this.slider.getMaximum());
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.countTextField.setText("" + this.slider.getValue());
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public int getSliderValue() {
        return this.slider.getValue();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(600, 600);
    }

    public String[] getSelectedTraits() {
        ListModel list = this.list2.getModel();
        String[] traits = new String[list.getSize()];
        for (int i = 0; i < traits.length; ++i) {
            traits[i] = list.getElementAt(i).toString();
        }
        return traits;
    }

    public int[] getTraitIndices() {
        ListModel list = this.list2.getModel();
        int[] indices = new int[list.getSize()];
        int j = 0;
        for (int i = 0; i < this.myTraits.length; ++i) {
            if (j >= list.getSize() || !this.myTraits[i].equals(list.getElementAt(j))) continue;
            indices[j] = i;
            ++j;
        }
        return indices;
    }
}

