/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.font.TextAttribute;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.ManhattanDisplayPlugin;
import net.maizegenetics.analysis.chart.ManhattanNumberFormat;
import net.maizegenetics.analysis.chart.TableReportManhattanDataset;
import net.maizegenetics.analysis.chart.XYMultipleYToolTipGenerator;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;

public class XYScatterMultipleYPanel
extends BasicChartPanel {
    private final ManhattanDisplayPlugin myManhattanDisplayPlugin;
    private final ChartPanel myChartPanel;
    private final TableReportManhattanDataset dataset;

    public XYScatterMultipleYPanel(ManhattanDisplayPlugin plugin, TableReport theTable, int start, int end) {
        this.myManhattanDisplayPlugin = plugin;
        this.dataset = new TableReportManhattanDataset(theTable, start, end);
        this.chart = this.createChart(this.dataset);
        this.myChartPanel = new ChartPanel(this.chart);
        this.myChartPanel.setPreferredSize(new Dimension(900, 500));
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BoxLayout(this, 3));
        this.add((Component)this.myChartPanel);
        JButton saveButton = new JButton("save...");
        saveButton.setAlignmentX(1.0f);
        saveButton.addActionListener(e -> this.myManhattanDisplayPlugin.saveDataToFile((Component)this.myChartPanel));
        this.add(saveButton);
    }

    public JFreeChart createChart(TableReportManhattanDataset dataset) {
        int seriesCount;
        String name = "Please select numeric variables";
        String xName = "X";
        String yName = "Y";
        if (dataset != null) {
            xName = dataset.getXName();
            yName = "-Log10(P-Value)";
            name = "P-Values by Chromosome for " + dataset.getTrait();
        }
        if ((seriesCount = dataset.getSeriesCount()) < 200) {
            this.chart = ChartFactory.createScatterPlot((String)name, (String)xName, (String)yName, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            if (seriesCount > 21) {
                int fontSize = 5;
                if (seriesCount < 30) {
                    fontSize = 11;
                } else if (seriesCount < 50) {
                    fontSize = 10;
                } else if (seriesCount < 70) {
                    fontSize = 9;
                } else if (seriesCount < 90) {
                    fontSize = 8;
                } else if (seriesCount < 110) {
                    fontSize = 7;
                } else if (seriesCount < 130) {
                    fontSize = 6;
                }
                LegendTitle title = this.chart.getLegend();
                Map<TextAttribute, ?> attributes = title.getItemFont().getAttributes();
                attributes.put(TextAttribute.SIZE, fontSize);
                title.setItemFont(new Font(attributes));
            }
        } else {
            this.chart = ChartFactory.createScatterPlot((String)name, (String)xName, (String)yName, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        }
        this.chart.setBackgroundPaint((Paint)new Color(238, 238, 238));
        NumberAxis domainAxis = new NumberAxis(xName);
        domainAxis.setUpperMargin(0.01);
        domainAxis.setLowerMargin(0.01);
        domainAxis.setRangeWithMargins(dataset.getDomainBounds(true));
        ManhattanNumberFormat postionFormat = new ManhattanNumberFormat(NumberFormat.getIntegerInstance(), dataset.getActualPostions());
        domainAxis.setNumberFormatOverride((NumberFormat)postionFormat);
        domainAxis.setVerticalTickLabels(true);
        this.chart.getXYPlot().setDomainAxis((ValueAxis)domainAxis);
        this.chart.getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
        NumberAxis rangeAxis = new NumberAxis(yName);
        rangeAxis.setLowerMargin(0.01);
        rangeAxis.setRangeWithMargins(dataset.getRangeBounds());
        NumberFormat decimal = NumberFormat.getInstance();
        decimal.setMinimumFractionDigits(2);
        rangeAxis.setNumberFormatOverride(decimal);
        rangeAxis.setMinorTickMarksVisible(true);
        this.chart.getXYPlot().setRangeAxis((ValueAxis)rangeAxis);
        this.chart.getXYPlot().setBackgroundPaint((Paint)Color.WHITE);
        this.chart.getXYPlot().setForegroundAlpha(1.0f);
        this.chart.getXYPlot().getRenderer().setBaseToolTipGenerator((XYToolTipGenerator)new XYMultipleYToolTipGenerator(postionFormat));
        return this.chart;
    }

    @Override
    public JComponent getMainComponent() {
        return this.myChartPanel;
    }
}

