/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.clustering;

import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import net.maizegenetics.analysis.clustering.Haplotype;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;

public class HaplotypeCluster
implements Comparable<HaplotypeCluster> {
    private ArrayList<Haplotype> hapList;
    private double score = 0.0;
    private ArrayList<int[][]> alleleCounts = null;
    public static TYPE ReturnHaplotype = TYPE.unanimous;
    static byte N = NucleotideAlignmentConstants.getNucleotideDiploidByte('N');

    public HaplotypeCluster(ArrayList<Haplotype> hapList) {
        this.hapList = hapList;
    }

    public HaplotypeCluster(Haplotype hap) {
        this.hapList = new ArrayList();
        this.hapList.add(hap);
    }

    public HaplotypeCluster(Haplotype hap, double initialScore) {
        this.hapList = new ArrayList();
        this.hapList.add(hap);
        this.score = initialScore;
    }

    public HaplotypeCluster(ArrayList<Haplotype> hapList, double initialScore) {
        this.hapList = hapList;
        this.score = initialScore;
    }

    public int getSize() {
        return this.hapList.size();
    }

    public ArrayList<Haplotype> getHaplotypeList() {
        return this.hapList;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double newScore) {
        this.score = newScore;
    }

    public void incrementScore(double val) {
        this.score += val;
    }

    public Haplotype get(int index) {
        return this.hapList.get(index);
    }

    public void add(Haplotype hap) {
        this.hapList.add(hap);
    }

    public void remove(Haplotype hap) {
        this.hapList.remove(hap);
    }

    public void removeAll(HaplotypeCluster cluster2) {
        this.hapList.removeAll(cluster2.hapList);
    }

    public void addAll(HaplotypeCluster cluster2) {
        this.hapList.addAll(cluster2.hapList);
    }

    public Iterator<Haplotype> getIterator() {
        return this.hapList.iterator();
    }

    public void addAllUnique(HaplotypeCluster cluster2) {
        Iterator<Haplotype> hit = cluster2.getIterator();
        while (hit.hasNext()) {
            Haplotype hap = hit.next();
            if (this.hapList.contains(hap)) continue;
            this.hapList.add(hap);
        }
    }

    public int getCountOfHaplotypesNotInThisCluster(HaplotypeCluster cluster2) {
        int hapcount = 0;
        Iterator<Haplotype> hit = cluster2.getIterator();
        while (hit.hasNext()) {
            Haplotype hap = hit.next();
            if (this.hapList.contains(hap)) continue;
            ++hapcount;
        }
        return hapcount;
    }

    public int getMaximumDistance(Haplotype hap) {
        int maxd = 0;
        for (Haplotype myHaplotype : this.hapList) {
            int dist = myHaplotype.distanceFrom(hap);
            maxd = Math.max(maxd, dist);
        }
        return maxd;
    }

    public int[][] getAllelesAtSite(int site) {
        if (this.alleleCounts == null) {
            this.countAllelesAtAllSites();
        }
        return this.alleleCounts.get(site);
    }

    public void countAllelesAtAllSites() {
        this.alleleCounts = new ArrayList();
        byte NN = -1;
        int nsites = this.hapList.get((int)0).seqlen;
        int nhaps = this.hapList.size();
        for (int s = 0; s < nsites; ++s) {
            HashMultiset alleleset = HashMultiset.create();
            for (Haplotype hap : this.hapList) {
                byte val = hap.seq[s];
                if (val == NN) continue;
                alleleset.add((Object)val);
            }
            int nalleles = alleleset.elementSet().size();
            int[][] alleleStats = new int[nalleles][2];
            int alleleCount = 0;
            for (Byte allele : alleleset.elementSet()) {
                alleleStats[alleleCount][0] = allele.byteValue();
                alleleStats[alleleCount++][1] = alleleset.count((Object)allele);
            }
            if (nalleles > 1) {
                for (int i = 0; i < nalleles - 1; ++i) {
                    for (int j = i + 1; j < nalleles; ++j) {
                        if (alleleStats[i][1] >= alleleStats[j][1]) continue;
                        int[] tmp = alleleStats[i];
                        alleleStats[i] = alleleStats[j];
                        alleleStats[j] = tmp;
                    }
                }
            }
            this.alleleCounts.add(alleleStats);
        }
    }

    public HaplotypeCluster copy() {
        return new HaplotypeCluster(new ArrayList<Haplotype>(this.hapList), this.score);
    }

    @Override
    public int compareTo(HaplotypeCluster cluster2) {
        if (this.score > cluster2.score) {
            return -1;
        }
        if (this.score < cluster2.score) {
            return 1;
        }
        if (this.getSize() > cluster2.getSize()) {
            return -1;
        }
        if (this.getSize() < cluster2.getSize()) {
            return 1;
        }
        return 0;
    }

    public byte[] getHaplotype() {
        switch (ReturnHaplotype) {
            case unanimous: {
                return this.getUnanimousHaplotype();
            }
            case majority: {
                return this.getMajorityHaplotype();
            }
            case censored: {
                return this.getCensoredMajorityHaplotype(0.05, 1);
            }
        }
        return this.getUnanimousHaplotype();
    }

    public String getHaplotypeAsString() {
        switch (ReturnHaplotype) {
            case unanimous: {
                return this.byteHaplotypeAsString(this.getUnanimousHaplotype());
            }
            case majority: {
                return this.byteHaplotypeAsString(this.getMajorityHaplotype());
            }
        }
        return this.byteHaplotypeAsString(this.getUnanimousHaplotype());
    }

    public byte[] getMajorityHaplotype() {
        int nsites = this.hapList.get((int)0).seqlen;
        byte[] hap = new byte[nsites];
        Arrays.fill(hap, N);
        for (int s = 0; s < nsites; ++s) {
            HashMultiset byteset = HashMultiset.create((int)5);
            for (Haplotype h : this.hapList) {
                byte b = h.seq[s];
                if (b == N) continue;
                byteset.add((Object)h.seq[s]);
            }
            if (byteset.size() == 0) {
                hap[s] = N;
                continue;
            }
            Iterator it = byteset.elementSet().iterator();
            int maxcount = 0;
            Byte maxbyte = -1;
            boolean tie = false;
            while (it.hasNext()) {
                Byte thisbyte = (Byte)it.next();
                int thiscount = byteset.count((Object)thisbyte);
                if (thiscount > maxcount) {
                    maxcount = thiscount;
                    maxbyte = thisbyte;
                    tie = false;
                    continue;
                }
                if (thiscount != maxcount) continue;
                tie = true;
            }
            hap[s] = tie ? N : maxbyte;
        }
        return hap;
    }

    public byte[] getCensoredMajorityHaplotype(double maxMinorFreq, int maxMinorCount) {
        int nsites = this.hapList.get((int)0).seqlen;
        byte[] hap = new byte[nsites];
        Arrays.fill(hap, N);
        for (int s = 0; s < nsites; ++s) {
            HashMultiset byteset = HashMultiset.create((int)5);
            for (Haplotype h : this.hapList) {
                byte b = h.seq[s];
                if (b == N) continue;
                byteset.add((Object)h.seq[s]);
            }
            if (byteset.size() <= 0) continue;
            int majorcount = 0;
            int minorcount = 0;
            int totalcount = 0;
            Byte majorAllele = null;
            Byte minorAllele = null;
            for (Byte thisbyte : byteset.elementSet()) {
                int thiscount = byteset.count((Object)thisbyte);
                totalcount += thiscount;
                if (thiscount > majorcount) {
                    minorcount = majorcount;
                    minorAllele = majorAllele;
                    majorcount = thiscount;
                    majorAllele = thisbyte;
                    continue;
                }
                if (thiscount <= minorcount) continue;
                minorcount = thiscount;
                minorAllele = thisbyte;
            }
            double maf = (double)minorcount / (double)totalcount;
            if (!(maf <= maxMinorFreq) && minorcount > maxMinorCount) continue;
            hap[s] = majorAllele;
        }
        return hap;
    }

    public byte[] getUnanimousHaplotype() {
        int nsites = this.hapList.get((int)0).seqlen;
        byte[] hap = new byte[nsites];
        for (int s = 0; s < nsites; ++s) {
            HashSet<Byte> byteset = new HashSet<Byte>();
            HashMultiset multiByteset = HashMultiset.create();
            for (Haplotype haplo : this.hapList) {
                if (haplo.seq[s] == N) continue;
                byteset.add(haplo.seq[s]);
                multiByteset.add((Object)haplo.seq[s]);
            }
            int nNucleotidesObserved = byteset.size();
            hap[s] = nNucleotidesObserved == 1 ? Byte.valueOf((Byte)byteset.iterator().next()) : N;
        }
        return hap;
    }

    public String byteHaplotypeAsString(byte[] hap) {
        StringBuilder sb = new StringBuilder();
        for (byte h : hap) {
            sb.append(NucleotideAlignmentConstants.getNucleotideIUPAC(h));
        }
        return sb.toString();
    }

    public int getNumberOfSites() {
        return this.hapList.get((int)0).seqlen;
    }

    public int[] listTaxaInCluster() {
        int ntaxa = this.hapList.size();
        int[] taxa = new int[ntaxa];
        int tcount = 0;
        for (Haplotype hap : this.hapList) {
            taxa[tcount++] = hap.taxonIndex;
        }
        Arrays.sort(taxa);
        return taxa;
    }

    public int countTaxaSharedWith(HaplotypeCluster hapCluster) {
        int[] otherTaxa = hapCluster.listTaxaInCluster();
        Arrays.sort(otherTaxa);
        int count = 0;
        for (Haplotype hap : this.hapList) {
            if (Arrays.binarySearch(otherTaxa, hap.taxonIndex) <= -1) continue;
            ++count;
        }
        return count;
    }

    public boolean contains(Haplotype hap) {
        return this.hapList.contains(hap);
    }

    public int countHeterozygousSites() {
        this.countAllelesAtAllSites();
        int nhet = 0;
        int ntotal = this.getNumberOfSites();
        for (int s = 0; s < ntotal; ++s) {
            int[][] alleles = this.alleleCounts.get(s);
            if (alleles.length > 0 && GenotypeTableUtils.isHeterozygous((byte)alleles[0][0])) {
                ++nhet;
                continue;
            }
            if (alleles.length <= 1 || alleles[1][1] <= 1) continue;
            ++nhet;
        }
        return nhet;
    }

    public String toString() {
        return this.getHaplotypeAsString();
    }

    public static enum TYPE {
        majority,
        unanimous,
        censored;

    }
}

