/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.maizegenetics.analysis.clustering.Haplotype;
import net.maizegenetics.analysis.clustering.HaplotypeCluster;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;

public class HaplotypeClusterer {
    ArrayList<Haplotype> haplotypeList;
    int numberOfHaplotypes;
    int nsites;
    static final byte N = NucleotideAlignmentConstants.getNucleotideDiploidByte("N");
    ArrayList<HaplotypeCluster> clusterList;

    public HaplotypeClusterer(List<byte[]> haplotypes) {
        this.numberOfHaplotypes = haplotypes.size();
        this.nsites = haplotypes.get(0).length;
        this.haplotypeList = new ArrayList();
        for (byte[] hap : haplotypes) {
            this.haplotypeList.add(new Haplotype(hap));
        }
        Collections.sort(this.haplotypeList);
    }

    public HaplotypeClusterer(ArrayList<Haplotype> haplotypes) {
        this.numberOfHaplotypes = haplotypes.size();
        this.nsites = haplotypes.get((int)0).seqlen;
        this.haplotypeList = haplotypes;
        Collections.sort(this.haplotypeList);
    }

    public void makeClusters() {
        LinkedList<Haplotype> tmpHapList = new LinkedList<Haplotype>(this.haplotypeList);
        this.clusterList = new ArrayList();
        HaplotypeCluster cluster2 = new HaplotypeCluster(tmpHapList.removeFirst(), 1.0);
        this.clusterList.add(cluster2);
        Iterator hit = tmpHapList.iterator();
        while (hit.hasNext()) {
            boolean inCluster = false;
            Haplotype hap = (Haplotype)hit.next();
            for (HaplotypeCluster clus : this.clusterList) {
                if (clus.get(0).distanceFrom(hap) != 0) continue;
                inCluster = true;
                break;
            }
            if (inCluster) continue;
            HaplotypeCluster newCluster = new HaplotypeCluster(hap, 1.0);
            this.clusterList.add(newCluster);
            hit.remove();
        }
        int nclusters = this.clusterList.size();
        for (Haplotype hap : tmpHapList) {
            boolean[] incluster = new boolean[nclusters];
            Arrays.fill(incluster, true);
            int count = 0;
            for (int c = 0; c < nclusters; ++c) {
                HaplotypeCluster clus = this.clusterList.get(c);
                Iterator<Haplotype> clusIt = clus.getIterator();
                while (clusIt.hasNext() && incluster[c]) {
                    Haplotype member = clusIt.next();
                    if (member.distanceFrom(hap) <= 0) continue;
                    incluster[c] = false;
                }
                if (!incluster[c]) continue;
                ++count;
                clus.add(hap);
            }
            double hapscore = 1.0 / (double)count;
            for (int c = 0; c < nclusters; ++c) {
                if (!incluster[c]) continue;
                this.clusterList.get(c).incrementScore(hapscore);
            }
        }
    }

    public HaplotypeCluster removeFirstHaplotypes(int maxdistance) {
        ListIterator<Haplotype> hapit = this.haplotypeList.listIterator();
        byte[] firstHaplotype = this.clusterList.get(0).getHaplotype();
        ArrayList<Haplotype> haplist = new ArrayList<Haplotype>();
        while (hapit.hasNext()) {
            Haplotype testhap = (Haplotype)hapit.next();
            if (Haplotype.getDistance(firstHaplotype, testhap.seq) > maxdistance) continue;
            haplist.add(testhap);
            hapit.remove();
        }
        this.makeClusters();
        this.sortClusters();
        return new HaplotypeCluster(haplist, (double)haplist.size());
    }

    public void sortClusters() {
        Collections.sort(this.clusterList);
    }

    public int getNumberOfClusters() {
        return this.clusterList.size();
    }

    public int[] getClusterSizes() {
        int nclusters = this.clusterList.size();
        int[] sizes = new int[nclusters];
        for (int i = 0; i < nclusters; ++i) {
            sizes[i] = this.clusterList.get(i).getSize();
        }
        return sizes;
    }

    public double[] getClusterScores() {
        int n = this.clusterList.size();
        double[] scores = new double[n];
        for (int i = 0; i < n; ++i) {
            scores[i] = this.clusterList.get(i).getScore();
        }
        return scores;
    }

    public ArrayList<HaplotypeCluster> getClusterList() {
        return this.clusterList;
    }

    public static int clusterDistanceDistinctHaplotypes(HaplotypeCluster cluster0, HaplotypeCluster cluster1) {
        int count0 = cluster0.getCountOfHaplotypesNotInThisCluster(cluster1);
        int count1 = cluster1.getCountOfHaplotypesNotInThisCluster(cluster0);
        return Math.min(count0, count1);
    }

    public static double clusterDistanceDistinctHaplotypeProportion(HaplotypeCluster cluster0, HaplotypeCluster cluster1) {
        int count0 = cluster0.getCountOfHaplotypesNotInThisCluster(cluster1);
        int count1 = cluster1.getCountOfHaplotypesNotInThisCluster(cluster0);
        double minNumber = Math.min(cluster0.getSize(), cluster1.getSize());
        return (double)Math.min(count0, count1) / minNumber;
    }

    public static int clusterDistanceClusterHaplotypeDiff(HaplotypeCluster cluster0, HaplotypeCluster cluster1) {
        byte[] hap0 = cluster0.getHaplotype();
        byte[] hap1 = cluster1.getHaplotype();
        return Haplotype.getDistance(hap0, hap1);
    }

    public static double clusterDistanceClusterDiffProportion(HaplotypeCluster cluster0, HaplotypeCluster cluster1) {
        byte[] hap0 = cluster0.getHaplotype();
        byte[] hap1 = cluster1.getHaplotype();
        int n = hap0.length;
        double notmissing = 0.0;
        double notmatching = 0.0;
        byte N = NucleotideAlignmentConstants.getNucleotideDiploidByte('N');
        for (int i = 0; i < n; ++i) {
            if (hap0[i] == N || hap1[i] == N) continue;
            notmissing += 1.0;
            if (hap0[i] == hap1[i]) continue;
            notmatching += 1.0;
        }
        return notmatching / notmissing;
    }

    public static int clusterDistanceMaxPairDiff(HaplotypeCluster cluster0, HaplotypeCluster cluster1) {
        HaplotypeCluster subCluster0 = cluster0.copy();
        subCluster0.removeAll(cluster1);
        HaplotypeCluster subCluster1 = cluster1.copy();
        subCluster1.removeAll(cluster0);
        int maxdiff = 0;
        Iterator<Haplotype> hit0 = subCluster0.getIterator();
        while (hit0.hasNext()) {
            Haplotype h0 = hit0.next();
            Iterator<Haplotype> hit1 = subCluster1.getIterator();
            while (hit1.hasNext()) {
                Haplotype h1 = hit1.next();
                maxdiff = Math.max(maxdiff, Haplotype.getDistance(h0, h1));
            }
        }
        return maxdiff;
    }

    public static double clusterDistanceAveragePairDiff(HaplotypeCluster cluster0, HaplotypeCluster cluster1) {
        HaplotypeCluster subCluster0 = cluster0.copy();
        subCluster0.removeAll(cluster1);
        HaplotypeCluster subCluster1 = cluster1.copy();
        subCluster1.removeAll(cluster0);
        int totaldiff = 0;
        int count = 0;
        Iterator<Haplotype> hit0 = subCluster0.getIterator();
        while (hit0.hasNext()) {
            Haplotype h0 = hit0.next();
            Iterator<Haplotype> hit1 = subCluster1.getIterator();
            while (hit1.hasNext()) {
                Haplotype h1 = hit1.next();
                totaldiff += Haplotype.getDistance(h0, h1);
                ++count;
            }
        }
        return (double)totaldiff / (double)count;
    }

    public static int clusterDistanceTotalPairDiff(HaplotypeCluster cluster0, HaplotypeCluster cluster1) {
        HaplotypeCluster subCluster0 = cluster0.copy();
        subCluster0.removeAll(cluster1);
        HaplotypeCluster subCluster1 = cluster1.copy();
        subCluster1.removeAll(cluster0);
        int totaldiff = 0;
        Iterator<Haplotype> hit0 = subCluster0.getIterator();
        while (hit0.hasNext()) {
            Haplotype h0 = hit0.next();
            Iterator<Haplotype> hit1 = subCluster1.getIterator();
            while (hit1.hasNext()) {
                Haplotype h1 = hit1.next();
                totaldiff += Haplotype.getDistance(h0, h1);
            }
        }
        return totaldiff;
    }

    public static ArrayList<HaplotypeCluster> getMergedClusters(ArrayList<HaplotypeCluster> candidateClusters, int maxdiff) {
        ArrayList<HaplotypeCluster> candidates = new ArrayList<HaplotypeCluster>(candidateClusters);
        Collections.sort(candidates);
        ArrayList<HaplotypeCluster> mergedClusterList = new ArrayList<HaplotypeCluster>();
        while (candidates.size() > 0) {
            HaplotypeCluster headCluster = candidates.remove(0);
            mergedClusterList.add(headCluster);
            Iterator<HaplotypeCluster> cit = candidates.iterator();
            while (cit.hasNext()) {
                HaplotypeCluster candidate = cit.next();
                boolean mergePair = HaplotypeClusterer.doMerge(headCluster, candidate, maxdiff);
                if (!mergePair) continue;
                cit.remove();
                HaplotypeClusterer.mergeTwoClusters(headCluster, candidate);
            }
        }
        return mergedClusterList;
    }

    public void mergeClusters(int maxdiff) {
        ArrayList<HaplotypeCluster> candidates = new ArrayList<HaplotypeCluster>(this.clusterList);
        Collections.sort(candidates);
        ArrayList<HaplotypeCluster> mergedClusterList = new ArrayList<HaplotypeCluster>();
        while (candidates.size() > 0) {
            HaplotypeCluster headCluster = candidates.remove(0);
            mergedClusterList.add(headCluster);
            Iterator<HaplotypeCluster> cit = candidates.iterator();
            while (cit.hasNext()) {
                HaplotypeCluster candidate = cit.next();
                boolean mergePair = HaplotypeClusterer.doMerge(headCluster, candidate, maxdiff);
                if (!mergePair) continue;
                cit.remove();
                HaplotypeClusterer.mergeTwoClusters(headCluster, candidate);
            }
        }
        this.clusterList = mergedClusterList;
        this.recalculateScores();
    }

    public static boolean doMerge(HaplotypeCluster c0, HaplotypeCluster c1, int maxdiff) {
        int diff = HaplotypeClusterer.clusterDistanceMaxPairDiff(c0, c1);
        return diff <= maxdiff;
    }

    public static void mergeTwoClusters(HaplotypeCluster c0, HaplotypeCluster c1) {
        c1.removeAll(c0);
        c0.addAll(c1);
    }

    public void removeClusterHaplotypesFromOtherClusters(int clusterIndex) {
        HaplotypeCluster thisCluster = this.clusterList.get(clusterIndex);
        int nClusters = this.clusterList.size();
        for (int c = 0; c < nClusters; ++c) {
            if (c == clusterIndex) continue;
            HaplotypeCluster anotherCluster = this.clusterList.get(c);
            Iterator<Haplotype> hapit = anotherCluster.getIterator();
            while (hapit.hasNext()) {
                Haplotype anotherHaplotype = hapit.next();
                if (!thisCluster.contains(anotherHaplotype)) continue;
                hapit.remove();
            }
        }
        this.recalculateScores();
        this.sortClusters();
    }

    public void moveAllPossibleHaplotypesToCluster(int clusterIndex, boolean fromClustersWithHigherIndexOnly, int maxdiff) {
        HaplotypeCluster thisCluster = this.clusterList.get(clusterIndex);
        if (thisCluster.getSize() == 0) {
            return;
        }
        int nClusters = this.clusterList.size();
        Haplotype clusterHap = new Haplotype(thisCluster.getUnanimousHaplotype());
        int start = 0;
        if (fromClustersWithHigherIndexOnly) {
            start = clusterIndex + 1;
        }
        for (int c = start; c < nClusters; ++c) {
            HaplotypeCluster anotherCluster;
            if (c == clusterIndex || (anotherCluster = this.clusterList.get(c)).getSize() <= 0) continue;
            Iterator<Haplotype> hapit = anotherCluster.getIterator();
            while (hapit.hasNext()) {
                Haplotype anotherHaplotype = hapit.next();
                if (clusterHap.distanceFrom(anotherHaplotype) > maxdiff) continue;
                hapit.remove();
                if (thisCluster.contains(anotherHaplotype)) continue;
                thisCluster.add(anotherHaplotype);
            }
        }
    }

    public void moveAllHaplotypesToBiggestCluster(int maxdiff) {
        this.sortClusters();
        int nclusters = this.clusterList.size();
        for (int i = 0; i < nclusters; ++i) {
            this.moveAllPossibleHaplotypesToCluster(i, true, maxdiff);
        }
        Iterator<HaplotypeCluster> clusterIt = this.clusterList.iterator();
        while (clusterIt.hasNext()) {
            HaplotypeCluster thisCluster = clusterIt.next();
            if (thisCluster.getSize() != 0) continue;
            clusterIt.remove();
        }
        this.recalculateScores();
        this.sortClusters();
    }

    public void removeHeterozygousClusters(int maxHetSites) {
        Iterator<HaplotypeCluster> clusterIt = this.clusterList.iterator();
        while (clusterIt.hasNext()) {
            HaplotypeCluster thisCluster = clusterIt.next();
            if (thisCluster.countHeterozygousSites() <= maxHetSites) continue;
            clusterIt.remove();
        }
    }

    public void recalculateScores() {
        int nClusters = this.clusterList.size();
        for (HaplotypeCluster hc : this.clusterList) {
            hc.setScore(0.0);
        }
        for (Haplotype hap : this.haplotypeList) {
            ArrayList<HaplotypeCluster> clustersWithHaplotypeList = new ArrayList<HaplotypeCluster>();
            for (HaplotypeCluster hc : this.clusterList) {
                if (!hc.contains(hap)) continue;
                clustersWithHaplotypeList.add(hc);
            }
            int numberOfContainers = clustersWithHaplotypeList.size();
            double addScore = 1.0 / (double)numberOfContainers;
            for (HaplotypeCluster hc : clustersWithHaplotypeList) {
                hc.incrementScore(addScore);
            }
        }
        Iterator<HaplotypeCluster> clusterIter = this.clusterList.iterator();
        while (clusterIter.hasNext()) {
            HaplotypeCluster hc;
            hc = clusterIter.next();
            if (hc.getScore() != 0.0) continue;
            clusterIter.remove();
        }
    }

    public static enum TYPE {
        whole,
        partial;

    }
}

