/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.data.MigrateHDF5FromT4T5;
import net.maizegenetics.analysis.data.PlinkLoadPlugin;
import net.maizegenetics.analysis.data.ProjectPcsAndRunModelSelectionPlugin;
import net.maizegenetics.analysis.data.ProjectionLoadPlugin;
import net.maizegenetics.analysis.gobii.GOBIIPlugin;
import net.maizegenetics.dna.map.TOPMUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.ReadSequenceAlignmentUtils;
import net.maizegenetics.dna.snp.io.BuilderFromHapMapLIX;
import net.maizegenetics.dna.snp.io.FilterJSONUtils;
import net.maizegenetics.dna.snp.io.JSONUtils;
import net.maizegenetics.dna.snp.io.ReadNumericMarkerUtils;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.taxa.distance.DistanceMatrixUtils;
import net.maizegenetics.taxa.distance.ReadDistanceMatrix;
import net.maizegenetics.taxa.tree.NewickUtils;
import net.maizegenetics.util.HDF5TableReport;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.TableReportUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class FileLoadPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FileLoadPlugin.class);
    private PluginParameter<TasselFileType> myFileType = new PluginParameter.Builder<TasselFileType>("format", TasselFileType.Unknown, TasselFileType.class).description("Import file format").objectListSingleSelect().range((Comparable<T>[])TasselFileType.values()).build();
    private PluginParameter<Boolean> mySortPositions = new PluginParameter.Builder<Boolean>("sortPositions", false, Boolean.class).description("Whether to sort genotype positions if that's possible.").dependentOnParameter(this.myFileType, new Object[]{TasselFileType.Unknown, TasselFileType.Hapmap, TasselFileType.HapmapDiploid, TasselFileType.VCF, TasselFileType.Plink}).build();
    private PluginParameter<Boolean> myKeepDepth = new PluginParameter.Builder<Boolean>("keepDepth", true, Boolean.class).description("Whether to keep depth if that's possible.").dependentOnParameter(this.myFileType, new Object[]{TasselFileType.Unknown, TasselFileType.VCF}).build();
    private String[] myOpenFiles = null;
    private PlinkLoadPlugin myPlinkLoadPlugin = null;
    private ProjectionLoadPlugin myProjectionLoadPlugin = null;
    private ProjectPcsAndRunModelSelectionPlugin myProjectPcsAndRunModelSelectionPlugin = null;
    private GOBIIPlugin myGOBIIPlugin = null;
    private final JFileChooser myOpenFileChooser;
    private final boolean myHeadless;
    public static final String FILE_EXT_HAPMAP = ".hmp.txt";
    public static final String FILE_EXT_HAPMAP_GZ = ".hmp.txt.gz";
    public static final String FILE_EXT_HAPMAP_GZ_LIX = ".hmp.txt.gz.lix";
    public static final String FILE_EXT_PLINK_MAP = ".plk.map";
    public static final String FILE_EXT_PLINK_PED = ".plk.ped";
    public static final String FILE_EXT_SERIAL_GZ = ".serial.gz";
    public static final String FILE_EXT_HDF5 = ".h5";
    public static final String FILE_EXT_VCF = ".vcf";
    public static final String FILE_EXT_TOPM = ".topm";
    public static final String FILE_EXT_TOPM_H5 = ".topm.h5";
    public static final String FILE_EXT_TOPM_BIN = ".topm.bin";
    public static final String FILE_EXT_TOPM_TEXT = ".topm.txt";
    public static final String FILE_EXT_FASTA = ".fasta";
    public static final String FILE_EXT_PHYLIP = ".phy";
    public static final String FILE_EXT_NEWICK = ".nwk";

    public FileLoadPlugin(Frame parentFrame, boolean isInteractive, boolean headless) {
        super(parentFrame, isInteractive);
        if (isInteractive) {
            this.myOpenFileChooser = new JFileChooser(TasselPrefs.getOpenDir());
            this.myOpenFileChooser.setMultiSelectionEnabled(true);
        } else {
            this.myOpenFileChooser = null;
        }
        this.myHeadless = headless;
    }

    public FileLoadPlugin(Frame parentFrame, boolean isInteractive) {
        this(parentFrame, isInteractive, false);
    }

    public static Object runPlugin(String filename) {
        return FileLoadPlugin.runPluginDataSet(filename).getData(0).getData();
    }

    public static DataSet runPluginDataSet(String filename) {
        FileLoadPlugin flp = new FileLoadPlugin(null, false);
        flp.setTheFileType(TasselFileType.Unknown);
        flp.setOpenFiles(filename);
        return flp.performFunction(null);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        ArrayList<TasselFileType> temp = new ArrayList<TasselFileType>();
        temp.addAll(Arrays.asList(TasselFileType.Unknown, TasselFileType.Hapmap, TasselFileType.VCF, TasselFileType.Flapjack, TasselFileType.Plink, TasselFileType.ProjectionAlignment, TasselFileType.Sequence, TasselFileType.Fasta, TasselFileType.Phenotype, TasselFileType.SqrMatrix, TasselFileType.Table, TasselFileType.Newick, TasselFileType.TOPM, TasselFileType.HDF5, TasselFileType.HDF5Schema));
        this.myFileType = new PluginParameter<TasselFileType>(this.myFileType, temp);
        if (!this.isInteractive() && this.myFileType.isEmpty() && this.myFileType.hasPossibleValues()) {
            this.fileType(TasselFileType.Unknown);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataSet processData(DataSet input) {
        this.myWasCancelled = true;
        if (this.isInteractive()) {
            if (this.fileType() == TasselFileType.Plink) {
                if (this.myPlinkLoadPlugin == null) {
                    this.myPlinkLoadPlugin = new PlinkLoadPlugin(this.getParentFrame(), this.isInteractive());
                    for (PluginListener current : this.getListeners()) {
                        this.myPlinkLoadPlugin.addListener(current);
                    }
                }
                this.myPlinkLoadPlugin.sortPositions(this.sortPositions());
                return this.myPlinkLoadPlugin.performFunction(null);
            }
            if (this.fileType() == TasselFileType.ProjectionAlignment) {
                if (this.myProjectionLoadPlugin != null) return this.myProjectionLoadPlugin.performFunction(input);
                this.myProjectionLoadPlugin = new ProjectionLoadPlugin(this.getParentFrame(), this.isInteractive());
                for (PluginListener current : this.getListeners()) {
                    this.myProjectionLoadPlugin.addListener(current);
                }
                return this.myProjectionLoadPlugin.performFunction(input);
            }
            if (this.fileType() == TasselFileType.ProjectPCsandRunModelSelection) {
                if (this.myProjectPcsAndRunModelSelectionPlugin != null) return this.myProjectPcsAndRunModelSelectionPlugin.performFunction(input);
                this.myProjectPcsAndRunModelSelectionPlugin = new ProjectPcsAndRunModelSelectionPlugin(this.getParentFrame(), this.isInteractive());
                for (PluginListener current : this.getListeners()) {
                    this.myProjectPcsAndRunModelSelectionPlugin.addListener(current);
                }
                return this.myProjectPcsAndRunModelSelectionPlugin.performFunction(input);
            }
            if (this.fileType() == TasselFileType.GOBII) {
                if (this.myGOBIIPlugin != null) return this.myGOBIIPlugin.performFunction(input);
                this.myGOBIIPlugin = new GOBIIPlugin(this.getParentFrame(), this.isInteractive());
                for (PluginListener current : this.getListeners()) {
                    this.myGOBIIPlugin.addListener(current);
                }
                return this.myGOBIIPlugin.performFunction(input);
            }
            this.setOpenFiles(this.getOpenFilesByChooser());
        }
        if (this.myOpenFiles == null || this.myOpenFiles.length == 0) {
            return null;
        }
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        ArrayList<String> alreadyLoaded = new ArrayList<String>();
        for (int i = 0; i < this.myOpenFiles.length; ++i) {
            if (alreadyLoaded.contains(this.myOpenFiles[i])) continue;
            LocalDateTime time = LocalDateTime.now();
            String timeStr = time.format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
            myLogger.info((Object)("Start Loading File: " + this.myOpenFiles[i] + " time: " + timeStr));
            DataSet tds = null;
            if (this.fileType() == TasselFileType.Unknown) {
                GenotypeTable plink;
                GenotypeTable hapmap;
                if (this.myOpenFiles[i].endsWith(FILE_EXT_HAPMAP_GZ)) {
                    String theIndex = this.myOpenFiles[i].replaceFirst(FILE_EXT_HAPMAP_GZ, FILE_EXT_HAPMAP_GZ_LIX);
                    if (new File(theIndex).isFile()) {
                        myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.HapmapLIX)));
                        alreadyLoaded.add(this.myOpenFiles[i]);
                        alreadyLoaded.add(theIndex);
                        hapmap = BuilderFromHapMapLIX.build(this.myOpenFiles[i], theIndex);
                        tds = new DataSet(new Datum(Utils.getFilename(this.myOpenFiles[i], FILE_EXT_HAPMAP_GZ), hapmap, null), (Plugin)this);
                    } else {
                        myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Hapmap)));
                        alreadyLoaded.add(this.myOpenFiles[i]);
                        tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Hapmap);
                    }
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_HAPMAP_GZ_LIX)) {
                    String theHapmap = this.myOpenFiles[i].replaceFirst(FILE_EXT_HAPMAP_GZ_LIX, FILE_EXT_HAPMAP_GZ);
                    if (!new File(theHapmap).isFile()) throw new IllegalStateException("Can't find genotype file for index: " + this.myOpenFiles[i]);
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.HapmapLIX)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    alreadyLoaded.add(theHapmap);
                    hapmap = BuilderFromHapMapLIX.build(theHapmap, this.myOpenFiles[i]);
                    tds = new DataSet(new Datum(Utils.getFilename(theHapmap, FILE_EXT_HAPMAP_GZ), hapmap, null), (Plugin)this);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_HAPMAP)) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Hapmap)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Hapmap);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_TOPM_H5) || this.myOpenFiles[i].endsWith(FILE_EXT_TOPM) || this.myOpenFiles[i].endsWith(FILE_EXT_TOPM_BIN) || this.myOpenFiles[i].endsWith(FILE_EXT_TOPM_TEXT)) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.TOPM)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.TOPM);
                } else if (this.myOpenFiles[i].endsWith(".grm.N.bin") || this.myOpenFiles[i].endsWith(".grm.bin") || this.myOpenFiles[i].endsWith(".grm.id")) {
                    String[] grmFiles = DistanceMatrixUtils.getGRMFilenames(this.myOpenFiles[i]);
                    if (new File(grmFiles[0]).isFile() && new File(grmFiles[1]).isFile() && new File(grmFiles[2]).isFile()) {
                        myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.SqrMatrixBin)));
                        alreadyLoaded.add(grmFiles[0]);
                        alreadyLoaded.add(grmFiles[1]);
                        alreadyLoaded.add(grmFiles[2]);
                        tds = this.processDatum(this.myOpenFiles[i], TasselFileType.SqrMatrixBin);
                    } else if (this.myOpenFiles[i].endsWith(".grm.N.bin") && new File(grmFiles[4]).isFile() && new File(this.myOpenFiles[i]).isFile()) {
                        myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.SqrMatrix)));
                        alreadyLoaded.add(this.myOpenFiles[i]);
                        alreadyLoaded.add(grmFiles[4]);
                        tds = this.processDatum(grmFiles[4], TasselFileType.SqrMatrix);
                    }
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_PLINK_PED) || this.myOpenFiles[i].endsWith(".plk.ped.gz")) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Plink)));
                    String theMapFile = this.myOpenFiles[i].replaceFirst(FILE_EXT_PLINK_PED, FILE_EXT_PLINK_MAP);
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    alreadyLoaded.add(theMapFile);
                    plink = ImportUtils.readFromPLink(this.myOpenFiles[i], theMapFile, this, this.sortPositions());
                    tds = new DataSet(new Datum(Utils.getFilename(this.myOpenFiles[i], FILE_EXT_PLINK_PED), plink, null), (Plugin)this);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_PLINK_MAP) || this.myOpenFiles[i].endsWith(".plk.map.gz")) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Plink)));
                    String thePedFile = this.myOpenFiles[i].replaceFirst(FILE_EXT_PLINK_MAP, FILE_EXT_PLINK_PED);
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    alreadyLoaded.add(thePedFile);
                    plink = ImportUtils.readFromPLink(thePedFile, this.myOpenFiles[i], this, this.sortPositions());
                    tds = new DataSet(new Datum(Utils.getFilename(thePedFile, FILE_EXT_PLINK_PED), plink, null), (Plugin)this);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_SERIAL_GZ)) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Serial)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Serial);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_HDF5)) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.HDF5)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.HDF5);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_VCF) || this.myOpenFiles[i].endsWith(".vcf.gz")) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.VCF)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.VCF);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_PHYLIP) || this.myOpenFiles[i].endsWith(".phy.gz")) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Sequence)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Sequence);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_FASTA) || this.myOpenFiles[i].endsWith(".fasta.gz")) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Fasta)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Fasta);
                } else if (this.myOpenFiles[i].endsWith(FILE_EXT_NEWICK)) {
                    myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)TasselFileType.Newick)));
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.processDatum(this.myOpenFiles[i], TasselFileType.Newick);
                } else {
                    alreadyLoaded.add(this.myOpenFiles[i]);
                    tds = this.guessAtUnknowns(this.myOpenFiles[i]);
                }
            } else {
                alreadyLoaded.add(this.myOpenFiles[i]);
                tds = this.processDatum(this.myOpenFiles[i], this.fileType());
            }
            time = LocalDateTime.now();
            timeStr = time.format(DateTimeFormatter.ofPattern("MMM d, uuuu H:mm:s"));
            if (tds != null) {
                myLogger.info((Object)("Finished Loading File: " + this.myOpenFiles[i] + " time: " + timeStr));
                GenotypeSummaryPlugin.printSimpleSummary(tds);
                this.myWasCancelled = false;
                result.add(tds);
                if (!this.myHeadless) continue;
                this.fireDataSetReturned(new PluginEvent(tds, FileLoadPlugin.class));
                continue;
            }
            myLogger.info((Object)("Nothing Loaded for File: " + this.myOpenFiles[i] + " time: " + timeStr));
        }
        return DataSet.getDataSet(result, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSet guessAtUnknowns(String filename) {
        TasselFileType guess = TasselFileType.Table;
        try (BufferedReader br = Utils.getBufferedReader(filename);){
            block39: {
                boolean isNumeric;
                boolean isMarker;
                boolean isTrait;
                String line2;
                String line1;
                block48: {
                    String inline;
                    Pattern tagPattern;
                    block50: {
                        String line;
                        String matrixStr;
                        block44: {
                            String[] sval2;
                            String[] sval1;
                            block51: {
                                block45: {
                                    block46: {
                                        String[] info2;
                                        block49: {
                                            block47: {
                                                block42: {
                                                    block43: {
                                                        block40: {
                                                            String temp;
                                                            block41: {
                                                                line1 = br.readLine();
                                                                while (line1 != null && (line1 = line1.trim()).isEmpty()) {
                                                                    line1 = br.readLine();
                                                                }
                                                                if (line1 == null) {
                                                                    throw new IllegalArgumentException("FileLoadPlugin: guessAtUnknowns: File is empty: " + filename);
                                                                }
                                                                sval1 = line1.split("\\s");
                                                                line2 = br.readLine().trim();
                                                                sval2 = line2.split("\\s");
                                                                if (!line1.startsWith("{")) break block40;
                                                                temp = sval1.length > 1 ? sval1[1] : line2;
                                                                if (!temp.startsWith("\"TaxaList\"")) break block41;
                                                                guess = TasselFileType.TaxaList;
                                                                break block39;
                                                            }
                                                            if (temp.startsWith("\"PositionList\"")) {
                                                                guess = TasselFileType.PositionList;
                                                                break block39;
                                                            } else if (temp.startsWith("\"Filter\"")) {
                                                                guess = TasselFileType.Filter;
                                                            }
                                                            break block39;
                                                        }
                                                        if (!line1.startsWith("##")) break block42;
                                                        matrixStr = "##Matrix_Type";
                                                        if (!line1.startsWith(matrixStr) && !line2.startsWith(matrixStr)) break block43;
                                                        guess = TasselFileType.SqrMatrix;
                                                        break block39;
                                                    }
                                                    line = br.readLine();
                                                    break block44;
                                                }
                                                if (!line1.startsWith("<") && !line1.startsWith("#")) break block45;
                                                isTrait = false;
                                                isMarker = false;
                                                isNumeric = false;
                                                tagPattern = Pattern.compile("[<>\\s]+");
                                                String[] info1 = tagPattern.split(line1);
                                                info2 = tagPattern.split(line2);
                                                if (info1.length > 1) {
                                                    if (info1[1].toUpperCase().startsWith("MARKER")) {
                                                        isMarker = true;
                                                    } else if (info1[1].toUpperCase().startsWith("TRAIT")) {
                                                        isTrait = true;
                                                    } else if (info1[1].toUpperCase().startsWith("NUMER")) {
                                                        isNumeric = true;
                                                    } else if (info1[1].toUpperCase().startsWith("PHENO")) {
                                                        isTrait = true;
                                                    }
                                                }
                                                if (info2.length <= 1) break block46;
                                                if (!info2[1].toUpperCase().startsWith("MARKER")) break block47;
                                                isMarker = true;
                                                break block48;
                                            }
                                            if (!info2[1].toUpperCase().startsWith("TRAIT")) break block49;
                                            isTrait = true;
                                            break block48;
                                        }
                                        if (!info2[1].toUpperCase().startsWith("NUMER")) break block48;
                                        isNumeric = true;
                                        break block48;
                                    }
                                    guess = null;
                                    inline = br.readLine();
                                    break block50;
                                }
                                if (!line1.startsWith(">") && !line1.startsWith(";")) break block51;
                                guess = TasselFileType.Fasta;
                                break block39;
                            }
                            if (sval1.length == 1) {
                                guess = TasselFileType.SqrMatrix;
                                break block39;
                            } else if (line1.startsWith("#Nexus") || line1.startsWith("#NEXUS") || line1.startsWith("CLUSTAL") || sval1.length == 2 && sval2.length == 2) {
                                guess = TasselFileType.Sequence;
                            }
                            break block39;
                        }
                        while (line != null && line.startsWith("##")) {
                            if (line.startsWith(matrixStr)) {
                                guess = TasselFileType.SqrMatrix;
                                break block39;
                            }
                            line = br.readLine();
                        }
                        break block39;
                    }
                    while (guess == null && inline != null && (inline.startsWith("#") || inline.startsWith("<"))) {
                        if (!inline.startsWith("<")) continue;
                        String[] info = tagPattern.split(inline);
                        if (info[1].toUpperCase().startsWith("MARKER")) {
                            isMarker = true;
                            continue;
                        }
                        if (info[1].toUpperCase().startsWith("TRAIT")) {
                            isTrait = true;
                            continue;
                        }
                        if (!info[1].toUpperCase().startsWith("NUMER")) continue;
                        isNumeric = true;
                    }
                }
                if (isTrait) {
                    guess = TasselFileType.Phenotype;
                } else if (isMarker && isNumeric) {
                    guess = TasselFileType.NumericGenotype;
                } else {
                    myLogger.warn((Object)("Line1: " + line1));
                    myLogger.warn((Object)("Line2: " + line2));
                    throw new IOException("Improperly formatted header. Data will not be imported for file: " + filename);
                }
            }
            myLogger.info((Object)("guessAtUnknowns: type: " + (Object)((Object)guess)));
            DataSet dataSet = this.processDatum(filename, guess);
            return dataSet;
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("FileLoadPlugin: Problem loading file: " + filename + ".  Error: " + e.getMessage());
        }
    }

    private DataSet processDatum(String inFile, TasselFileType theFT) {
        Object result = null;
        String suffix = null;
        try {
            switch (theFT) {
                case Hapmap: {
                    suffix = FILE_EXT_HAPMAP;
                    if (inFile.endsWith(".gz")) {
                        suffix = FILE_EXT_HAPMAP_GZ;
                    }
                    result = ImportUtils.readFromHapmap(inFile, this, this.sortPositions());
                    break;
                }
                case HDF5: {
                    IHDF5Reader reader = HDF5Factory.openForReading((String)inFile);
                    boolean t4HDF5 = HDF5Utils.isTASSEL4HDF5Format(HDF5Factory.openForReading((String)inFile));
                    reader.close();
                    if (t4HDF5) {
                        String newInfile = inFile.replace(FILE_EXT_HDF5, ".t5.h5");
                        if (new File(newInfile).exists()) {
                            String message = "This file is TASSEL 4 HDF5 format. It looks like it has already been converted to TASSEL 5. Using file: " + newInfile;
                            if (this.isInteractive()) {
                                DialogUtils.showWarning(message, this.getParentFrame());
                            } else {
                                myLogger.warn((Object)message);
                            }
                        } else {
                            String message = "This file is TASSEL 4 HDF5 format. It will be converted to TASSEL 5 HDF5 format with name: " + newInfile + ".  This may take a few minutes.";
                            if (this.isInteractive()) {
                                DialogUtils.showWarning(message, this.getParentFrame());
                            } else {
                                myLogger.warn((Object)message);
                            }
                            MigrateHDF5FromT4T5.copyGenotypes(inFile, newInfile);
                        }
                        inFile = newInfile;
                    }
                    suffix = FILE_EXT_HDF5;
                    result = ImportUtils.readGuessFormat(inFile);
                    break;
                }
                case HDF5Schema: {
                    suffix = "";
                    result = new HDF5TableReport(inFile);
                    break;
                }
                case VCF: {
                    suffix = FILE_EXT_VCF;
                    if (inFile.endsWith(".gz")) {
                        suffix = ".vcf.gz";
                    }
                    result = ImportUtils.readFromVCF(inFile, this, this.keepDepth(), this.sortPositions());
                    break;
                }
                case Sequence: {
                    result = ReadSequenceAlignmentUtils.readBasicAlignments(inFile, 40);
                    break;
                }
                case Fasta: {
                    result = ImportUtils.readFasta(inFile);
                    break;
                }
                case SqrMatrix: {
                    result = ReadDistanceMatrix.readDistanceMatrix(inFile);
                    break;
                }
                case SqrMatrixBin: {
                    result = ReadDistanceMatrix.readBinMultiBlupMatrix(inFile);
                    break;
                }
                case Phenotype: {
                    List<Phenotype> phenotypes = new PhenotypeBuilder().fromFile(inFile).build();
                    if (phenotypes.size() != 1) {
                        throw new IllegalStateException("FileLoadPlugin: processDatum: problem loading phenotype file: " + inFile);
                    }
                    result = phenotypes.get(0);
                    break;
                }
                case NumericGenotype: {
                    result = ReadNumericMarkerUtils.readNumericMarkerFile(inFile);
                    break;
                }
                case TaxaList: {
                    result = JSONUtils.importTaxaListFromJSON(inFile);
                    break;
                }
                case PositionList: {
                    result = JSONUtils.importPositionListFromJSON(inFile);
                    break;
                }
                case Table: {
                    result = TableReportUtils.readDelimitedTableReport(inFile, "\t");
                    break;
                }
                case TOPM: {
                    result = TOPMUtils.readTOPM(inFile);
                    break;
                }
                case Filter: {
                    result = FilterJSONUtils.importJSONToFilter(inFile);
                    break;
                }
                case Newick: {
                    result = NewickUtils.read(inFile);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Format: " + (Object)((Object)theFT) + ".\n  Please check file format or select specific format.");
                }
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("Problem loading file: " + inFile + ".\n  Error: " + e.getMessage());
        }
        if (result != null) {
            Datum td = new Datum(Utils.getFilename(inFile, suffix), result, null);
            return new DataSet(td, (Plugin)this);
        }
        return null;
    }

    private File[] getOpenFilesByChooser() {
        File[] lopenFiles = null;
        this.myOpenFileChooser.setVisible(true);
        int returnVal = this.myOpenFileChooser.showOpenDialog(this.getParentFrame());
        if (returnVal == 0 || returnVal == 0) {
            lopenFiles = this.myOpenFileChooser.getSelectedFiles();
            TasselPrefs.putOpenDir(this.myOpenFileChooser.getCurrentDirectory().getPath());
        }
        return lopenFiles;
    }

    public String[] getOpenFiles() {
        return this.myOpenFiles;
    }

    public void setOpenFiles(File[] openFiles) {
        if (openFiles == null || openFiles.length == 0) {
            this.myOpenFiles = null;
            return;
        }
        this.myOpenFiles = new String[openFiles.length];
        for (int i = 0; i < openFiles.length; ++i) {
            this.myOpenFiles[i] = openFiles[i].getPath();
        }
    }

    public void setOpenFiles(String openFile) {
        this.myOpenFiles = openFile == null || openFile.isEmpty() ? null : new String[]{openFile};
    }

    public void setOpenFiles(String[] openFiles) {
        this.myOpenFiles = openFiles == null || openFiles.length == 0 ? null : openFiles;
    }

    public TasselFileType fileType() {
        return this.myFileType.value();
    }

    public FileLoadPlugin fileType(TasselFileType value) {
        this.myFileType = new PluginParameter<TasselFileType>(this.myFileType, value);
        return this;
    }

    public TasselFileType getTheFileType() {
        return this.fileType();
    }

    public void setTheFileType(TasselFileType theFileType) {
        this.fileType(theFileType);
    }

    public Boolean sortPositions() {
        return this.mySortPositions.value();
    }

    public FileLoadPlugin sortPositions(Boolean value) {
        this.mySortPositions = new PluginParameter<Boolean>(this.mySortPositions, value);
        return this;
    }

    public Boolean keepDepth() {
        return this.myKeepDepth.value();
    }

    public FileLoadPlugin keepDepth(Boolean value) {
        this.myKeepDepth = new PluginParameter<Boolean>(this.myKeepDepth, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FileLoadPlugin.class.getResource("/net/maizegenetics/analysis/images/LoadFile.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Open As...";
    }

    @Override
    public String getToolTipText() {
        return "Open data from filesystem.";
    }

    public static enum TasselFileType {
        SqrMatrix("Square Matrix"),
        Sequence("Sequence"),
        Unknown("Make Best Guess"),
        Fasta("Fasta"),
        Hapmap("Hapmap"),
        HapmapLIX("Hapmap LIX"),
        Plink("Plink"),
        Phenotype("Phenotype"),
        ProjectionAlignment("Projection Genotype"),
        ProjectPCsandRunModelSelection("Project PCs"),
        Phylip_Seq("Phylip (Sequential)"),
        Phylip_Inter("Phylip (Interleaved)"),
        Table("Table"),
        Serial("Serial"),
        HapmapDiploid("Hapmap Diploid"),
        Newick("Newick"),
        VCF("VCF"),
        HDF5("HDF5"),
        TOPM("TOPM"),
        HDF5Schema("HDF5 Schema"),
        Filter("Filter"),
        NumericGenotype("Numeric Genotype"),
        TaxaList("Taxa List"),
        PositionList("Position List"),
        SqrMatrixRaw("Raw MultiBLUP Matrix"),
        SqrMatrixBin("Binary MultiBLUP Matrix"),
        GOBII("GOBII"),
        Depth("Depth"),
        ReferenceProbability("Numeric Genotype"),
        Report("Report"),
        PlinkPhenotype("Plink Phenotype"),
        SqrMatrixDARwinDIS("DARwin DIS"),
        Avro("Avro"),
        Flapjack("Flapjack");

        private final String myText;

        private TasselFileType(String text) {
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }
}

