/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.distance.DistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.MultiDimensionalScalingPlugin;
import net.maizegenetics.analysis.filter.FilterSiteBuilderPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.phenotype.CorePhenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.TableReportBuilder;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class FindInversionsPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FindInversionsPlugin.class);
    private PluginParameter<WINDOW_UNIT> myWindowUnit = new PluginParameter.Builder<WINDOW_UNIT>("windowUnit", WINDOW_UNIT.Sites, WINDOW_UNIT.class).description("Window Unit").range((Comparable<T>[])WINDOW_UNIT.values()).build();
    private PluginParameter<Integer> myStepSize = new PluginParameter.Builder<Integer>("stepSize", 100, Integer.class).description("Step Size").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).build();
    private PluginParameter<Integer> myWindowSize = new PluginParameter.Builder<Integer>("windowSize", 500, Integer.class).description("Window Size").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(0))).build();
    private PluginParameter<Integer> myNumPCAs = new PluginParameter.Builder<Integer>("numPCAs", 1, Integer.class).description("").range((Range<Comparable<Integer>>)Range.atLeast((Comparable)Integer.valueOf(1))).guiName("Number of PCAs").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("outputFile", null, String.class).description("").outFile().build();
    private Map<ChrPos, List<Float>> myResults = new TreeMap<ChrPos, List<Float>>();
    private Map<ChrPos, PriorityQueue<Edge>> myResult = new TreeMap<ChrPos, PriorityQueue<Edge>>();
    PriorityQueue<Edge> myEdges = new PriorityQueue();

    public FindInversionsPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> data = input.getDataOfType(GenotypeTable.class);
        if (data.size() != 1) {
            throw new IllegalArgumentException("FindInversionsPlugin: preProcessParameters: must input 1 GenotypeTable.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        Chromosome[] chromosomes;
        Datum data = input.getDataOfType(GenotypeTable.class).get(0);
        GenotypeTable genotypeTable = (GenotypeTable)data.getData();
        DistanceMatrixPlugin distance = new DistanceMatrixPlugin(this.getParentFrame(), false);
        MultiDimensionalScalingPlugin mds = new MultiDimensionalScalingPlugin(this.getParentFrame(), false);
        mds.numberOfAxes(this.numPCAs());
        block16: for (Chromosome c : chromosomes = genotypeTable.chromosomes()) {
            FilterSiteBuilderPlugin filterChr = new FilterSiteBuilderPlugin(null, false).startChr(c).endChr(c);
            DataSet genotypeDataSet = filterChr.performFunction(input);
            GenotypeTable genotypeChr = (GenotypeTable)genotypeDataSet.getData(0).getData();
            int numSites = genotypeChr.numberOfSites();
            int start = 0;
            while (true) {
                block36: {
                    int endSite;
                    int startSite;
                    block35: {
                        block34: {
                            startSite = -1;
                            endSite = -1;
                            if (this.windowUnit() != WINDOW_UNIT.Sites) break block34;
                            if (start > numSites) continue block16;
                            startSite = start;
                            endSite = Math.min(start + this.windowSize() - 1, numSites - 1);
                            break block35;
                        }
                        if (this.windowUnit() != WINDOW_UNIT.Positions) break block35;
                        startSite = genotypeChr.siteOfPhysicalPosition(start, c);
                        endSite += start + this.windowSize();
                        if (startSite < 0 && (startSite = -(startSite + 1)) >= numSites) {
                            startSite = numSites - 1;
                        }
                        if (startSite > numSites) continue block16;
                        if ((endSite = genotypeChr.siteOfPhysicalPosition(endSite, c)) < 0 && (endSite = -endSite - 2) >= numSites) {
                            endSite = numSites - 1;
                        }
                        if (startSite > endSite) break block36;
                    }
                    FilterSiteBuilderPlugin filter = new FilterSiteBuilderPlugin(null, false).startSite(startSite).endSite(endSite);
                    DataSet filteredGenotype = filter.performFunction(genotypeDataSet);
                    DataSet distanceMatrix = distance.performFunction(filteredGenotype);
                    try {
                        myLogger.info((Object)"Starting MDS...");
                        DataSet mdsResults = mds.processData(distanceMatrix);
                        myLogger.info((Object)"Finsihed MDS...");
                        for (int i = 1; i <= this.numPCAs(); ++i) {
                            this.scoreSinglePCA((CorePhenotype)mdsResults.getDataOfType(CorePhenotype.class).get(0).getData(), new ChrPos(c, startSite, endSite, genotypeChr.chromosomalPosition(startSite), genotypeChr.chromosomalPosition(endSite), i), i);
                        }
                    }
                    catch (Exception e) {
                        myLogger.debug((Object)e.getMessage(), (Throwable)e);
                        myLogger.warn((Object)("Problem calculating MDS for window chr: " + c.getName() + " start site: " + startSite + " end site: " + endSite));
                    }
                }
                start += this.stepSize().intValue();
            }
        }
        Object[] columnHeaders = new String[]{"Chromosome", "Start Position", "End Position", "PCA Num", "Rank"};
        TableReportBuilder builder = TableReportBuilder.getInstance("Candidates", columnHeaders);
        try (BufferedWriter writer = Utils.getBufferedWriter(Utils.addSuffixIfNeeded(this.outputFile(), ".txt"));){
            writer.write("Chromosome\tStart Site\tEnd Site\tStart Postion\tEnd Position\tPCA Num\tPeak Count 1\tGap Count\tPeak Count 2\tGap Count\tNPeak Count 3\n");
            for (Map.Entry<ChrPos, List<Float>> current : this.myResults.entrySet()) {
                ChrPos chrPos = current.getKey();
                List<Float> peakNew = current.getValue();
                if (peakNew.get(0).floatValue() / peakNew.get(1).floatValue() > 1.8f && peakNew.get(2).floatValue() / peakNew.get(1).floatValue() > 1.8f && peakNew.get(2).floatValue() / peakNew.get(3).floatValue() > 1.8f && peakNew.get(4).floatValue() / peakNew.get(3).floatValue() > 1.8f) {
                    Object[] row = new Object[]{chrPos.myChr, chrPos.myStartPos, chrPos.myEndPos, chrPos.myPCANum, Float.valueOf(peakNew.get(0).floatValue() - peakNew.get(1).floatValue() + (peakNew.get(2).floatValue() - peakNew.get(1).floatValue()) + (peakNew.get(2).floatValue() - peakNew.get(3).floatValue()) + (peakNew.get(4).floatValue() - peakNew.get(3).floatValue()))};
                    builder.addElements(row);
                }
                writer.write(chrPos.myChr.getName() + "\t" + chrPos.myStartSite + "\t" + chrPos.myEndSite + "\t" + chrPos.myStartPos + "\t" + chrPos.myEndPos + "\t" + chrPos.myPCANum);
                int numBigGaps = 0;
                int numSmallRegionPeaks = 0;
                int count = 0;
                for (Float peak : current.getValue()) {
                    int resultType = count % 3;
                    if (resultType == 0 && peak.floatValue() > 20.0f) {
                        ++numBigGaps;
                    }
                    if (resultType == 2 && peak.floatValue() < 20.0f) {
                        ++numSmallRegionPeaks;
                    }
                    ++count;
                    writer.write("\t" + peak);
                }
                if (numBigGaps >= 2 && numSmallRegionPeaks >= 3) {
                    Object[] row = new Object[]{chrPos.myChr, chrPos.myStartPos, chrPos.myEndPos};
                    builder.addElements(row);
                }
                writer.write("\n");
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("Problem writing file: " + this.outputFile());
        }
        finally {
            this.myResults.clear();
        }
        return new DataSet(new Datum("Candidate Inversions", builder.build(), null), (Plugin)this);
    }

    private void scoreSinglePCA(CorePhenotype pcaResults, ChrPos chrPos, int whichPCA) {
        int rowCount = (int)pcaResults.getRowCount();
        int numBins = 98;
        float[] pcaValues = new float[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            pcaValues[i] = ((Float)pcaResults.getRow(i)[whichPCA]).floatValue();
        }
        Arrays.sort(pcaValues);
        float minValue = pcaValues[0];
        float maxValue = pcaValues[rowCount - 1];
        float range = maxValue - minValue;
        float increment = range / ((float)numBins - 1.0f);
        float step = minValue;
        int[] bins = new int[numBins];
        int count = 0;
        for (int i = 0; i < numBins - 1; ++i) {
            step += increment;
            while (count < rowCount && pcaValues[count] < step) {
                int n = i;
                bins[n] = bins[n] + 1;
                ++count;
            }
        }
        bins[numBins - 1] = rowCount - count;
        ArrayList<Float> peaksGapsWidths = new ArrayList<Float>();
        float peak1 = 0.0f;
        for (int i = 7; i <= 41; ++i) {
            peak1 += (float)bins[i];
        }
        peaksGapsWidths.add(Float.valueOf(peak1));
        float gap1 = 0.0f;
        for (int i = 30; i <= 43; ++i) {
            gap1 += (float)bins[i];
        }
        peaksGapsWidths.add(Float.valueOf(gap1));
        float peak2 = 0.0f;
        for (int i = 32; i <= 66; ++i) {
            peak2 += (float)bins[i];
        }
        peaksGapsWidths.add(Float.valueOf(peak2));
        float gap2 = 0.0f;
        for (int i = 55; i <= 68; ++i) {
            gap2 += (float)bins[i];
        }
        peaksGapsWidths.add(Float.valueOf(gap2));
        float peak3 = 0.0f;
        for (int i = 57; i <= 91; ++i) {
            peak3 += (float)bins[i];
        }
        peaksGapsWidths.add(Float.valueOf(peak3));
        this.myResults.put(chrPos, peaksGapsWidths);
    }

    private void scoreMDS(CorePhenotype pcaResults, ChrPos chrPos) {
        this.myEdges.clear();
        Cluster.clearCachedClusters();
        long rowCount = pcaResults.getRowCount();
        for (long i = 0L; i < rowCount; ++i) {
            Object[] current = pcaResults.getRow(i);
            Taxon taxon1 = (Taxon)current[0];
            float pca1x = ((Float)current[1]).floatValue();
            float pca1y = ((Float)current[2]).floatValue();
            Cluster first = Cluster.getInstance(taxon1, pca1x, pca1y);
            for (long j = i + 1L; j < rowCount; ++j) {
                Object[] next = pcaResults.getRow(j);
                Taxon taxon2 = (Taxon)next[0];
                float pca2x = ((Float)next[1]).floatValue();
                float pca2y = ((Float)next[2]).floatValue();
                Cluster second = Cluster.getInstance(taxon2, pca2x, pca2y);
                Edge edge = new Edge(first, second);
                this.myEdges.add(edge);
            }
        }
        this.reduce(3);
        for (Edge edge : this.myEdges) {
            System.out.println(edge.myCluster1 + "\t" + edge.myCluster2 + "\t" + edge.myDistance);
        }
        this.myResult.put(chrPos, new PriorityQueue<Edge>(this.myEdges));
    }

    private void reduce(int numClusters) {
        int numEdges = numClusters * (numClusters + 1) / 2 - numClusters;
        this.reduceClusters(numEdges);
    }

    private void reduceClusters(int numEdges) {
        if (this.myEdges.size() <= numEdges) {
            return;
        }
        Edge current = (Edge)this.myEdges.remove();
        Cluster cluster1 = current.myCluster1;
        Cluster cluster2 = current.myCluster2;
        Cluster newCluster = Cluster.getInstance(cluster1, cluster2);
        int weight1 = cluster1.numTaxa();
        int weight2 = cluster2.numTaxa();
        int totalWeight = weight1 + weight2;
        HashMap edges1 = new HashMap(cluster1.myEdges);
        HashMap edges2 = new HashMap(cluster2.myEdges);
        for (Map.Entry entry : edges1.entrySet()) {
            Edge firstEdge = (Edge)entry.getValue();
            Cluster same = (Cluster)entry.getKey();
            if (same == cluster2) {
                this.removeEdge(firstEdge);
                continue;
            }
            Edge secondEdge = (Edge)edges2.get(same);
            float distance = (firstEdge.myDistance * (float)weight1 + secondEdge.myDistance * (float)weight2) / (float)totalWeight;
            Edge newEdge = new Edge(newCluster, same);
            this.removeEdge(firstEdge);
            this.removeEdge(secondEdge);
            this.myEdges.add(newEdge);
        }
        this.reduceClusters(numEdges);
    }

    private void removeEdge(Edge edge) {
        edge.myCluster1.myEdges.remove(edge.myCluster2);
        edge.myCluster2.myEdges.remove(edge.myCluster1);
        this.myEdges.remove(edge);
    }

    private static float calculateDistance(float x1, float y1, float x2, float y2) {
        float xSqr = (x1 - x2) * (x1 - x2);
        float ySqr = (y1 - y2) * (y1 - y2);
        return (float)Math.sqrt(xSqr + ySqr);
    }

    public WINDOW_UNIT windowUnit() {
        return this.myWindowUnit.value();
    }

    public FindInversionsPlugin windowUnit(WINDOW_UNIT value) {
        this.myWindowUnit = new PluginParameter<WINDOW_UNIT>(this.myWindowUnit, value);
        return this;
    }

    public Integer stepSize() {
        return this.myStepSize.value();
    }

    public FindInversionsPlugin stepSize(Integer value) {
        this.myStepSize = new PluginParameter<Integer>(this.myStepSize, value);
        return this;
    }

    public Integer windowSize() {
        return this.myWindowSize.value();
    }

    public FindInversionsPlugin windowSize(Integer value) {
        this.myWindowSize = new PluginParameter<Integer>(this.myWindowSize, value);
        return this;
    }

    public Integer numPCAs() {
        return this.myNumPCAs.value();
    }

    public FindInversionsPlugin numPCAs(Integer value) {
        this.myNumPCAs = new PluginParameter<Integer>(this.myNumPCAs, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public FindInversionsPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    @Override
    public String getToolTipText() {
        return "Find Inversions";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FindInversionsPlugin.class.getResource("/net/maizegenetics/analysis/images/inversion.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Find Inversions";
    }

    @Override
    public String getCitation() {
        return "Mei W, Casstevens T. (May 2016) Third TASSEL Hackathon.";
    }

    private class ChrPos
    implements Comparable<ChrPos> {
        private final Chromosome myChr;
        private final int myStartSite;
        private final int myEndSite;
        private final int myStartPos;
        private final int myEndPos;
        private final int myPCANum;

        public ChrPos(Chromosome chr, int startSite, int endSite, int startPos, int endPos, int pcaNum) {
            this.myChr = chr;
            this.myStartSite = startSite;
            this.myEndSite = endSite;
            this.myStartPos = startPos;
            this.myEndPos = endPos;
            this.myPCANum = pcaNum;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChrPos)) {
                return false;
            }
            ChrPos other = (ChrPos)obj;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.myChr);
            hash = 97 * hash + this.myStartPos;
            hash = 97 * hash + this.myPCANum;
            return hash;
        }

        @Override
        public int compareTo(ChrPos o) {
            if (this.myChr.getChromosomeNumber() < o.myChr.getChromosomeNumber()) {
                return -1;
            }
            if (this.myChr.getChromosomeNumber() > o.myChr.getChromosomeNumber()) {
                return 1;
            }
            if (this.myStartPos < o.myStartPos) {
                return -1;
            }
            if (this.myStartPos > o.myStartPos) {
                return 1;
            }
            if (this.myPCANum < o.myPCANum) {
                return -1;
            }
            if (this.myPCANum > o.myPCANum) {
                return 1;
            }
            return 0;
        }
    }

    private static class Edge
    implements Comparable<Edge> {
        private final Cluster myCluster1;
        private final Cluster myCluster2;
        private final float myDistance;

        public Edge(Cluster cluster1, Cluster cluster2) {
            this.myCluster1 = cluster1;
            this.myCluster2 = cluster2;
            this.myDistance = FindInversionsPlugin.calculateDistance(cluster1.myX, cluster1.myY, cluster2.myX, cluster2.myY);
            this.myCluster1.addEdge(this);
            this.myCluster2.addEdge(this);
        }

        @Override
        public int compareTo(Edge o) {
            if (this.myDistance < o.myDistance) {
                return -1;
            }
            if (this.myDistance > o.myDistance) {
                return 1;
            }
            return 0;
        }
    }

    private static class Cluster {
        private static Map<Taxon, Cluster> myInstances = new HashMap<Taxon, Cluster>();
        private final List<Taxon> myList = new ArrayList<Taxon>();
        private final Map<Cluster, Edge> myEdges = new HashMap<Cluster, Edge>();
        private final float myX;
        private final float myY;

        private Cluster(Taxon taxon, float x, float y) {
            this.myList.add(taxon);
            this.myX = x;
            this.myY = y;
        }

        private Cluster(List<Taxon> taxa, float x, float y) {
            this.myList.addAll(taxa);
            this.myX = x;
            this.myY = y;
        }

        public static Cluster getInstance(Taxon taxon, float x, float y) {
            Cluster result = myInstances.get(taxon);
            if (result == null) {
                result = new Cluster(taxon, x, y);
                myInstances.put(taxon, result);
            }
            return result;
        }

        public static Cluster getInstance(Cluster cluster1, Cluster cluster2) {
            ArrayList<Taxon> result = new ArrayList<Taxon>();
            result.addAll(cluster1.myList);
            result.addAll(cluster2.myList);
            float weight1 = cluster1.numTaxa();
            float weight2 = cluster2.numTaxa();
            float totalWeight = weight1 + weight2;
            return new Cluster(result, (cluster1.myX * weight1 + cluster2.myX * weight2) / totalWeight, (cluster1.myY * weight1 + cluster2.myY * weight2) / totalWeight);
        }

        public int numTaxa() {
            return this.myList.size();
        }

        public void addEdge(Edge edge) {
            if (edge.myCluster1 != this) {
                this.myEdges.put(edge.myCluster1, edge);
            } else {
                this.myEdges.put(edge.myCluster2, edge);
            }
        }

        public static void clearCachedClusters() {
            myInstances.clear();
        }

        public String toString() {
            return "Cluster{myList=" + this.myList + '}';
        }
    }

    public static enum WINDOW_UNIT {
        Sites,
        Positions;

    }
}

