/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GenomeAnnosDBQueryToPositionListPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GenomeAnnosDBQueryToPositionListPlugin.class);
    private static String errorMessage;
    private PluginParameter<String> connConfigFile = new PluginParameter.Builder<String>("cf", null, String.class).required(true).inFile().guiName("DB config file").description("DB connection config file").build();
    private PluginParameter<String> queryFile = new PluginParameter.Builder<String>("qf", null, String.class).required(false).inFile().guiName("Query file").description("Query file").build();

    public GenomeAnnosDBQueryToPositionListPlugin() {
        super(null, false);
    }

    public GenomeAnnosDBQueryToPositionListPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        try {
            DataSet output;
            String name;
            String query;
            block10: {
                System.out.println("test");
                try {
                    name = query = (String)input.getData(0).getData();
                }
                catch (NullPointerException e) {
                    query = this.readQueryFromFile();
                    name = Utils.getFilename(this.queryFile());
                    if (query != null) break block10;
                    this.complain("\nA problem occurred while reading the query file\n");
                    DataSet dataSet = null;
                    this.fireProgress(100);
                    return dataSet;
                }
            }
            Connection conn = GenomeAnnosDBQueryToPositionListPlugin.connectToDB(this.connConfigFile());
            if (conn == null) {
                this.complain("\nCould not connect to DB\n");
                DataSet dataSet = null;
                return dataSet;
            }
            PositionList posits = this.getPositionListBasedOnQuery(conn, query);
            if (posits == null) {
                this.complain("\nA problem occurred while executing the query and retreiving a PositionList\n");
                DataSet dataSet = null;
                return dataSet;
            }
            Datum outputDatum = new Datum(name + "_PositionList", posits, "Position List from " + name);
            DataSet dataSet = output = new DataSet(outputDatum, (Plugin)this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private void complain(String altErrorMsg) {
        if (errorMessage == null) {
            errorMessage = altErrorMsg;
        }
        if (!this.isInteractive()) {
            throw new IllegalStateException();
        }
        JOptionPane.showMessageDialog(this.getParentFrame(), errorMessage);
    }

    private String readQueryFromFile() {
        BufferedReader reader = Utils.getBufferedReader(this.queryFile());
        String query = reader.lines().collect(Collectors.joining("\n"));
        myLogger.info((Object)("\n\nExecuting query:\n" + query + "\n\n"));
        return GenomeAnnosDBQueryToPositionListPlugin.checkQuery(query);
    }

    public static String checkQuery(String query) {
        String goodQuery = query.trim();
        if (!goodQuery.toUpperCase().startsWith("SELECT ")) {
            errorMessage = "\nThe supplied query must begin with \"SELECT \" (case insensitive)\n";
            myLogger.error((Object)errorMessage);
            return null;
        }
        if (!goodQuery.toLowerCase().contains("chr")) {
            errorMessage = "\nThe supplied query must contain a output column labelled \"chr\" (lower case)\n";
            myLogger.error((Object)errorMessage);
            return null;
        }
        if (!goodQuery.toLowerCase().contains("position")) {
            errorMessage = "\nThe supplied query must contain a output column labelled \"position\" (lower case)\n";
            myLogger.error((Object)errorMessage);
            return null;
        }
        if (goodQuery.toUpperCase().matches(GenomeAnnosDBQueryToPositionListPlugin.getBadWordsRegex())) {
            errorMessage = GenomeAnnosDBQueryToPositionListPlugin.getBadWordsErrorMessage();
            myLogger.error((Object)errorMessage);
            return null;
        }
        return goodQuery;
    }

    private static ArrayList<String> getBadWordsArrayList() {
        ArrayList<String> badWords = new ArrayList<String>();
        badWords.add("ALTER");
        badWords.add("COPY");
        badWords.add("CREATE");
        badWords.add("DELETE");
        badWords.add("DROP");
        badWords.add("INSERT");
        badWords.add("TRUNCATE");
        badWords.add("UPDATE");
        return badWords;
    }

    private static String getBadWordsRegex() {
        StringBuilder badWordsRegex = new StringBuilder(".*\\s(");
        badWordsRegex.append(GenomeAnnosDBQueryToPositionListPlugin.getBadWordsArrayList().stream().collect(Collectors.joining("|")));
        badWordsRegex.append(")\\s.*");
        return badWordsRegex.toString();
    }

    private static String getBadWordsErrorMessage() {
        StringBuilder badWordsErrMsg = new StringBuilder("Your query should not contain any of the following bare words (case insensitive):\n   ");
        badWordsErrMsg.append(GenomeAnnosDBQueryToPositionListPlugin.getBadWordsArrayList().stream().collect(Collectors.joining("\n   ")));
        badWordsErrMsg.append("\n");
        return badWordsErrMsg.toString();
    }

    public static Connection connectToDB(String configFile) {
        Properties props = new Properties();
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(configFile));
            props.load(inputStream);
        }
        catch (IOException e) {
            errorMessage = "Problem reading DB connection config file (" + configFile + "):\n\t" + e;
            myLogger.error((Object)errorMessage);
            return null;
        }
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String dbName = props.getProperty("DB");
        if (user == null) {
            errorMessage = "ERROR: Please provide a line with the user name (user=<userName>) in the DB connection config file (" + configFile + ")";
            myLogger.error((Object)errorMessage);
            return null;
        }
        if (password == null) {
            errorMessage = "ERROR: Please provide a line with the password (password=<yourPassword>) in the DB connection config file (" + configFile + ")";
            myLogger.error((Object)errorMessage);
            return null;
        }
        if (dbName == null) {
            errorMessage = "ERROR: Please provide a line with the DB name (DB=<dbName>) in the DB connection config file (" + configFile + ")";
            myLogger.error((Object)errorMessage);
            return null;
        }
        return GenomeAnnosDBQueryToPositionListPlugin.connectToDatabaseOrDie(dbName, props);
    }

    private static Connection connectToDatabaseOrDie(String dbName, Properties props) {
        Connection conn = null;
        String url = "not connected yet";
        String host = props.getProperty("host");
        try {
            Class.forName("org.postgresql.Driver");
            url = host == null ? "jdbc:postgresql://localhost/" + dbName : "jdbc:postgresql://" + host + "/" + dbName;
            conn = DriverManager.getConnection(url, props);
        }
        catch (ClassNotFoundException e) {
            errorMessage = e.getMessage();
            myLogger.error((Object)errorMessage);
            return null;
        }
        catch (SQLException e) {
            errorMessage = e.getMessage();
            myLogger.error((Object)errorMessage);
            return null;
        }
        myLogger.info((Object)("\nUsing DB:  " + url + "\n"));
        return conn;
    }

    private PositionList getPositionListBasedOnQuery(Connection conn, String query) {
        PositionListBuilder plb = new PositionListBuilder();
        ResultSet rs = this.executePostgreSQLQuery(conn, query);
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            String[] field = new String[rsmd.getColumnCount() + 1];
            int[] type = new int[rsmd.getColumnCount() + 1];
            for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                field[col] = rsmd.getColumnLabel(col);
                type[col] = rsmd.getColumnType(col);
            }
            while (rs.next()) {
                GeneralPosition.Builder glb = new GeneralPosition.Builder(new Chromosome(rs.getString("chr")), rs.getInt("position"));
                for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
                    if (field[col].equals("chr") || field[col].equals("position")) continue;
                    if (type[col] == 7 || type[col] == 6) {
                        glb.addAnno(field[col], Float.valueOf(rs.getFloat(col)));
                        continue;
                    }
                    if (type[col] == 8) {
                        glb.addAnno(field[col], rs.getDouble(col));
                        continue;
                    }
                    glb.addAnno(field[col], rs.getString(col));
                }
                plb.add(glb.build());
            }
            rs.close();
        }
        catch (SQLException se) {
            errorMessage = se.getMessage();
            myLogger.error((Object)("\n" + errorMessage + "\n"));
            return null;
        }
        return plb.build();
    }

    private ResultSet executePostgreSQLQuery(Connection conn, String query) {
        try {
            return conn.createStatement().executeQuery(query);
        }
        catch (SQLException e) {
            errorMessage = "\n\nProblem executing query (" + query + "):\n\t" + e;
            myLogger.error((Object)errorMessage);
            return null;
        }
    }

    @Override
    public String getToolTipText() {
        return "Get a PositionList from a query of a genome annotations DB";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = GenomeAnnosDBQueryToPositionListPlugin.class.getResource("/net/maizegenetics/analysis/images/lists.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Get a PositionList from a query of a genome annotations DB";
    }

    public PositionList runPlugin(DataSet input) {
        return (PositionList)this.performFunction(input).getData(0).getData();
    }

    public String connConfigFile() {
        return this.connConfigFile.value();
    }

    public GenomeAnnosDBQueryToPositionListPlugin connConfigFile(String value) {
        this.connConfigFile = new PluginParameter<String>(this.connConfigFile, value);
        return this;
    }

    public String queryFile() {
        return this.queryFile.value();
    }

    public GenomeAnnosDBQueryToPositionListPlugin queryFile(String value) {
        this.queryFile = new PluginParameter<String>(this.queryFile, value);
        return this;
    }
}

