/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GenosToABHPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GenosToABHPlugin.class);
    private ArrayList<Integer> parentAIndices = null;
    private ArrayList<Integer> parentBIndices = null;
    private PluginParameter<String> outfile = new PluginParameter.Builder<String>("o", null, String.class).required(true).outFile().guiName("Output file").description("Output genotype file").build();
    private PluginParameter<String> parentA = new PluginParameter.Builder<String>("parentA", null, String.class).required(true).guiName("Parent A").inFile().description("The full name of file containing list of taxa names for parent A").build();
    private PluginParameter<String> parentB = new PluginParameter.Builder<String>("parentB", null, String.class).required(true).guiName("Parent B").inFile().description("The full name of file containing list of taxa names for parent B").build();
    private PluginParameter<OUTPUT_CHECK> outputFormat = new PluginParameter.Builder<OUTPUT_CHECK>("outputFormat", OUTPUT_CHECK.c, OUTPUT_CHECK.class).required(false).guiName("Output Format").description("Enter \"c\" for A,H,B to code for parent A, het, and parent B; Enter \"i\" for 0, 1, 2 to code for parent A, het, and parent B; Enter \"r\" for 0, 0.5, 1 to code for parent A, het, and parent B").range((Comparable<T>[])OUTPUT_CHECK.values()).build();
    private GenotypeTable myInput = null;

    public GenosToABHPlugin() {
        super(null, false);
    }

    public GenosToABHPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null) {
            throw new IllegalArgumentException("GenosToABHPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        List<Datum> genotypeTables = input.getDataOfType(GenotypeTable.class);
        if (genotypeTables.size() != 1) {
            throw new IllegalArgumentException("GenosToABHPlugin: preProcessParameters: Please select one Genotype Table.");
        }
        this.myInput = (GenotypeTable)genotypeTables.get(0).getData();
    }

    @Override
    public DataSet processData(DataSet input) {
        this.parentAIndices = this.getParentIndex(this.myInput, this.parentA());
        this.parentBIndices = this.getParentIndex(this.myInput, this.parentB());
        if (this.parentAIndices == null || this.parentAIndices.size() == 0 || this.parentBIndices == null || this.parentBIndices.size() == 0) {
            return null;
        }
        byte[] parentAGenos = new byte[this.myInput.numberOfSites()];
        byte[] parentBGenos = new byte[this.myInput.numberOfSites()];
        byte[][] hets = new byte[2][this.myInput.numberOfSites()];
        this.createParentalByteGenos(this.myInput, parentAGenos, parentBGenos, hets);
        myLogger.info((Object)String.format("GenosToABHPlugin: number Of sites:%d  number of taxa:%d %n", this.myInput.numberOfSites(), this.myInput.numberOfTaxa()));
        this.writeConvertedGenos(this.myInput, parentAGenos, parentBGenos, hets);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<Integer> getParentIndex(GenotypeTable genos, String parentFile) {
        try (BufferedReader reader = Utils.getBufferedReader(parentFile);){
            String line;
            ArrayList<String> parentNames = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                parentNames.add(line);
            }
            if (parentNames.size() > 0) {
                ArrayList<Integer> parentIndices = new ArrayList<Integer>();
                Object object = parentNames.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        System.out.println("File " + parentFile + " has " + parentIndices.size() + " elements");
                        object = parentIndices;
                        return object;
                    }
                    String parent = (String)object.next();
                    int index = genos.taxa().indexOf(parent);
                    if (index < 0) {
                        myLogger.error((Object)("Parent " + parent + " missing from the genotype file"));
                        ArrayList<Integer> arrayList = null;
                        return arrayList;
                    }
                    parentIndices.add(index);
                }
            }
            myLogger.error((Object)("No parent names found in file:  " + parentFile));
            return null;
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return null;
    }

    public void createParentalByteGenos(GenotypeTable genos, byte[] parentAGenos, byte[] parentBGenos, byte[][] hets) {
        int numAccepted = 0;
        int numRejected = 0;
        for (int site = 0; site < genos.numberOfSites(); ++site) {
            byte parentBGeno;
            StringBuilder strB = new StringBuilder(genos.siteName(site));
            byte parentAGeno = this.getParentalGenotype(genos, this.parentAIndices, site);
            if (parentAGeno == (parentBGeno = this.getParentalGenotype(genos, this.parentBIndices, site)) || parentAGeno == -1 || parentBGeno == -1 || GenotypeTableUtils.isHeterozygous(parentAGeno) || GenotypeTableUtils.isHeterozygous(parentBGeno)) {
                parentAGenos[site] = -1;
                ++numRejected;
                strB.append("\treject");
            } else {
                parentAGenos[site] = parentAGeno;
                parentBGenos[site] = parentBGeno;
                hets[0][site] = GenotypeTableUtils.getDiploidValuePhased(parentAGeno, parentBGeno);
                hets[1][site] = GenotypeTableUtils.getDiploidValuePhased(parentBGeno, parentAGeno);
                strB.append("\taccept");
                ++numAccepted;
            }
            strB.append("\t" + NucleotideAlignmentConstants.getNucleotideIUPAC(parentAGeno) + ":");
            for (Integer parentAIdx : this.parentAIndices) {
                strB.append(genos.genotypeAsString((int)parentAIdx, site));
            }
            strB.append("\t" + NucleotideAlignmentConstants.getNucleotideIUPAC(parentBGeno) + ":");
            for (Integer parentBIdx : this.parentBIndices) {
                strB.append(genos.genotypeAsString((int)parentBIdx, site));
            }
            myLogger.info((Object)strB.toString());
        }
        myLogger.info((Object)("Number of accepted sites: " + numAccepted + ", number of Rejected sites: " + numRejected));
    }

    public byte getParentalGenotype(GenotypeTable genos, ArrayList<Integer> parentIndices, int site) {
        boolean finalIsUnknown = false;
        byte finalParent = genos.genotype(parentIndices.get(0), site);
        if (finalParent == -1) {
            finalIsUnknown = true;
        }
        for (int idx = 1; idx < parentIndices.size(); ++idx) {
            byte nextGeno = genos.genotype(parentIndices.get(idx), site);
            if (nextGeno == finalParent) continue;
            if (finalIsUnknown) {
                finalParent = nextGeno;
                finalIsUnknown = false;
                continue;
            }
            if (nextGeno == -1) continue;
            finalParent = -1;
            return finalParent;
        }
        return finalParent;
    }

    private void writeConvertedGenos(GenotypeTable genos, byte[] parentAGenos, byte[] parentBGenos, byte[][] hets) {
        try (BufferedWriter bw = Utils.getBufferedWriter(this.outfile());){
            int site;
            StringBuilder strB = new StringBuilder("id");
            for (site = 0; site < genos.numberOfSites(); ++site) {
                if (parentAGenos[site] == -1) continue;
                strB.append("," + genos.siteName(site));
            }
            this.writeLine(strB, bw);
            strB = new StringBuilder("NA");
            for (site = 0; site < genos.numberOfSites(); ++site) {
                if (parentAGenos[site] == -1) continue;
                strB.append("," + genos.chromosomeName(site));
            }
            this.writeLine(strB, bw);
            for (int taxon = 0; taxon < genos.numberOfTaxa(); ++taxon) {
                if (this.parentAIndices.contains(taxon) || this.parentBIndices.contains(taxon)) continue;
                strB = new StringBuilder(genos.taxaName(taxon));
                for (int site2 = 0; site2 < genos.numberOfSites(); ++site2) {
                    if (parentAGenos[site2] == -1) continue;
                    byte geno = genos.genotype(taxon, site2);
                    if (this.outputFormat.value() == OUTPUT_CHECK.c || this.outputFormat == null) {
                        if (geno == parentAGenos[site2]) {
                            strB.append(",A");
                            continue;
                        }
                        if (geno == parentBGenos[site2]) {
                            strB.append(",B");
                            continue;
                        }
                        if (geno == hets[0][site2] || geno == hets[1][site2]) {
                            strB.append(",H");
                            continue;
                        }
                        strB.append(",NA");
                        continue;
                    }
                    if (this.outputFormat.value() == OUTPUT_CHECK.i) {
                        if (geno == parentAGenos[site2]) {
                            strB.append(",0");
                            continue;
                        }
                        if (geno == parentBGenos[site2]) {
                            strB.append(",2");
                            continue;
                        }
                        if (geno == hets[0][site2] || geno == hets[1][site2]) {
                            strB.append(",1");
                            continue;
                        }
                        strB.append(",NA");
                        continue;
                    }
                    if (this.outputFormat.value() != OUTPUT_CHECK.r) continue;
                    if (geno == parentAGenos[site2]) {
                        strB.append(",0");
                        continue;
                    }
                    if (geno == parentBGenos[site2]) {
                        strB.append(",1");
                        continue;
                    }
                    if (geno == hets[0][site2] || geno == hets[1][site2]) {
                        strB.append(",0.5");
                        continue;
                    }
                    strB.append(",NA");
                }
                this.writeLine(strB, bw);
            }
        }
        catch (IOException e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("GenosToABHPlugin: writeConvertedGenos: Problem writing file: " + this.outfile() + ": " + e.getMessage());
        }
    }

    private void writeLine(StringBuilder strB, BufferedWriter writer) {
        try {
            writer.write(strB.toString() + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getToolTipText() {
        return "Convert Genotypes to A/B/H";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = GenosToABHPlugin.class.getResource("/net/maizegenetics/analysis/images/homozygous.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "ABH Genotype";
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public String outfile() {
        return this.outfile.value();
    }

    public GenosToABHPlugin outfile(String value) {
        this.outfile = new PluginParameter<String>(this.outfile, value);
        return this;
    }

    public String parentA() {
        return this.parentA.value();
    }

    public GenosToABHPlugin parentA(String value) {
        this.parentA = new PluginParameter<String>(this.parentA, value);
        return this;
    }

    public String parentB() {
        return this.parentB.value();
    }

    public GenosToABHPlugin parentB(String value) {
        this.parentB = new PluginParameter<String>(this.parentB, value);
        return this;
    }

    public OUTPUT_CHECK outputFormat() {
        return this.outputFormat.value();
    }

    public GenosToABHPlugin outputFormat(OUTPUT_CHECK value) {
        this.outputFormat = new PluginParameter<OUTPUT_CHECK>(this.outputFormat, value);
        return this;
    }

    @Override
    public String getCitation() {
        return "Stefan Reuscher, Jeff Glaubitz, Lynn Johnson (2015) First Annual TASSEL Hackathon";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/GenosToABH/GenosToABHPlugin";
    }

    public static enum OUTPUT_CHECK {
        c,
        i,
        r;

    }
}

