/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import org.apache.log4j.Logger;

public class HetsToUnknownPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(HetsToUnknownPlugin.class);

    public HetsToUnknownPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() != 1) {
                String gpMessage = "Invalid selection.  Please select one genotype alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), gpMessage);
                } else {
                    myLogger.error((Object)gpMessage);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum current = alignInList.get(0);
            GenotypeTable genotypeTable = (GenotypeTable)current.getData();
            String name = current.getName();
            Datum outputDatum = new Datum(name + "_Homozygous", GenotypeTableBuilder.getHomozygousInstance(genotypeTable), "Homozygous " + name);
            DataSet output = new DataSet(outputDatum, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, HetsToUnknownPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public String getToolTipText() {
        return "Change Heterozygous to Unknown";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = HetsToUnknownPlugin.class.getResource("/net/maizegenetics/analysis/images/homozygous.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Homozygous Genotype";
    }
}

