/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.data.MergeGenotypeTablesPlugin;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.MergedGenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.GeneralAnnotation;
import org.apache.log4j.Logger;

public class MergeGenotypeTablesPluginV2
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeGenotypeTablesPlugin.class);
    private PluginParameter<MERGE_TYPES> taxaMergeSelection = new PluginParameter.Builder<MERGE_TYPES>("taxaMerge", MERGE_TYPES.Intersect, MERGE_TYPES.class).description("Selection for Taxa Merge Rule").guiName("Taxa Merge Rule").build();
    private PluginParameter<MERGE_TYPES> positionMergeSelection = new PluginParameter.Builder<MERGE_TYPES>("posMerge", MERGE_TYPES.Intersect, MERGE_TYPES.class).description("Selection for Position Merge Rule").guiName("Position Merge Rule").build();
    private PluginParameter<CALL_MERGE> callMergeSelection = new PluginParameter.Builder<CALL_MERGE>("callMerge", CALL_MERGE.Depth, CALL_MERGE.class).description("Selection for Call Merging").guiName("Call Merge Rule").build();
    private PluginParameter<DEPTH_MERGE> depthMergeSelection = new PluginParameter.Builder<DEPTH_MERGE>("depthMerge", DEPTH_MERGE.Additive, DEPTH_MERGE.class).description("Selection for How to Merge Depths").guiName("Depth Merge Rule").build();

    public MergeGenotypeTablesPluginV2(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        List<Datum> inputs = input.getDataOfType(GenotypeTable.class);
        if (inputs == null || inputs.size() < 2) {
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Must select at least two alignments.");
            } else {
                myLogger.warn((Object)"performFunction: Must select at least two alignments.");
            }
            return null;
        }
        try {
            GenotypeTable[] alignments = new GenotypeTable[inputs.size()];
            for (int i = 0; i < inputs.size(); ++i) {
                alignments[i] = (GenotypeTable)inputs.get(i).getData();
            }
            GenotypeTable merged = this.mergeGenotypeTables(alignments);
            DataSet result = new DataSet(new Datum("Merged Genotype Table", merged, null), (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(result, MergeGenotypeTablesPlugin.class));
            DataSet dataSet = result;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private GenotypeTable mergeGenotypeTables(GenotypeTable[] genotypeTables) {
        BiFunction<List, List, List> taxaMergeRule = this.getMergeLambda(this.taxaMergeSelection());
        BiFunction<List, List, List> posMergeRule = this.getMergeLambda(this.positionMergeSelection());
        return MergedGenotypeTable.getInstance(genotypeTables, taxaMergeRule, posMergeRule);
    }

    public Taxon mergeTaxon(Taxon a, Taxon b) {
        GeneralAnnotation gaA = a.getAnnotation();
        GeneralAnnotation gaB = b.getAnnotation();
        Taxon.Builder tb = new Taxon.Builder(a.getName());
        Set<String> masterKeySet = gaA.getAnnotationKeys();
        masterKeySet.addAll(gaB.getAnnotationKeys());
        for (String key : masterKeySet) {
            String[] masterEntries;
            String[] taxaAEntries = gaA.getTextAnnotation(key);
            String[] taxaBEntries = gaB.getTextAnnotation(key);
            HashSet<String> entrySet = new HashSet<String>();
            for (String entryA : taxaAEntries) {
                entrySet.add(entryA);
            }
            for (String entryB : taxaBEntries) {
                entrySet.add(entryB);
            }
            for (String entry : masterEntries = entrySet.toArray(new String[0])) {
                tb.addAnno(key, entry);
            }
        }
        return tb.build();
    }

    public Position mergePosition(Position a, Position b) {
        System.out.println("Merging Position");
        GeneralPosition.Builder mergedBuilder = new GeneralPosition.Builder(a.getChromosome(), a.getPosition());
        mergedBuilder.snpName(a.getSNPID());
        mergedBuilder.insertionPosition(a.getInsertionPosition());
        mergedBuilder.strand(a.getStrand());
        mergedBuilder.maf(a.getGlobalMAF());
        mergedBuilder.siteCoverage(a.getGlobalSiteCoverage());
        for (WHICH_ALLELE alleleType : WHICH_ALLELE.values()) {
            mergedBuilder.allele(alleleType, a.getAllele(alleleType));
        }
        mergedBuilder.nucleotide(a.isNucleotide());
        mergedBuilder.indel(a.isIndel());
        GeneralAnnotation gaA = a.getAnnotation();
        GeneralAnnotation gaB = b.getAnnotation();
        Set<String> masterKeySet = gaA.getAnnotationKeys();
        masterKeySet.addAll(gaB.getAnnotationKeys());
        for (String key : masterKeySet) {
            String[] masterEntries;
            String[] posAEntries = gaA.getTextAnnotation(key);
            String[] posBEntries = gaB.getTextAnnotation(key);
            HashSet<String> entrySet = new HashSet<String>();
            for (String entryA : posAEntries) {
                entrySet.add(entryA);
            }
            for (String entryB : posBEntries) {
                entrySet.add(entryB);
            }
            for (String entry : masterEntries = entrySet.toArray(new String[0])) {
                mergedBuilder.addAnno(key, entry);
            }
        }
        return mergedBuilder.build();
    }

    private BiFunction<List, List, List> getMergeLambda(MERGE_TYPES mergeType) {
        BiFunction<List, List, List> intersectFunction = (a, b) -> {
            if (a instanceof TaxaList && b instanceof TaxaList) {
                TaxaListBuilder tlb = new TaxaListBuilder();
                for (Taxon taxaA : (TaxaList)a) {
                    int bIndex = -1;
                    bIndex = ((TaxaList)b).indexOf(taxaA);
                    if (bIndex == -1) continue;
                    tlb.add(this.mergeTaxon(taxaA, (Taxon)((TaxaList)b).get(bIndex)));
                }
                return tlb.build();
            }
            if (a instanceof PositionList && b instanceof PositionList) {
                PositionListBuilder plb = new PositionListBuilder();
                for (Position posA : (PositionList)a) {
                    int bIndex = -1;
                    bIndex = ((PositionList)b).indexOf(posA);
                    if (bIndex == -1) continue;
                    plb.add(this.mergePosition(posA, (Position)((PositionList)b).get(bIndex)));
                }
                System.out.println("Size of Pos " + plb.size());
                return plb.build();
            }
            ArrayList listBuilder = new ArrayList();
            for (Object objA : a) {
                if (!b.contains(objA)) continue;
                listBuilder.add(objA);
            }
            return listBuilder;
        };
        BiFunction<List, List, List> leftJoinFunction = (a, b) -> {
            if (a instanceof TaxaList && b instanceof TaxaList) {
                TaxaListBuilder tlb = new TaxaListBuilder();
                for (Taxon taxaA : (TaxaList)a) {
                    int bIndex = -1;
                    bIndex = ((TaxaList)b).indexOf(taxaA);
                    if (bIndex != -1) {
                        tlb.add(this.mergeTaxon(taxaA, (Taxon)((TaxaList)b).get(bIndex)));
                        continue;
                    }
                    tlb.add(taxaA);
                }
                return tlb.build();
            }
            if (a instanceof PositionList && b instanceof PositionList) {
                PositionListBuilder plb = new PositionListBuilder();
                for (Position posA : (PositionList)a) {
                    int bIndex = -1;
                    bIndex = ((PositionList)b).indexOf(posA);
                    if (bIndex != -1) {
                        plb.add(this.mergePosition(posA, (Position)((PositionList)b).get(bIndex)));
                        continue;
                    }
                    plb.add(posA);
                }
                return plb.build();
            }
            ArrayList listBuilder = new ArrayList();
            for (Object objA : a) {
                if (b.contains(objA)) {
                    listBuilder.add(objA);
                    continue;
                }
                listBuilder.add(objA);
            }
            return listBuilder;
        };
        BiFunction<List, List, List> rightJoinFunction = (a, b) -> {
            if (a instanceof TaxaList && b instanceof TaxaList) {
                TaxaListBuilder tlb = new TaxaListBuilder();
                for (Taxon taxaB : (TaxaList)b) {
                    int aIndex = -1;
                    aIndex = ((TaxaList)a).indexOf(taxaB);
                    if (aIndex != -1) {
                        tlb.add(this.mergeTaxon(taxaB, (Taxon)((TaxaList)a).get(aIndex)));
                        continue;
                    }
                    tlb.add(taxaB);
                }
                return tlb.build();
            }
            if (a instanceof PositionList && b instanceof PositionList) {
                PositionListBuilder plb = new PositionListBuilder();
                for (Position posB : (PositionList)b) {
                    int aIndex = -1;
                    aIndex = ((PositionList)a).indexOf(posB);
                    if (aIndex != -1) {
                        plb.add(this.mergePosition(posB, (Position)((PositionList)a).get(aIndex)));
                        continue;
                    }
                    plb.add(posB);
                }
                return plb.build();
            }
            ArrayList listBuilder = new ArrayList();
            for (Object objB : b) {
                if (b.contains(objB)) {
                    listBuilder.add(objB);
                    continue;
                }
                listBuilder.add(objB);
            }
            return listBuilder;
        };
        BiFunction<List, List, List> unionFunction = (a, b) -> {
            if (a instanceof TaxaList && b instanceof TaxaList) {
                TaxaListBuilder tlb = new TaxaListBuilder();
                for (Taxon taxaA : (TaxaList)a) {
                    int bIndex = -1;
                    bIndex = ((TaxaList)b).indexOf(taxaA);
                    if (bIndex != -1) {
                        tlb.add(this.mergeTaxon(taxaA, (Taxon)((TaxaList)b).get(bIndex)));
                        continue;
                    }
                    tlb.add(taxaA);
                }
                for (Taxon taxaB : (TaxaList)b) {
                    int aIndex = -1;
                    aIndex = ((TaxaList)a).indexOf(taxaB);
                    if (aIndex != -1) continue;
                    tlb.add(taxaB);
                }
                return tlb.build();
            }
            if (a instanceof PositionList && b instanceof PositionList) {
                PositionListBuilder plb = new PositionListBuilder();
                for (Position posA : (PositionList)a) {
                    int bIndex = -1;
                    bIndex = ((PositionList)b).indexOf(posA);
                    if (bIndex != -1) {
                        plb.add(this.mergePosition(posA, (Position)((PositionList)b).get(bIndex)));
                        continue;
                    }
                    plb.add(posA);
                }
                for (Position posB : (PositionList)b) {
                    int aIndex = -1;
                    aIndex = ((PositionList)a).indexOf(posB);
                    if (aIndex != -1) continue;
                    plb.add(posB);
                }
                return plb.build();
            }
            ArrayList listBuilder = new ArrayList();
            for (Object objA : a) {
                listBuilder.add(objA);
            }
            for (Object objB : b) {
                if (listBuilder.contains(objB)) continue;
                listBuilder.add(objB);
            }
            return listBuilder;
        };
        switch (mergeType) {
            case Union: {
                return unionFunction;
            }
            case LeftJoin: {
                return leftJoinFunction;
            }
            case RightJoin: {
                return rightJoinFunction;
            }
        }
        return intersectFunction;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = MergeGenotypeTablesPlugin.class.getResource("/net/maizegenetics/analysis/images/Merge.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Merge GenotypeTable V2";
    }

    @Override
    public String getToolTipText() {
        return "Merges Genotype Tables";
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes a two or more GenotypeTables and Creates a CombinedGenotypeTable based on user-specified rules";
    }

    public MERGE_TYPES taxaMergeSelection() {
        return this.taxaMergeSelection.value();
    }

    public MergeGenotypeTablesPluginV2 taxaMergeSelection(MERGE_TYPES value) {
        this.taxaMergeSelection = new PluginParameter<MERGE_TYPES>(this.taxaMergeSelection, value);
        return this;
    }

    public MERGE_TYPES positionMergeSelection() {
        return this.positionMergeSelection.value();
    }

    public MergeGenotypeTablesPluginV2 positionMergeSelection(MERGE_TYPES value) {
        this.positionMergeSelection = new PluginParameter<MERGE_TYPES>(this.positionMergeSelection, value);
        return this;
    }

    public CALL_MERGE callMergeSelection() {
        return this.callMergeSelection.value();
    }

    public MergeGenotypeTablesPluginV2 callMergeSelection(CALL_MERGE value) {
        this.callMergeSelection = new PluginParameter<CALL_MERGE>(this.callMergeSelection, value);
        return this;
    }

    public DEPTH_MERGE depthMergeSelection() {
        return this.depthMergeSelection.value();
    }

    public MergeGenotypeTablesPluginV2 depthMergeSelection(DEPTH_MERGE value) {
        this.depthMergeSelection = new PluginParameter<DEPTH_MERGE>(this.depthMergeSelection, value);
        return this;
    }

    public static enum CALL_MERGE {
        Depth,
        RefereceProbability,
        Dosage,
        AlleleProbability;

    }

    public static enum DEPTH_MERGE {
        Additive,
        MaxDepth;

    }

    public static enum MERGE_TYPES {
        Intersect,
        Union,
        LeftJoin,
        RightJoin;

    }
}

