/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.dna.snp.io.BuilderFromVCF;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class SortGenotypeFilePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SortGenotypeFilePlugin.class);
    private PluginParameter<String> infile = new PluginParameter.Builder<String>("inputFile", null, String.class).required(true).inFile().guiName("Input file").description("Input file").build();
    private PluginParameter<String> outfile = new PluginParameter.Builder<String>("outputFile", null, String.class).required(true).outFile().guiName("Output file").description("Output file").build();
    private PluginParameter<SupportedFileTypes> fileType = new PluginParameter.Builder<SupportedFileTypes>("fileType", null, SupportedFileTypes.class).required(false).guiName("File type").description("Input/output file type (if not obvious from file name)").build();

    public SortGenotypeFilePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        switch (this.fileType()) {
            case Hapmap: {
                GenotypeTable myHapmap = BuilderFromHapMap.getBuilder(this.inputFile(), null).sortPositions().build();
                ExportUtils.writeToHapmap(myHapmap, this.outputFile());
                break;
            }
            case VCF: {
                GenotypeTable myVCF = BuilderFromVCF.getBuilder(this.inputFile()).keepDepth().buildAndSortInMemory();
                ExportUtils.writeToVCF(myVCF, this.outputFile(), true);
                break;
            }
            case Plink: {
                if (this.inputFile().endsWith(".plk.ped") || this.inputFile().endsWith(".plk.ped.gz")) {
                    String theMapFile = this.inputFile().replaceFirst(".plk.ped", ".plk.map");
                    GenotypeTable plink = ImportUtils.readFromPLink(this.inputFile(), theMapFile, this, true);
                    ExportUtils.writeToPlink(plink, this.outputFile(), '\t');
                    break;
                }
                if (!this.inputFile().endsWith(".plk.map") && !this.inputFile().endsWith(".plk.map.gz")) break;
                String thePedFile = this.inputFile().replaceFirst(".plk.map", ".plk.ped");
                GenotypeTable plink = ImportUtils.readFromPLink(thePedFile, this.inputFile(), this, true);
                ExportUtils.writeToPlink(plink, this.outputFile(), '\t');
                break;
            }
            default: {
                throw new IllegalArgumentException("SortGenotypeFilePlugin: Identified data type does not conform to known types (Hapmap, VCF)");
            }
        }
        return null;
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes a Hapmap, VCF, or Plink genotype file and sorts it according to TASSEL's conventions, which rely on the position, locus (chromosome), physical position, and SNP name (to facilitate searching).";
    }

    @Override
    protected void postProcessParameters() {
        if (this.fileType() == null) {
            if (this.inputFile().toLowerCase().endsWith(".hmp.txt") || this.inputFile().toLowerCase().endsWith(".hmp.txt.gz")) {
                this.fileType(SupportedFileTypes.Hapmap);
            } else if (this.inputFile().toLowerCase().endsWith(".vcf") || this.inputFile().toLowerCase().endsWith(".vcf.gz")) {
                this.fileType(SupportedFileTypes.VCF);
            } else if (this.inputFile().endsWith(".plk.ped") || this.inputFile().endsWith(".plk.ped.gz") || this.inputFile().endsWith(".plk.map") || this.inputFile().endsWith(".plk.map.gz")) {
                this.fileType(SupportedFileTypes.Plink);
            } else {
                throw new UnsupportedOperationException("Unable to guess file type from input file name. Please rename to end in .hmp.txt, .hmp.txt.gz, .vcf, .vcf.gz, FILE_EXT_PLINK_PED, or FILE_EXT_PLINK_MAP");
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SortGenotypeFilePlugin.class.getResource("/net/maizegenetics/analysis/images/sort.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Sort Genotype File";
    }

    @Override
    public String getToolTipText() {
        return "Sort Genotype File by Positions";
    }

    public String inputFile() {
        return this.infile.value();
    }

    public SortGenotypeFilePlugin inputFile(String value) {
        this.infile = new PluginParameter<String>(this.infile, value);
        return this;
    }

    public String outputFile() {
        return this.outfile.value();
    }

    public SortGenotypeFilePlugin outputFile(String value) {
        this.outfile = new PluginParameter<String>(this.outfile, value);
        return this;
    }

    public SupportedFileTypes fileType() {
        return this.fileType.value();
    }

    public SortGenotypeFilePlugin fileType(SupportedFileTypes value) {
        this.fileType = new PluginParameter<SupportedFileTypes>(this.fileType, value);
        return this;
    }

    public static enum SupportedFileTypes {
        Hapmap,
        VCF,
        Plink;

    }
}

