/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.taxa.IdentifierSynonymizer;

class SynonymizerFileChooser
extends JDialog {
    JFrame theFrame;
    Object[] datum;
    int[] fileOptions;
    String[] initialSelections;
    String step;
    String delimiter;

    public SynonymizerFileChooser(Frame theFrame, Object[] datum, int[] fileOptions, String[] initialSelections, String step) {
        super(theFrame, true);
        this.theFrame = (JFrame)theFrame;
        this.datum = datum;
        this.fileOptions = fileOptions;
        this.initialSelections = initialSelections;
        this.step = step;
        this.initialize();
        this.pack();
    }

    private void initialize() {
        if (this.step.equals("Step1")) {
            this.init_Step1();
        } else if (this.step.equals("Step2")) {
            this.init_Step2();
        } else if (this.step.equals("Step3")) {
            this.init_Step3();
        }
    }

    private void init_Step1() {
        final ArrayList<JComboBox> comboBoxes = new ArrayList<JComboBox>();
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(500, 300));
        this.getContentPane().add((Component)panel, "Center");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{49, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblSelectAReference = new JLabel("Select a File to Generate Synonyms");
        GridBagConstraints gbc_lblSelectAReference = this.getConstraints(1, 1, new Insets(0, 10, 5, 10));
        gbc_lblSelectAReference.anchor = 17;
        panel.add((Component)lblSelectAReference, gbc_lblSelectAReference);
        String[] listOfFileNames = this.getFileNamesFromDatum(this.datum);
        comboBoxes.add(this.getComboBoxWithSelection(listOfFileNames, this.initialSelections[0]));
        GridBagConstraints gbc_comboBoxReference = this.getConstraints(1, 2, new Insets(0, 10, 5, 10));
        gbc_comboBoxReference.fill = 2;
        panel.add((Component)comboBoxes.get(0), gbc_comboBoxReference);
        JLabel lblSelectASynonymize = new JLabel("Select A File to Be Synonymized");
        GridBagConstraints gbc_lblSelectASynonymize = this.getConstraints(1, 4, new Insets(0, 10, 5, 10));
        gbc_lblSelectASynonymize.anchor = 17;
        panel.add((Component)lblSelectASynonymize, gbc_lblSelectASynonymize);
        comboBoxes.add(this.getComboBoxWithSelection(listOfFileNames, this.initialSelections[1]));
        GridBagConstraints gbc_comboBoxSynonym = this.getConstraints(1, 5, new Insets(0, 10, 5, 10));
        gbc_comboBoxSynonym.fill = 2;
        panel.add((Component)comboBoxes.get(1), gbc_comboBoxSynonym);
        JLabel lblSynonymizeTechnique = new JLabel("Similarity Metric");
        GridBagConstraints gbc_lblSynonymizeTechnique = this.getConstraints(1, 7, new Insets(0, 10, 5, 10));
        gbc_lblSynonymizeTechnique.anchor = 17;
        panel.add((Component)lblSynonymizeTechnique, gbc_lblSynonymizeTechnique);
        comboBoxes.add(this.getComboBoxWithSelection(new String[]{"Dice's Coefficient(Default Technique)", "Edit Distance", "Dynamic Time Warping using Hamming Distance", "Dynamic Time Warping using Keyboard Distance", "Hamming Distance using Soundex Encoding", "Dice's Coefficient using Metaphone Encoding", "Edit Distance using Metaphone Encoding", "Delimiter Based Coefficient"}, "Dice's Coefficient(Default Technique)"));
        GridBagConstraints gbc_comboBoxTechniques = this.getConstraints(1, 8, new Insets(0, 10, 0, 10));
        gbc_comboBoxTechniques.fill = 2;
        panel.add((Component)comboBoxes.get(2), gbc_comboBoxTechniques);
        final JLabel lblSynonymizeDelim = new JLabel("Delimiter(Not Required)");
        lblSynonymizeDelim.setToolTipText("For use with concatenated Taxa names");
        GridBagConstraints gbc_lblSynonymizeDelim = this.getConstraints(1, 10, new Insets(0, 10, 0, 10));
        gbc_lblSynonymizeDelim.anchor = 17;
        panel.add((Component)lblSynonymizeDelim, gbc_lblSynonymizeDelim);
        final JTextField fldSynonymizeDelim = new JTextField();
        fldSynonymizeDelim.setPreferredSize(new Dimension(60, 30));
        GridBagConstraints gbc_fldSynonymizeDelim = this.getConstraints(1, 11, new Insets(0, 10, 20, 10));
        gbc_fldSynonymizeDelim.anchor = 17;
        gbc_fldSynonymizeDelim.fill = 2;
        panel.add((Component)fldSynonymizeDelim, gbc_fldSynonymizeDelim);
        lblSynonymizeDelim.setVisible(false);
        fldSynonymizeDelim.setVisible(false);
        ((JComboBox)comboBoxes.get(2)).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JComboBox)comboBoxes.get(2)).getSelectedIndex() == 7) {
                    lblSynonymizeDelim.setVisible(true);
                    fldSynonymizeDelim.setVisible(true);
                } else {
                    lblSynonymizeDelim.setVisible(false);
                    fldSynonymizeDelim.setVisible(false);
                }
            }
        });
        JLabel lblSelectFilesTo = new JLabel("Select Files to Generate Synonym List");
        lblSelectFilesTo.setHorizontalAlignment(0);
        this.getContentPane().add((Component)lblSelectFilesTo, "North");
        JPanel bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        GridBagLayout gbl_bottomPanel = new GridBagLayout();
        gbl_bottomPanel.columnWidths = new int[]{0, 0, 0, 43, 19, 0, 0};
        gbl_bottomPanel.rowHeights = new int[]{15, 0, 15, 0};
        gbl_bottomPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_bottomPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        bottomPanel.setLayout(gbl_bottomPanel);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerFileChooser.this.cancelButtonPressed(comboBoxes);
            }
        });
        GridBagConstraints gbc_btnCancel = this.getConstraints(4, 1, new Insets(0, 0, 5, 5));
        bottomPanel.add((Component)btnCancel, gbc_btnCancel);
        JButton btnSubmit = new JButton("Submit");
        btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerFileChooser.this.submitButtonPressed(comboBoxes, fldSynonymizeDelim.getText());
            }
        });
        GridBagConstraints gbc_btnSubmit = this.getConstraints(5, 1, new Insets(0, 0, 5, 0));
        bottomPanel.add((Component)btnSubmit, gbc_btnSubmit);
        this.getContentPane().setSize(500, 300);
        this.setTitle("Choose Files and the Synonymize Technique");
    }

    private void init_Step2() {
        final ArrayList<JComboBox> comboBoxes = new ArrayList<JComboBox>();
        final ArrayList<Integer> comboBoxLabel = new ArrayList<Integer>();
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(500, 300));
        this.getContentPane().add((Component)panel, "Center");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{49, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblSelectAReference = new JLabel("Select a File to Manually Edited:");
        GridBagConstraints gbc_lblSelectAReference = this.getConstraints(1, 1, new Insets(0, 10, 5, 10));
        gbc_lblSelectAReference.anchor = 17;
        panel.add((Component)lblSelectAReference, gbc_lblSelectAReference);
        String[] listOfFileNames = this.getFileNamesFromDatumSyn(this.datum);
        comboBoxes.add(this.getComboBoxWithSelection(listOfFileNames, this.initialSelections[0]));
        GridBagConstraints gbc_comboBoxReference = this.getConstraints(1, 2, new Insets(0, 10, 5, 10));
        gbc_comboBoxReference.fill = 2;
        panel.add((Component)comboBoxes.get(0), gbc_comboBoxReference);
        comboBoxLabel.add(1);
        JPanel bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        GridBagLayout gbl_bottomPanel = new GridBagLayout();
        gbl_bottomPanel.columnWidths = new int[]{0, 0, 0, 43, 19, 0, 0};
        gbl_bottomPanel.rowHeights = new int[]{15, 0, 15, 0};
        gbl_bottomPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_bottomPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        bottomPanel.setLayout(gbl_bottomPanel);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerFileChooser.this.cancelButtonPressed(comboBoxes);
            }
        });
        GridBagConstraints gbc_btnCancel = this.getConstraints(4, 1, new Insets(0, 0, 5, 5));
        bottomPanel.add((Component)btnCancel, gbc_btnCancel);
        JButton btnSubmit = new JButton("Submit");
        btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerFileChooser.this.submitButtonPressed(comboBoxes, SynonymizerFileChooser.this.getSyn_NonSynMapping(SynonymizerFileChooser.this.datum), comboBoxLabel);
            }
        });
        GridBagConstraints gbc_btnSubmit = this.getConstraints(5, 1, new Insets(0, 0, 5, 5));
        bottomPanel.add((Component)btnSubmit, gbc_btnSubmit);
        this.getContentPane().setSize(500, 300);
        this.setTitle("Choose File for Manual Update");
    }

    private void init_Step3() {
        final ArrayList<JComboBox> comboBoxes = new ArrayList<JComboBox>();
        final ArrayList<Integer> comboBoxLabel = new ArrayList<Integer>();
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(500, 300));
        this.getContentPane().add((Component)panel, "Center");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{49, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblSelectAReference = new JLabel("Select a Synonym File");
        GridBagConstraints gbc_lblSelectAReference = this.getConstraints(1, 1, new Insets(0, 10, 5, 10));
        gbc_lblSelectAReference.anchor = 17;
        panel.add((Component)lblSelectAReference, gbc_lblSelectAReference);
        String[] listOfSynFileNames = this.getFileNamesFromDatumSyn(this.datum);
        comboBoxes.add(this.getComboBoxWithSelection(listOfSynFileNames, this.initialSelections[0]));
        GridBagConstraints gbc_comboBoxReference = this.getConstraints(1, 2, new Insets(0, 10, 5, 10));
        gbc_comboBoxReference.fill = 2;
        panel.add((Component)comboBoxes.get(0), gbc_comboBoxReference);
        comboBoxLabel.add(1);
        JLabel lblSelectASynonymize = new JLabel("Select A File to Be Updated with Synonyms");
        GridBagConstraints gbc_lblSelectASynonymize = this.getConstraints(1, 4, new Insets(0, 10, 5, 10));
        gbc_lblSelectASynonymize.anchor = 17;
        panel.add((Component)lblSelectASynonymize, gbc_lblSelectASynonymize);
        String[] listOfFileNames = this.getFileNamesFromDatumNonSyn(this.datum);
        comboBoxes.add(this.getComboBoxWithSelection(listOfFileNames, this.initialSelections[1]));
        GridBagConstraints gbc_comboBoxSynonym = this.getConstraints(1, 5, new Insets(0, 10, 5, 10));
        gbc_comboBoxSynonym.fill = 2;
        panel.add((Component)comboBoxes.get(1), gbc_comboBoxSynonym);
        comboBoxLabel.add(0);
        JLabel lblSelectFilesTo = new JLabel("Select Files to Generate Synonym List");
        lblSelectFilesTo.setHorizontalAlignment(0);
        this.getContentPane().add((Component)lblSelectFilesTo, "North");
        JPanel bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        GridBagLayout gbl_bottomPanel = new GridBagLayout();
        gbl_bottomPanel.columnWidths = new int[]{0, 0, 0, 43, 19, 0, 0};
        gbl_bottomPanel.rowHeights = new int[]{15, 0, 15, 0};
        gbl_bottomPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_bottomPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        bottomPanel.setLayout(gbl_bottomPanel);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerFileChooser.this.cancelButtonPressed(comboBoxes);
            }
        });
        GridBagConstraints gbc_btnCancel = this.getConstraints(4, 1, new Insets(0, 0, 5, 5));
        bottomPanel.add((Component)btnCancel, gbc_btnCancel);
        JButton btnSubmit = new JButton("Submit");
        btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynonymizerFileChooser.this.submitButtonPressed(comboBoxes, SynonymizerFileChooser.this.getSyn_NonSynMapping(SynonymizerFileChooser.this.datum), comboBoxLabel);
            }
        });
        GridBagConstraints gbc_btnSubmit = this.getConstraints(5, 1, new Insets(0, 0, 5, 5));
        bottomPanel.add((Component)btnSubmit, gbc_btnSubmit);
        this.getContentPane().setSize(500, 300);
        this.setTitle("Choose Files");
    }

    private JComboBox getComboBoxWithSelection(String[] model, String selection) {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.setModel(new DefaultComboBoxModel<String>(model));
        for (int i = 0; i < model.length; ++i) {
            if (!model[i].equals(selection)) continue;
            comboBox.setSelectedIndex(i);
        }
        return comboBox;
    }

    private GridBagConstraints getConstraints(int gridx, int gridy, Insets inset) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = inset;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        return gbc;
    }

    private String[] getFileNamesFromDatum(Object[] datum) {
        String[] names = new String[datum.length];
        for (int i = 0; i < datum.length; ++i) {
            Datum singleRecord = (Datum)datum[i];
            names[i] = singleRecord.getName();
        }
        return names;
    }

    private String[] getFileNamesFromDatumSyn(Object[] datum) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object record : datum) {
            Datum singleRecord = (Datum)record;
            if (!singleRecord.getDataType().equals(IdentifierSynonymizer.class)) continue;
            names.add(singleRecord.getName());
        }
        String[] namesArray = new String[names.size()];
        for (int i = 0; i < namesArray.length; ++i) {
            namesArray[i] = (String)names.get(i);
        }
        return namesArray;
    }

    private String[] getFileNamesFromDatumSyn(Object[] datum, ArrayList<Integer> indexArray) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < datum.length; ++i) {
            Datum singleRecord = (Datum)datum[i];
            if (!singleRecord.getDataType().equals(IdentifierSynonymizer.class)) continue;
            indexArray.add(i);
            names.add(singleRecord.getName());
        }
        String[] namesArray = new String[names.size()];
        for (int i = 0; i < namesArray.length; ++i) {
            namesArray[i] = (String)names.get(i);
        }
        return namesArray;
    }

    private ArrayList<ArrayList<Integer>> getSyn_NonSynMapping(Object[] datum) {
        ArrayList<Integer> synList = new ArrayList<Integer>();
        ArrayList<Integer> nonSynList = new ArrayList<Integer>();
        for (int i = 0; i < datum.length; ++i) {
            Datum singleRecord = (Datum)datum[i];
            if (singleRecord.getDataType().equals(IdentifierSynonymizer.class)) {
                synList.add(i);
                continue;
            }
            nonSynList.add(i);
        }
        ArrayList<ArrayList<Integer>> combinedList = new ArrayList<ArrayList<Integer>>();
        combinedList.add(nonSynList);
        combinedList.add(synList);
        return combinedList;
    }

    private String[] getFileNamesFromDatumNonSyn(Object[] datum) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object record : datum) {
            Datum singleRecord = (Datum)record;
            if (singleRecord.getDataType().equals(IdentifierSynonymizer.class)) continue;
            names.add(singleRecord.getName());
        }
        String[] namesArray = new String[names.size()];
        for (int i = 0; i < namesArray.length; ++i) {
            namesArray[i] = (String)names.get(i);
        }
        return namesArray;
    }

    void cancelButtonPressed(ArrayList<JComboBox> comboBoxes) {
        for (int i = 0; i < this.fileOptions.length; ++i) {
            this.fileOptions[i] = -1;
        }
        this.setVisible(false);
    }

    void submitButtonPressed(ArrayList<JComboBox> comboBoxes) {
        for (int i = 0; i < this.fileOptions.length; ++i) {
            this.fileOptions[i] = comboBoxes.get(i).getSelectedIndex();
        }
        this.setVisible(false);
    }

    void submitButtonPressed(ArrayList<JComboBox> comboBoxes, String delim) {
        for (int i = 0; i < this.fileOptions.length; ++i) {
            this.fileOptions[i] = comboBoxes.get(i).getSelectedIndex();
        }
        this.delimiter = delim;
        this.setVisible(false);
    }

    void submitButtonPressed(ArrayList<JComboBox> comboBoxes, ArrayList<ArrayList<Integer>> synListMap, ArrayList<Integer> comboBoxLabel) {
        for (int i = 0; i < this.fileOptions.length; ++i) {
            this.fileOptions[i] = synListMap.get(comboBoxLabel.get(i)).get(comboBoxes.get(i).getSelectedIndex());
        }
        this.setVisible(false);
    }

    public String getDelim() {
        return this.delimiter;
    }
}

