/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.data.SynMenuDialog;
import net.maizegenetics.analysis.data.SynonymizerDialog;
import net.maizegenetics.analysis.data.SynonymizerFileChooser;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.taxa.IdentifierSynonymizer;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.GeneralAnnotation;
import org.apache.log4j.Logger;

public class SynonymizerPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SynonymizerPlugin.class);
    private String delimiter;

    public SynonymizerPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            Object menuArray;
            ArrayList<Datum> data = new ArrayList<Datum>();
            int n = input.getSize();
            for (int i = 0; i < n; ++i) {
                Datum idGroupDatum;
                TaxaList idGroup;
                Datum current = input.getData(i);
                Object currentData = current.getData();
                if (currentData instanceof GenotypeTable) {
                    idGroup = ((GenotypeTable)currentData).taxa();
                    idGroupDatum = new Datum(current.getName(), idGroup, current.getComment());
                    data.add(idGroupDatum);
                    continue;
                }
                if (currentData instanceof Phenotype) {
                    idGroup = ((Phenotype)currentData).taxa();
                    idGroupDatum = new Datum(current.getName(), idGroup, current.getComment());
                    data.add(idGroupDatum);
                    continue;
                }
                data.add(current);
            }
            DataSet newInput = new DataSet(data, (Plugin)this);
            if (this.isInteractive()) {
                TASSELMainFrame frame = (TASSELMainFrame)this.getParentFrame();
                Map map = frame.getDataTreePanel().getDataList();
                Object[] datumArray = map.keySet().toArray();
                if (datumArray.length < 2) {
                    String msg = "Error:  Make sure at least 2 files are loaded into TASSEL before attempting to Synonymize.";
                    JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                } else {
                    int response = JOptionPane.showConfirmDialog(frame, "Would you like to run the full Synonymizer Pipeline?", "Full Synonymize", 0);
                    if (response == 0) {
                        int[] fileOptions = this.getFileChoice(data, datumArray);
                        DataSet step1Result = this.runStep1(data, datumArray, fileOptions);
                        Datum step1DatumResult = (Datum)((ArrayList)step1Result.getDataSet()).get(0);
                        this.runStep2(step1DatumResult, true);
                        this.runStep3(datumArray, step1DatumResult, fileOptions);
                    } else {
                        menuArray = new boolean[]{false, false, false};
                        SynMenuDialog menuDiag = new SynMenuDialog((boolean[])menuArray, this.getParentFrame());
                        menuDiag.setLocationRelativeTo(this.getParentFrame());
                        menuDiag.setVisible(true);
                        if (menuArray[0] == true) {
                            int[] fileOptions = this.getFileChoice(data, datumArray);
                            DataSet dataSet = this.runStep1(data, datumArray, fileOptions);
                            return dataSet;
                        }
                        if (menuArray[1] == true) {
                            boolean hasSynonymFile = false;
                            for (int i = 0; i < datumArray.length; ++i) {
                                Datum currentDatum = (Datum)datumArray[i];
                                if (!currentDatum.getDataType().equals(IdentifierSynonymizer.class)) continue;
                                hasSynonymFile = true;
                            }
                            if (!hasSynonymFile) {
                                String msg = "Error:  No Synonymize files have been found.  Make sure at least one Synonymize File and at least one Standard File are loaded.\nPlease run the first step.";
                                JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                            } else {
                                String[] initialSelections = new String[1];
                                boolean errorOut = false;
                                boolean validSelection = false;
                                if (data.size() > 0 && ((Datum)data.get(0)).getDataType().equals(IdentifierSynonymizer.class)) {
                                    initialSelections[0] = ((Datum)data.get(0)).getName();
                                    validSelection = true;
                                }
                                if (!validSelection) {
                                    initialSelections[0] = "";
                                    for (int i = 0; i < datumArray.length; ++i) {
                                        Datum currentDatum = (Datum)datumArray[i];
                                        if (!currentDatum.getDataType().equals(IdentifierSynonymizer.class)) continue;
                                        initialSelections[0] = currentDatum.getName();
                                        break;
                                    }
                                    if (initialSelections[0].equals("")) {
                                        String msg = "Error:  No Synonymize files have been found.  Please run the first step.";
                                        JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                                        errorOut = true;
                                    }
                                }
                                if (!errorOut) {
                                    int[] fileOptions = new int[]{-1};
                                    SynonymizerFileChooser fileChooseDiag = new SynonymizerFileChooser(this.getParentFrame(), datumArray, fileOptions, initialSelections, "Step2");
                                    fileChooseDiag.setLocationRelativeTo(this.getParentFrame());
                                    fileChooseDiag.setVisible(true);
                                    if (fileOptions[0] != -1) {
                                        Datum current = (Datum)datumArray[fileOptions[0]];
                                        IdentifierSynonymizer is = (IdentifierSynonymizer)current.getData();
                                        SynonymizerDialog theSD = new SynonymizerDialog(is, this.getParentFrame());
                                        theSD.setLocationRelativeTo(this.getParentFrame());
                                        theSD.setVisible(true);
                                    }
                                }
                            }
                        } else if (menuArray[2] == true) {
                            boolean hasSynonymFile = false;
                            for (int i = 0; i < datumArray.length; ++i) {
                                Datum currentDatum = (Datum)datumArray[i];
                                if (!currentDatum.getDataType().equals(IdentifierSynonymizer.class)) continue;
                                hasSynonymFile = true;
                            }
                            if (!hasSynonymFile) {
                                String msg = "Error:  No Synonymize files have been found.  Make sure at least one Synonymize File and at least one Standard File are loaded.\nPlease run the first step.";
                                JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                            } else {
                                String[] initialSelections = new String[2];
                                boolean errorOut = false;
                                boolean validSelection = false;
                                if (data.size() > 1 && ((Datum)data.get(0)).getDataType().equals(IdentifierSynonymizer.class)) {
                                    initialSelections[0] = ((Datum)data.get(0)).getName();
                                    initialSelections[1] = ((Datum)data.get(1)).getName();
                                    validSelection = true;
                                }
                                if (!validSelection) {
                                    initialSelections[0] = "";
                                    initialSelections[1] = "";
                                    for (int i = 0; i < datumArray.length; ++i) {
                                        Datum currentDatum = (Datum)datumArray[i];
                                        if (initialSelections[1].equals("") && !currentDatum.getDataType().equals(IdentifierSynonymizer.class)) {
                                            initialSelections[1] = currentDatum.getName();
                                        }
                                        if (!currentDatum.getDataType().equals(IdentifierSynonymizer.class)) continue;
                                        initialSelections[0] = currentDatum.getName();
                                        break;
                                    }
                                    if (initialSelections[0].equals("")) {
                                        String msg = "Error:  No Synonymize files have been found.  Please run the first step.";
                                        JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                                        errorOut = true;
                                    }
                                }
                                if (!errorOut) {
                                    int[] fileOptions = new int[2];
                                    SynonymizerFileChooser fileChooseDiag = new SynonymizerFileChooser(this.getParentFrame(), datumArray, fileOptions, initialSelections, "Step3");
                                    fileChooseDiag.setLocationRelativeTo(this.getParentFrame());
                                    fileChooseDiag.setVisible(true);
                                    if (fileOptions[0] != -1) {
                                        Datum firstDatum = (Datum)datumArray[fileOptions[0]];
                                        IdentifierSynonymizer first = (IdentifierSynonymizer)firstDatum.getData();
                                        Datum current = (Datum)datumArray[fileOptions[1]];
                                        Object currentData = current.getData();
                                        if (currentData instanceof GenotypeTable) {
                                            if (first.checkSynForDups()) {
                                                String msg = "Error:  Duplicate Taxa to Be Synonymized.  Please Manually Update the Synonym List.";
                                                JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                                                errorOut = true;
                                            } else {
                                                ArrayList<TaxaList> swapped = first.swapSynonyms();
                                                GenotypeTable currentGenotypeTable = (GenotypeTable)currentData;
                                                GenotypeTable a = GenotypeTableBuilder.getInstance(currentGenotypeTable.genotypeMatrix(), currentGenotypeTable.positions(), swapped.get(0));
                                                Datum idGroupDatum = new Datum(current.getName() + "_Synonymized", a, current.getComment());
                                                ArrayList<Datum> listOfDatum = new ArrayList<Datum>();
                                                listOfDatum.add(idGroupDatum);
                                                DataSet output = new DataSet(listOfDatum, (Plugin)this);
                                                this.fireDataSetReturned(new PluginEvent(output, SynonymizerPlugin.class));
                                            }
                                        } else if (currentData instanceof Phenotype) {
                                            Phenotype currentPhenotype = (Phenotype)currentData;
                                            List<PhenotypeAttribute> attributeList = currentPhenotype.attributeListCopy();
                                            ArrayList<PhenotypeAttribute> newAttributeList = new ArrayList<PhenotypeAttribute>();
                                            ArrayList<Taxon> listOfTaxon = new ArrayList<Taxon>();
                                            ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
                                            for (int i = 0; i < attributeList.size(); ++i) {
                                                types.add(currentPhenotype.attributeType(i));
                                                if (currentPhenotype.attributeType(i).equals((Object)Phenotype.ATTRIBUTE_TYPE.taxa)) {
                                                    List<Taxon> oldTaxa = currentPhenotype.taxaAttribute().allTaxaAsList();
                                                    TaxaList synTl = first.getTaxaList();
                                                    HashMap<String, Taxon> taxonMap = new HashMap<String, Taxon>();
                                                    for (Taxon taxon : synTl) {
                                                        taxonMap.put(taxon.getName(), taxon);
                                                    }
                                                    for (Taxon taxon : oldTaxa) {
                                                        if (taxonMap.containsKey(taxon.getName())) {
                                                            String[] keys;
                                                            Taxon mappedTaxon = (Taxon)taxonMap.get(taxon.getName());
                                                            GeneralAnnotation ga = mappedTaxon.getAnnotation();
                                                            String[] values = ga.getTextAnnotation("SYNONYM");
                                                            if (values.length == 0 || values == null) {
                                                                listOfTaxon.add(taxon);
                                                                continue;
                                                            }
                                                            Taxon.Builder tb = new Taxon.Builder(ga.getTextAnnotation("SYNONYM")[0]);
                                                            for (String key : keys = ga.getTextAnnotation("SYNONYM")) {
                                                                String[] values2;
                                                                if (key.equals("SYNONYM")) continue;
                                                                for (String value : values2 = ga.getTextAnnotation(key)) {
                                                                    tb.addAnno(key, value);
                                                                }
                                                            }
                                                            String[] synVals = ga.getTextAnnotation("SYNONYM");
                                                            tb.addAnno("SYNONYM", taxon.getName());
                                                            for (int j = 1; j < synVals.length; ++j) {
                                                                tb.addAnno("SYNONYM", synVals[j]);
                                                            }
                                                            listOfTaxon.add(tb.build());
                                                            continue;
                                                        }
                                                        listOfTaxon.add(taxon);
                                                    }
                                                    newAttributeList.add(new TaxaAttribute(listOfTaxon));
                                                    continue;
                                                }
                                                newAttributeList.add(attributeList.get(i));
                                            }
                                            PhenotypeBuilder phb = new PhenotypeBuilder();
                                            phb.fromAttributeList(newAttributeList, types);
                                            Phenotype buildPhenotype = phb.build().get(0);
                                            Datum idGroupDatum = new Datum(current.getName() + "_Synonymized", buildPhenotype, current.getComment());
                                            ArrayList<Datum> listOfDatum = new ArrayList<Datum>();
                                            listOfDatum.add(idGroupDatum);
                                            DataSet output = new DataSet(listOfDatum, (Plugin)this);
                                            this.fireDataSetReturned(new PluginEvent(output, SynonymizerPlugin.class));
                                        } else {
                                            String msg = "Error:  Unsupported File Type. Please use a GenotypeTable or Phenotype.";
                                            JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                                            errorOut = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                DataSet response = null;
                return response;
            }
            int alignCnt = newInput.getDataOfType(TaxaList.class).size();
            int synCnt = newInput.getDataOfType(IdentifierSynonymizer.class).size();
            if (synCnt == 0 && alignCnt > 1) {
                Datum td = this.createSynonymizer(newInput);
                DataSet output = new DataSet(td, (Plugin)this);
                this.fireDataSetReturned(new PluginEvent(output, SynonymizerPlugin.class));
                menuArray = output;
                return menuArray;
            }
            if (synCnt != 1 || alignCnt <= 0) {
                if (synCnt == 1 && alignCnt == 0) {
                    if (this.isInteractive()) {
                        Datum inputDatum = newInput.getDataOfType(IdentifierSynonymizer.class).get(0);
                        IdentifierSynonymizer is = (IdentifierSynonymizer)inputDatum.getData();
                        SynonymizerDialog theSD = new SynonymizerDialog(is, this.getParentFrame());
                        theSD.setLocationRelativeTo(this.getParentFrame());
                        theSD.setVisible(true);
                    }
                } else {
                    String msg = "To create a synonym list:\n Please first select the reference taxa names and then the synonym taxa names (use Ctrl key)\nTo apply a synonym list to a dataset:\n Select a synonym list and then the taxa names to be changed (use Ctrl key)";
                    if (this.isInteractive()) {
                        JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                    } else {
                        myLogger.error((Object)msg);
                    }
                }
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum createSynonymizer(DataSet input) {
        Datum td = null;
        StringBuilder synonymSets = new StringBuilder();
        for (int i = 1; i < input.getSize(); ++i) {
            synonymSets.append(input.getData(i).getName());
            synonymSets.append("\n");
        }
        boolean performFunction = true;
        String msg = "You have selected to generate a synonym list from " + input.getData(0).getName() + " to be applied to the following dataset:\n" + synonymSets.toString();
        if (this.isInteractive()) {
            int response = JOptionPane.showOptionDialog(this.getParentFrame(), msg, "Verify Selection", 2, 3, null, null, null);
            if (response == 2) {
                performFunction = false;
            }
        } else {
            myLogger.info((Object)msg);
        }
        if (performFunction) {
            List<Datum> idList = input.getDataOfType(TaxaList.class);
            TaxaList[] aa = new TaxaList[idList.size() - 1];
            for (int i = 1; i < idList.size(); ++i) {
                aa[i - 1] = (TaxaList)idList.get(i).getData();
            }
            IdentifierSynonymizer ts = new IdentifierSynonymizer((TaxaList)idList.get(0).getData(), aa);
            StringWriter sw = new StringWriter();
            ts.report(new PrintWriter(sw));
            td = new Datum(input.getData(0).getName() + " Synonyms", ts, "Taxa synonyms\n" + sw.toString());
        }
        return td;
    }

    private Datum createSynonymizer(DataSet input, int technique) {
        Datum td = null;
        StringBuilder synonymSets = new StringBuilder();
        for (int i = 1; i < input.getSize(); ++i) {
            synonymSets.append(input.getData(i).getName());
            synonymSets.append("\n");
        }
        boolean performFunction = true;
        String msg = "You have selected to generate a synonym list from " + input.getData(0).getName() + " to be applied to the following dataset:\n" + synonymSets.toString();
        if (this.isInteractive()) {
            int response = JOptionPane.showOptionDialog(this.getParentFrame(), msg, "Verify Selection", 2, 3, null, null, null);
            if (response == 2) {
                performFunction = false;
            }
        } else {
            myLogger.info((Object)msg);
        }
        if (performFunction) {
            List<Datum> idList = input.getDataOfType(TaxaList.class);
            TaxaList[] aa = new TaxaList[idList.size() - 1];
            for (int i = 1; i < idList.size(); ++i) {
                aa[i - 1] = (TaxaList)idList.get(i).getData();
            }
            IdentifierSynonymizer ts = new IdentifierSynonymizer((TaxaList)idList.get(0).getData(), aa, technique);
            StringWriter sw = new StringWriter();
            ts.report(new PrintWriter(sw));
            td = new Datum(input.getData(1).getName() + " Synonymizer Object", ts, "Taxa synonyms\n" + sw.toString());
        }
        return td;
    }

    private Datum createSynonymizer(DataSet input, int technique, String delimiter) {
        Datum td = null;
        StringBuilder synonymSets = new StringBuilder();
        for (int i = 1; i < input.getSize(); ++i) {
            synonymSets.append(input.getData(i).getName());
            synonymSets.append("\n");
        }
        boolean performFunction = true;
        String msg = "You have selected to generate a synonym list from " + input.getData(0).getName() + " to be applied to the following dataset:\n" + synonymSets.toString();
        if (this.isInteractive()) {
            int response = JOptionPane.showOptionDialog(this.getParentFrame(), msg, "Verify Selection", 2, 3, null, null, null);
            if (response == 2) {
                performFunction = false;
            }
        } else {
            myLogger.info((Object)msg);
        }
        if (performFunction) {
            List<Datum> idList = input.getDataOfType(TaxaList.class);
            TaxaList[] aa = new TaxaList[idList.size() - 1];
            for (int i = 1; i < idList.size(); ++i) {
                aa[i - 1] = (TaxaList)idList.get(i).getData();
            }
            IdentifierSynonymizer ts = new IdentifierSynonymizer((TaxaList)idList.get(0).getData(), aa, technique, delimiter);
            StringWriter sw = new StringWriter();
            ts.report(new PrintWriter(sw));
            td = new Datum(input.getData(1).getName() + " Synonymizer Object", ts, "Taxa synonyms\n" + sw.toString());
        }
        return td;
    }

    private void applySynonymsToOldFile(Datum current, IdentifierSynonymizer first) {
        Object currentData = current.getData();
        if (currentData instanceof GenotypeTable) {
            if (first.checkSynForDups()) {
                String msg = "Error:  Duplicate Taxa to Be Synonymized.  Please Manually Update the Synonym List.";
                JOptionPane.showMessageDialog(this.getParentFrame(), msg);
            } else {
                ArrayList<TaxaList> swapped = first.swapSynonyms();
                GenotypeTable currentGenotypeTable = (GenotypeTable)currentData;
                GenotypeTable a = GenotypeTableBuilder.getInstance(currentGenotypeTable.genotypeMatrix(), currentGenotypeTable.positions(), swapped.get(0));
                Datum idGroupDatum = new Datum(current.getName() + "_Synonymized", a, current.getComment());
                ArrayList<Datum> listOfDatum = new ArrayList<Datum>();
                listOfDatum.add(idGroupDatum);
                DataSet output = new DataSet(listOfDatum, (Plugin)this);
                this.fireDataSetReturned(new PluginEvent(output, SynonymizerPlugin.class));
            }
        } else if (currentData instanceof Phenotype) {
            Phenotype currentPhenotype = (Phenotype)currentData;
            List<PhenotypeAttribute> attributeList = currentPhenotype.attributeListCopy();
            ArrayList<PhenotypeAttribute> newAttributeList = new ArrayList<PhenotypeAttribute>();
            ArrayList<Taxon> listOfTaxon = new ArrayList<Taxon>();
            ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            for (int i = 0; i < attributeList.size(); ++i) {
                types.add(currentPhenotype.attributeType(i));
                if (currentPhenotype.attributeType(i).equals((Object)Phenotype.ATTRIBUTE_TYPE.taxa)) {
                    List<Taxon> oldTaxa = currentPhenotype.taxaAttribute().allTaxaAsList();
                    TaxaList synTl = first.getTaxaList();
                    HashMap<String, Taxon> taxonMap = new HashMap<String, Taxon>();
                    for (Taxon taxon : synTl) {
                        taxonMap.put(taxon.getName(), taxon);
                    }
                    for (Taxon taxon : oldTaxa) {
                        if (taxonMap.containsKey(taxon.getName())) {
                            String[] keys;
                            Taxon mappedTaxon = (Taxon)taxonMap.get(taxon.getName());
                            GeneralAnnotation ga = mappedTaxon.getAnnotation();
                            String[] values = ga.getTextAnnotation("SYNONYM");
                            if (values.length == 0 || values == null) {
                                listOfTaxon.add(taxon);
                                continue;
                            }
                            Taxon.Builder tb = new Taxon.Builder(ga.getTextAnnotation("SYNONYM")[0]);
                            for (String key : keys = ga.getTextAnnotation("SYNONYM")) {
                                String[] values2;
                                if (key.equals("SYNONYM")) continue;
                                for (String value : values2 = ga.getTextAnnotation(key)) {
                                    tb.addAnno(key, value);
                                }
                            }
                            String[] synVals = ga.getTextAnnotation("SYNONYM");
                            tb.addAnno("SYNONYM", taxon.getName());
                            for (int j = 1; j < synVals.length; ++j) {
                                tb.addAnno("SYNONYM", synVals[j]);
                            }
                            listOfTaxon.add(tb.build());
                            continue;
                        }
                        listOfTaxon.add(taxon);
                    }
                    newAttributeList.add(new TaxaAttribute(listOfTaxon));
                    continue;
                }
                newAttributeList.add(attributeList.get(i));
            }
            PhenotypeBuilder phb = new PhenotypeBuilder();
            phb.fromAttributeList(newAttributeList, types);
            Phenotype buildPhenotype = phb.build().get(0);
            Datum idGroupDatum = new Datum(current.getName() + "_Synonymized", buildPhenotype, current.getComment());
            ArrayList<Datum> listOfDatum = new ArrayList<Datum>();
            listOfDatum.add(idGroupDatum);
            DataSet output = new DataSet(listOfDatum, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, SynonymizerPlugin.class));
        } else {
            String msg = "Error:  Unsupported File Type. Please use a GenotypeTable or Phenotype.";
            JOptionPane.showMessageDialog(this.getParentFrame(), msg);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SynonymizerPlugin.class.getResource("/net/maizegenetics/analysis/images/Synonymizer.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Synonymizer";
    }

    @Override
    public String getToolTipText() {
        return "Unify Taxa Names";
    }

    public int[] getFileChoice(List<Datum> data, Object[] datumArray) {
        String[] initialSelections = new String[2];
        if (data.size() > 1) {
            initialSelections[0] = data.get(0).getName();
            initialSelections[1] = data.get(1).getName();
        } else {
            Datum firstDatum = (Datum)datumArray[0];
            initialSelections[0] = firstDatum.getName();
            Datum secondDatum = (Datum)datumArray[1];
            initialSelections[1] = secondDatum.getName();
        }
        int[] fileOptions = new int[3];
        SynonymizerFileChooser fileChooseDiag = new SynonymizerFileChooser(this.getParentFrame(), datumArray, fileOptions, initialSelections, "Step1");
        fileChooseDiag.setLocationRelativeTo(this.getParentFrame());
        fileChooseDiag.setVisible(true);
        if (fileOptions[2] == 7) {
            this.delimiter = fileChooseDiag.getDelim();
        }
        System.out.println("Delim: " + fileChooseDiag.getDelim());
        return fileOptions;
    }

    public DataSet runStep1(List<Datum> data, Object[] datumArray, int[] fileOptions) {
        if (fileOptions[0] != -1) {
            ArrayList<Datum> datumList = new ArrayList<Datum>();
            for (int i = 0; i < fileOptions.length - 1; ++i) {
                Datum idGroupDatum;
                TaxaList idGroup;
                Datum current = (Datum)datumArray[fileOptions[i]];
                Object currentData = current.getData();
                if (currentData instanceof GenotypeTable) {
                    idGroup = ((GenotypeTable)currentData).taxa();
                    idGroupDatum = new Datum(current.getName(), idGroup, current.getComment());
                    datumList.add(idGroupDatum);
                    continue;
                }
                if (currentData instanceof Phenotype) {
                    idGroup = ((Phenotype)currentData).taxa();
                    idGroupDatum = new Datum(current.getName(), idGroup, current.getComment());
                    datumList.add(idGroupDatum);
                    continue;
                }
                datumList.add(current);
            }
            DataSet newInputDataSet = new DataSet(datumList, (Plugin)this);
            Datum td = null;
            td = fileOptions[2] == 7 ? this.createSynonymizer(newInputDataSet, fileOptions[2], this.delimiter) : this.createSynonymizer(newInputDataSet, fileOptions[2]);
            DataSet output = new DataSet(td, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, SynonymizerPlugin.class));
            return output;
        }
        return null;
    }

    public void runStep2(Datum currentData, boolean end2end) {
        IdentifierSynonymizer is = (IdentifierSynonymizer)currentData.getData();
        SynonymizerDialog theSD = new SynonymizerDialog(is, this.getParentFrame());
        theSD.setLocationRelativeTo(this.getParentFrame());
        theSD.setVisible(true);
    }

    public void runStep3(Object[] data, Datum step1Result, int[] fileOptions) {
        IdentifierSynonymizer first = (IdentifierSynonymizer)step1Result.getData();
        Datum current = (Datum)data[fileOptions[1]];
        Object currentData = current.getData();
        this.applySynonymsToOldFile(current, first);
    }
}

