/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.util.Arrays;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixBuilder;
import net.maizegenetics.util.GeneralAnnotationStorage;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class DominanceRelationshipMatrix {
    private static final Logger myLogger = Logger.getLogger(DominanceRelationshipMatrix.class);
    private static final int DEFAULT_MAX_ALLELES = 6;
    private static final KinshipPlugin.ALGORITHM_VARIATION DEFAULT_ALGORITHM_VARIATION = KinshipPlugin.ALGORITHM_VARIATION.Observed_Allele_Freq;
    private static final byte[] PRECALCULATED_COUNTS = new byte[512];
    private static final int NUM_CORES_TO_USE;
    private static int myNumSitesProcessed;

    private DominanceRelationshipMatrix() {
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype) {
        return DominanceRelationshipMatrix.getInstance(genotype, 6, DEFAULT_ALGORITHM_VARIATION, null);
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype, int maxAlleles, KinshipPlugin.ALGORITHM_VARIATION variation, ProgressListener listener) {
        return DominanceRelationshipMatrix.computeDominanceRelationships(genotype, maxAlleles, variation, listener);
    }

    private static DistanceMatrix computeDominanceRelationships(GenotypeTable genotype, int maxAlleles, KinshipPlugin.ALGORITHM_VARIATION variation, ProgressListener listener) {
        if (maxAlleles < 2 || maxAlleles > 6) {
            throw new IllegalArgumentException("DominanceRelationshipMatrix: computeDominanceRelationships: max alleles must be between 2 and 6 inclusive.");
        }
        if (variation != KinshipPlugin.ALGORITHM_VARIATION.Observed_Allele_Freq && variation != KinshipPlugin.ALGORITHM_VARIATION.Proportion_Heterozygous) {
            throw new IllegalArgumentException("DominanceRelationshipMatrix: computeDominanceRelationships: variation must be: " + (Object)((Object)KinshipPlugin.ALGORITHM_VARIATION.Observed_Allele_Freq) + " or " + (Object)((Object)KinshipPlugin.ALGORITHM_VARIATION.Proportion_Heterozygous));
        }
        int numTaxa = genotype.numberOfTaxa();
        long time = System.currentTimeMillis();
        Optional<CountersDistances> optional = DominanceRelationshipMatrix.stream(genotype, maxAlleles, variation, listener).reduce((t, u) -> {
            t.addAll((CountersDistances)u);
            return t;
        });
        if (!optional.isPresent()) {
            return null;
        }
        CountersDistances counters = optional.get();
        double sumpk = counters.mySumOfVariances;
        float[] distances = counters.myDistances;
        GeneralAnnotationStorage.Builder annotations = GeneralAnnotationStorage.getBuilder();
        annotations.addAnnotation("Matrix_Type", KinshipPlugin.KINSHIP_METHOD.Dominance_Centered_IBS.toString());
        annotations.addAnnotation("Matrix_Variation", variation.toString());
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(genotype.taxa());
        builder.annotation(annotations.build());
        int index = 0;
        for (int t2 = 0; t2 < numTaxa; ++t2) {
            int n = numTaxa - t2;
            for (int i = 0; i < n; ++i) {
                builder.set(t2, t2 + i, (double)distances[index] / sumpk);
                ++index;
            }
        }
        myLogger.info((Object)("DominanceRelationshipMatrix: computeDominanceRelationships time: " + (System.currentTimeMillis() - time) / 1000L + " seconds"));
        return builder.build();
    }

    private static void fireProgress(int percent, ProgressListener listener) {
        if (listener != null) {
            if (percent > 100) {
                percent = 100;
            }
            listener.progress(percent, null);
        }
    }

    private static Stream<CountersDistances> stream(GenotypeTable genotypes, int maxAlleles, KinshipPlugin.ALGORITHM_VARIATION variation, ProgressListener listener) {
        myNumSitesProcessed = 0;
        return StreamSupport.stream(new DominanceSiteSpliterator(genotypes, 0, genotypes.numberOfSites(), maxAlleles, variation, listener), true);
    }

    static {
        for (int allele = 0; allele < 8; ++allele) {
            for (int a = 0; a < 8; ++a) {
                for (int b = 0; b < 8; ++b) {
                    int temp = allele << 6 | a << 3 | b;
                    DominanceRelationshipMatrix.PRECALCULATED_COUNTS[temp] = allele == 7 || a == 7 && b == 7 ? 7 : ((allele == a || allele == b) && a != b ? 1 : 2);
                }
            }
        }
        NUM_CORES_TO_USE = Runtime.getRuntime().availableProcessors() - 1;
        myNumSitesProcessed = 0;
    }

    static class DominanceSiteSpliterator
    implements Spliterator<CountersDistances> {
        private int myCurrentSite;
        private final int myFence;
        private final GenotypeTable myGenotypes;
        private final int myNumTaxa;
        private final int myNumSites;
        private final ProgressListener myProgressListener;
        private int myMinSitesToProcess;
        private final int myMaxAlleles;
        private final KinshipPlugin.ALGORITHM_VARIATION myVariation;
        private static final int NUM_SITES_PER_BLOCK = 5;

        DominanceSiteSpliterator(GenotypeTable genotypes, int currentIndex, int fence, int maxAlleles, KinshipPlugin.ALGORITHM_VARIATION variation, ProgressListener listener) {
            this.myGenotypes = genotypes;
            this.myNumTaxa = this.myGenotypes.numberOfTaxa();
            this.myNumSites = this.myGenotypes.numberOfSites();
            this.myCurrentSite = currentIndex;
            this.myFence = fence;
            this.myMaxAlleles = maxAlleles;
            this.myVariation = variation;
            this.myProgressListener = listener;
            this.myMinSitesToProcess = this.myNumSites / NUM_CORES_TO_USE;
            if (this.myMinSitesToProcess == 0) {
                this.myMinSitesToProcess = this.myNumSites;
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super CountersDistances> action) {
            int numSitesProcessed = this.myFence - this.myCurrentSite;
            CountersDistances result = new CountersDistances(this.myNumTaxa);
            float[] distances = result.myDistances;
            double[] sumOfVariances = new double[1];
            float[] answer1 = new float[32768];
            float[] answer2 = new float[32768];
            float[] answer3 = new float[32768];
            while (this.myCurrentSite < this.myFence) {
                int[] realSites = new int[1];
                Tuple<short[], float[]> firstBlock = this.getBlockOfSites(this.myCurrentSite, sumOfVariances, realSites);
                float[] possibleTerms = (float[])firstBlock.y;
                short[] dominanceEffect1 = (short[])firstBlock.x;
                Tuple<short[], float[]> secondBlock = this.getBlockOfSites(this.myCurrentSite + realSites[0], sumOfVariances, realSites);
                float[] possibleTerms2 = (float[])secondBlock.y;
                short[] dominanceEffect2 = (short[])secondBlock.x;
                Tuple<short[], float[]> thirdBlock = this.getBlockOfSites(this.myCurrentSite + realSites[0], sumOfVariances, realSites);
                float[] possibleTerms3 = (float[])thirdBlock.y;
                short[] dominanceEffect3 = (short[])thirdBlock.x;
                this.myCurrentSite += realSites[0];
                for (int i = 0; i < 32768; ++i) {
                    answer1[i] = possibleTerms[(i & 0x7000) >>> 12] + possibleTerms[(i & 0xE00) >>> 9 | 8] + possibleTerms[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms[(i & 0x38) >>> 3 | 0x18] + possibleTerms[i & 7 | 0x20];
                    answer2[i] = possibleTerms2[(i & 0x7000) >>> 12] + possibleTerms2[(i & 0xE00) >>> 9 | 8] + possibleTerms2[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms2[(i & 0x38) >>> 3 | 0x18] + possibleTerms2[i & 7 | 0x20];
                    answer3[i] = possibleTerms3[(i & 0x7000) >>> 12] + possibleTerms3[(i & 0xE00) >>> 9 | 8] + possibleTerms3[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms3[(i & 0x38) >>> 3 | 0x18] + possibleTerms3[i & 7 | 0x20];
                }
                int index = 0;
                for (int firstTaxa = 0; firstTaxa < this.myNumTaxa; ++firstTaxa) {
                    if (dominanceEffect1[firstTaxa] != Short.MAX_VALUE || dominanceEffect2[firstTaxa] != Short.MAX_VALUE || dominanceEffect3[firstTaxa] != Short.MAX_VALUE) {
                        for (int secondTaxa = firstTaxa; secondTaxa < this.myNumTaxa; ++secondTaxa) {
                            int n = index++;
                            distances[n] = distances[n] + (answer1[dominanceEffect1[firstTaxa] | dominanceEffect1[secondTaxa]] + answer2[dominanceEffect2[firstTaxa] | dominanceEffect2[secondTaxa]] + answer3[dominanceEffect3[firstTaxa] | dominanceEffect3[secondTaxa]]);
                        }
                        continue;
                    }
                    index += this.myNumTaxa - firstTaxa;
                }
            }
            result.mySumOfVariances = sumOfVariances[0];
            action.accept(result);
            myNumSitesProcessed = myNumSitesProcessed + numSitesProcessed;
            DominanceRelationshipMatrix.fireProgress((int)((double)myNumSitesProcessed / (double)this.myNumSites * 100.0), this.myProgressListener);
        }

        private Tuple<short[], float[]> getBlockOfSites(int currentSite, double[] sumOfVariances, int[] realSites) {
            int currentSiteNum = 0;
            float[] possibleTerms = new float[40];
            short[] dominanceEffect = new short[this.myNumTaxa];
            Arrays.fill(dominanceEffect, (short)Short.MAX_VALUE);
            while (currentSiteNum < 5 && currentSite < this.myFence) {
                byte[] genotypes = this.myGenotypes.genotypeAllTaxa(currentSite);
                int[][] alleles = AlleleFreqCache.allelesSortedByFrequencyNucleotide(genotypes);
                int numAlleles = Math.min(alleles[0].length - 1, this.myMaxAlleles - 1);
                if (numAlleles + currentSiteNum <= 5) {
                    int totalAlleleCount = 0;
                    for (int i = 0; i < alleles[1].length; ++i) {
                        totalAlleleCount += alleles[1][i];
                    }
                    for (int a = 0; a < numAlleles; ++a) {
                        byte allele = (byte)alleles[0][a];
                        float standardizedTerm = 0.0f;
                        if (this.myVariation == KinshipPlugin.ALGORITHM_VARIATION.Observed_Allele_Freq) {
                            float alleleFreq = (float)alleles[1][a] / (float)totalAlleleCount;
                            standardizedTerm = 2.0f * alleleFreq * (1.0f - alleleFreq);
                        } else if (this.myVariation == KinshipPlugin.ALGORITHM_VARIATION.Proportion_Heterozygous) {
                            standardizedTerm = (float)AlleleFreqCache.proportionHeterozygous(genotypes);
                        }
                        sumOfVariances[0] = sumOfVariances[0] + (double)standardizedTerm * (1.0 - (double)standardizedTerm);
                        float[] term = new float[2];
                        if (allele != 15) {
                            term[0] = 1.0f - standardizedTerm;
                            term[1] = -standardizedTerm;
                            int siteNumIncrement = currentSiteNum * 8;
                            possibleTerms[siteNumIncrement + 1] = term[0] * term[0];
                            possibleTerms[siteNumIncrement + 3] = term[0] * term[1];
                            possibleTerms[siteNumIncrement + 2] = term[1] * term[1];
                            int temp = (allele & 7) << 6;
                            int shift = (5 - currentSiteNum - 1) * 3;
                            int mask = ~(7 << shift) & Short.MAX_VALUE;
                            for (int i = 0; i < this.myNumTaxa; ++i) {
                                dominanceEffect[i] = (short)(dominanceEffect[i] & (mask | PRECALCULATED_COUNTS[temp | (genotypes[i] & 0x70) >>> 1 | genotypes[i] & 7] << shift));
                            }
                        }
                        ++currentSiteNum;
                    }
                } else {
                    return new Tuple<short[], float[]>(dominanceEffect, possibleTerms);
                }
                ++currentSite;
                realSites[0] = realSites[0] + 1;
            }
            return new Tuple<short[], float[]>(dominanceEffect, possibleTerms);
        }

        @Override
        public boolean tryAdvance(Consumer<? super CountersDistances> action) {
            if (this.myCurrentSite < this.myFence) {
                this.forEachRemaining(action);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<CountersDistances> trySplit() {
            int lo = this.myCurrentSite;
            int mid = lo + this.myMinSitesToProcess;
            if (mid < this.myFence) {
                this.myCurrentSite = mid;
                return new DominanceSiteSpliterator(this.myGenotypes, lo, mid, this.myMaxAlleles, this.myVariation, this.myProgressListener);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.myFence - this.myCurrentSite;
        }

        @Override
        public int characteristics() {
            return 1024;
        }
    }

    private static class CountersDistances {
        private double mySumOfVariances = 0.0;
        private final float[] myDistances;
        private final int myNumTaxa;

        public CountersDistances(int numTaxa) {
            this.myNumTaxa = numTaxa;
            this.myDistances = new float[this.myNumTaxa * (this.myNumTaxa + 1) / 2];
        }

        public void addAll(CountersDistances counters) {
            float[] otherDistances = counters.myDistances;
            int n = this.myDistances.length;
            for (int t = 0; t < n; ++t) {
                int n2 = t;
                this.myDistances[n2] = this.myDistances[n2] + otherDistances[t];
            }
            this.mySumOfVariances += counters.mySumOfVariances;
        }
    }
}

