/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.util.Arrays;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixBuilder;
import net.maizegenetics.util.GeneralAnnotationStorage;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class EndelmanDistanceMatrix {
    private static final Logger myLogger = Logger.getLogger(EndelmanDistanceMatrix.class);
    private static final int DEFAULT_MAX_ALLELES = 6;
    private static final byte[] PRECALCULATED_COUNTS = new byte[512];
    private static final int NUM_CORES_TO_USE;
    private static int myNumSitesProcessed;

    private EndelmanDistanceMatrix() {
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype) {
        return EndelmanDistanceMatrix.getInstance(genotype, 6, null);
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype, int maxAlleles) {
        return EndelmanDistanceMatrix.getInstance(genotype, maxAlleles, null);
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype, ProgressListener listener) {
        return EndelmanDistanceMatrix.computeEndelmanDistances(genotype, 6, listener);
    }

    public static DistanceMatrix getInstance(GenotypeTable genotype, int maxAlleles, ProgressListener listener) {
        return EndelmanDistanceMatrix.computeEndelmanDistances(genotype, maxAlleles, listener);
    }

    private static DistanceMatrix computeEndelmanDistances(GenotypeTable genotype, int maxAlleles, ProgressListener listener) {
        if (maxAlleles < 2 || maxAlleles > 6) {
            throw new IllegalArgumentException("EndelmanDistanceMatrix: computeEndelmanDistances: max alleles must be between 2 and 6 inclusive.");
        }
        int numSeqs = genotype.numberOfTaxa();
        long estimatedNumMinutesToRun = Math.round((double)numSeqs * ((double)numSeqs + 1.0) / 2.0 * (double)genotype.numberOfSites() / (double)NUM_CORES_TO_USE / 8.5E10);
        if (estimatedNumMinutesToRun < 60L) {
            myLogger.info((Object)("EndelmanDistanceMatrix: estimated time: " + estimatedNumMinutesToRun + " minutes"));
        } else {
            myLogger.info((Object)("EndelmanDistanceMatrix: estimated time: " + estimatedNumMinutesToRun / 60L + " hours " + estimatedNumMinutesToRun % 60L + " minutes"));
        }
        long time = System.currentTimeMillis();
        Optional<CountersDistances> optional = EndelmanDistanceMatrix.stream(genotype, maxAlleles, listener).reduce((t, u) -> {
            t.addAll((CountersDistances)u);
            return t;
        });
        if (!optional.isPresent()) {
            return null;
        }
        CountersDistances counters = optional.get();
        double sumpk = counters.mySumPi;
        float[] distances = counters.myDistances;
        GeneralAnnotationStorage.Builder annotations = GeneralAnnotationStorage.getBuilder();
        annotations.addAnnotation("Matrix_Type", KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString());
        annotations.addAnnotation("Centered_IBS.SumPk", sumpk *= 2.0);
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(genotype.taxa());
        builder.annotation(annotations.build());
        int index = 0;
        for (int t2 = 0; t2 < numSeqs; ++t2) {
            int n = numSeqs - t2;
            for (int i = 0; i < n; ++i) {
                builder.set(t2, t2 + i, (double)distances[index] / sumpk);
                ++index;
            }
        }
        long actualNumMinutesToRun = Math.round((System.currentTimeMillis() - time) / 60000L);
        if (actualNumMinutesToRun < 60L) {
            myLogger.info((Object)("EndelmanDistanceMatrix: actual time: " + actualNumMinutesToRun + " minutes"));
        } else {
            myLogger.info((Object)("EndelmanDistanceMatrix: actual time: " + actualNumMinutesToRun / 60L + " hours " + actualNumMinutesToRun % 60L + " minutes"));
        }
        return builder.build();
    }

    public static DistanceMatrix subtractEndelmanDistance(DistanceMatrix[] matrices, DistanceMatrix superMatrix, ProgressListener listener) {
        double superSumpk;
        int numTaxa = superMatrix.numberOfTaxa();
        String matrixType = superMatrix.annotations().getTextAnnotation("Matrix_Type")[0];
        if (!matrixType.equals(KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString())) {
            throw new IllegalArgumentException("subtractEndelmanDistance: superset matrix must be matrix type: " + KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString());
        }
        for (DistanceMatrix current : matrices) {
            int currentNumTaxa = current.numberOfTaxa();
            if (currentNumTaxa != numTaxa) {
                throw new IllegalArgumentException("subtractEndelmanDistance: subset and superset must have same number of taxa.");
            }
            String[] currentMatrixType = current.annotations().getTextAnnotation("Matrix_Type");
            if (currentMatrixType.length == 0) {
                throw new IllegalArgumentException("subtractEndelmanDistance: subset matrix must be created with a more recent build of Tassel that adds neccessary annotations to the matrix");
            }
            if (matrixType.equals(currentMatrixType[0])) continue;
            throw new IllegalArgumentException("subtractEndelmanDistance: subset matrix must be matrix type: " + KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString());
        }
        TaxaList superTaxaList = superMatrix.getTaxaList();
        for (DistanceMatrix current : matrices) {
            TaxaList subsetTaxaList = current.getTaxaList();
            for (int t = 0; t < numTaxa; ++t) {
                if (((Taxon)superTaxaList.get(t)).equals(subsetTaxaList.get(t))) continue;
                throw new IllegalArgumentException("subtractEndelmanDistance: superset taxon: " + ((Taxon)superTaxaList.get(t)).getName() + " doesn't match subset taxon: " + subsetTaxaList.taxaName(t));
            }
        }
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(superTaxaList);
        int numMatrices = matrices.length;
        double resultSumpk = superSumpk = superMatrix.annotations().getQuantAnnotation("Centered_IBS.SumPk")[0];
        double[] matricesSumpk = new double[numMatrices];
        for (int i = 0; i < numMatrices; ++i) {
            matricesSumpk[i] = matrices[i].annotations().getQuantAnnotation("Centered_IBS.SumPk")[0];
            resultSumpk -= matricesSumpk[i];
        }
        GeneralAnnotationStorage.Builder resultAnnotations = GeneralAnnotationStorage.getBuilder();
        resultAnnotations.addAnnotation("Matrix_Type", KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString());
        resultAnnotations.addAnnotation("Centered_IBS.SumPk", resultSumpk);
        builder.annotation(resultAnnotations.build());
        for (int t = 0; t < numTaxa; ++t) {
            int n = numTaxa - t;
            for (int i = 0; i < n; ++i) {
                double resultValue = (double)superMatrix.getDistance(t, t + i) * superSumpk;
                for (int j = 0; j < numMatrices; ++j) {
                    resultValue -= (double)matrices[j].getDistance(t, t + i) * matricesSumpk[j];
                }
                builder.set(t, t + i, resultValue / resultSumpk);
            }
        }
        return builder.build();
    }

    public static DistanceMatrix addEndelmanDistance(DistanceMatrix[] matrices, ProgressListener listener) {
        int numTaxa = matrices[0].numberOfTaxa();
        String matrixType = matrices[0].annotations().getTextAnnotation("Matrix_Type")[0];
        if (!matrixType.equals(KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString())) {
            throw new IllegalArgumentException("addEndelmanDistance: superset matrix must be matrix type: " + KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString());
        }
        for (int i = 1; i < matrices.length; ++i) {
            DistanceMatrix current = matrices[i];
            int currentNumTaxa = current.numberOfTaxa();
            if (currentNumTaxa != numTaxa) {
                throw new IllegalArgumentException("addEndelmanDistance: all matrices must have same number of taxa.");
            }
            String[] currentMatrixType = current.annotations().getTextAnnotation("Matrix_Type");
            if (currentMatrixType.length == 0) {
                throw new IllegalArgumentException("addEndelmanDistance: matrix must be created with a more recent build of Tassel that adds neccessary annotations to the matrix");
            }
            if (matrixType.equals(currentMatrixType[0])) continue;
            throw new IllegalArgumentException("addEndelmanDistance: matrix must be matrix type: " + KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString());
        }
        TaxaList superTaxaList = matrices[0].getTaxaList();
        for (int i = 1; i < matrices.length; ++i) {
            DistanceMatrix current = matrices[i];
            TaxaList subsetTaxaList = current.getTaxaList();
            for (int t = 0; t < numTaxa; ++t) {
                if (((Taxon)superTaxaList.get(t)).equals(subsetTaxaList.get(t))) continue;
                throw new IllegalArgumentException("addEndelmanDistance: superset taxon: " + ((Taxon)superTaxaList.get(t)).getName() + " doesn't match subset taxon: " + subsetTaxaList.taxaName(t));
            }
        }
        DistanceMatrixBuilder builder = DistanceMatrixBuilder.getInstance(superTaxaList);
        int numMatrices = matrices.length;
        double resultSumpk = 0.0;
        double[] matricesSumpk = new double[numMatrices];
        for (int i = 0; i < numMatrices; ++i) {
            matricesSumpk[i] = matrices[i].annotations().getQuantAnnotation("Centered_IBS.SumPk")[0];
            resultSumpk += matricesSumpk[i];
        }
        GeneralAnnotationStorage.Builder resultAnnotations = GeneralAnnotationStorage.getBuilder();
        resultAnnotations.addAnnotation("Matrix_Type", KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString());
        resultAnnotations.addAnnotation("Centered_IBS.SumPk", resultSumpk);
        builder.annotation(resultAnnotations.build());
        for (int t = 0; t < numTaxa; ++t) {
            int n = numTaxa - t;
            for (int i = 0; i < n; ++i) {
                double resultValue = 0.0;
                for (int j = 0; j < numMatrices; ++j) {
                    resultValue += (double)matrices[j].getDistance(t, t + i) * matricesSumpk[j];
                }
                builder.set(t, t + i, resultValue / resultSumpk);
            }
        }
        return builder.build();
    }

    protected static void fireProgress(int percent, ProgressListener listener) {
        if (listener != null) {
            if (percent > 100) {
                percent = 100;
            }
            listener.progress(percent, null);
        }
    }

    private static Stream<CountersDistances> stream(GenotypeTable genotypes, int maxAlleles, ProgressListener listener) {
        myNumSitesProcessed = 0;
        return StreamSupport.stream(new EndelmanSiteSpliterator(genotypes, 0, genotypes.numberOfSites(), maxAlleles, listener), true);
    }

    static {
        for (int allele = 0; allele < 8; ++allele) {
            for (int a = 0; a < 8; ++a) {
                for (int b = 0; b < 8; ++b) {
                    int temp = allele << 6 | a << 3 | b;
                    if (allele == 7 || a == 7 && b == 7) {
                        EndelmanDistanceMatrix.PRECALCULATED_COUNTS[temp] = 7;
                        continue;
                    }
                    if (a == allele) {
                        if (b == allele) {
                            EndelmanDistanceMatrix.PRECALCULATED_COUNTS[temp] = 4;
                            continue;
                        }
                        EndelmanDistanceMatrix.PRECALCULATED_COUNTS[temp] = 2;
                        continue;
                    }
                    EndelmanDistanceMatrix.PRECALCULATED_COUNTS[temp] = b == allele ? 2 : 1;
                }
            }
        }
        NUM_CORES_TO_USE = TasselPrefs.getMaxThreads();
        myNumSitesProcessed = 0;
    }

    static class EndelmanSiteSpliterator
    implements Spliterator<CountersDistances> {
        private int myCurrentSite;
        private final int myFence;
        private final GenotypeTable myGenotypes;
        private final int myNumTaxa;
        private final int myNumSites;
        private final int myMaxAlleles;
        private final ProgressListener myProgressListener;
        private final int myMinSitesToProcess;
        private final int myNumSitesPerBlockForProgressReporting;
        private static final int NUM_SITES_PER_BLOCK = 5;

        EndelmanSiteSpliterator(GenotypeTable genotypes, int currentIndex, int fence, int maxAlleles, ProgressListener listener) {
            this.myGenotypes = genotypes;
            this.myNumTaxa = this.myGenotypes.numberOfTaxa();
            this.myNumSites = this.myGenotypes.numberOfSites();
            this.myCurrentSite = currentIndex;
            this.myFence = fence;
            this.myMaxAlleles = maxAlleles;
            this.myProgressListener = listener;
            this.myMinSitesToProcess = Math.max(this.myNumSites / NUM_CORES_TO_USE, 1000);
            this.myNumSitesPerBlockForProgressReporting = Math.max((this.myFence - this.myCurrentSite) / 10, 100);
        }

        @Override
        public void forEachRemaining(Consumer<? super CountersDistances> action) {
            CountersDistances result = new CountersDistances(this.myNumTaxa);
            float[] distances = result.myDistances;
            double[] sumpi = new double[1];
            float[] answer1 = new float[32768];
            float[] answer2 = new float[32768];
            float[] answer3 = new float[32768];
            while (this.myCurrentSite < this.myFence) {
                int currentBlockFence = Math.min(this.myCurrentSite + this.myNumSitesPerBlockForProgressReporting, this.myFence);
                int numSitesProcessed = currentBlockFence - this.myCurrentSite;
                while (this.myCurrentSite < currentBlockFence) {
                    int[] realSites = new int[1];
                    Tuple<short[], float[]> firstBlock = this.getBlockOfSites(this.myCurrentSite, sumpi, realSites);
                    float[] possibleTerms = (float[])firstBlock.y;
                    short[] alleleCount1 = (short[])firstBlock.x;
                    Tuple<short[], float[]> secondBlock = this.getBlockOfSites(this.myCurrentSite + realSites[0], sumpi, realSites);
                    float[] possibleTerms2 = (float[])secondBlock.y;
                    short[] alleleCount2 = (short[])secondBlock.x;
                    Tuple<short[], float[]> thirdBlock = this.getBlockOfSites(this.myCurrentSite + realSites[0], sumpi, realSites);
                    float[] possibleTerms3 = (float[])thirdBlock.y;
                    short[] alleleCount3 = (short[])thirdBlock.x;
                    this.myCurrentSite += realSites[0];
                    for (int i = 0; i < 32768; ++i) {
                        answer1[i] = possibleTerms[(i & 0x7000) >>> 12] + possibleTerms[(i & 0xE00) >>> 9 | 8] + possibleTerms[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms[(i & 0x38) >>> 3 | 0x18] + possibleTerms[i & 7 | 0x20];
                        answer2[i] = possibleTerms2[(i & 0x7000) >>> 12] + possibleTerms2[(i & 0xE00) >>> 9 | 8] + possibleTerms2[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms2[(i & 0x38) >>> 3 | 0x18] + possibleTerms2[i & 7 | 0x20];
                        answer3[i] = possibleTerms3[(i & 0x7000) >>> 12] + possibleTerms3[(i & 0xE00) >>> 9 | 8] + possibleTerms3[(i & 0x1C0) >>> 6 | 0x10] + possibleTerms3[(i & 0x38) >>> 3 | 0x18] + possibleTerms3[i & 7 | 0x20];
                    }
                    int index = 0;
                    for (int firstTaxa = 0; firstTaxa < this.myNumTaxa; ++firstTaxa) {
                        if (alleleCount1[firstTaxa] != Short.MAX_VALUE || alleleCount2[firstTaxa] != Short.MAX_VALUE || alleleCount3[firstTaxa] != Short.MAX_VALUE) {
                            for (int secondTaxa = firstTaxa; secondTaxa < this.myNumTaxa; ++secondTaxa) {
                                int n = index++;
                                distances[n] = distances[n] + (answer1[alleleCount1[firstTaxa] | alleleCount1[secondTaxa]] + answer2[alleleCount2[firstTaxa] | alleleCount2[secondTaxa]] + answer3[alleleCount3[firstTaxa] | alleleCount3[secondTaxa]]);
                            }
                            continue;
                        }
                        index += this.myNumTaxa - firstTaxa;
                    }
                }
                myNumSitesProcessed = myNumSitesProcessed + numSitesProcessed;
                EndelmanDistanceMatrix.fireProgress((int)((double)myNumSitesProcessed / (double)this.myNumSites * 100.0), this.myProgressListener);
            }
            result.mySumPi = sumpi[0];
            action.accept(result);
        }

        private Tuple<short[], float[]> getBlockOfSites(int currentSite, double[] sumpi, int[] realSites) {
            int currentSiteNum = 0;
            float[] possibleTerms = new float[40];
            short[] alleleCount = new short[this.myNumTaxa];
            Arrays.fill(alleleCount, (short)Short.MAX_VALUE);
            while (currentSiteNum < 5 && currentSite < this.myFence) {
                byte[] genotypes = this.myGenotypes.genotypeAllTaxa(currentSite);
                int[][] alleles = AlleleFreqCache.allelesSortedByFrequencyNucleotide(genotypes);
                int numAlleles = Math.min(alleles[0].length - 1, this.myMaxAlleles - 1);
                if (numAlleles + currentSiteNum <= 5) {
                    int totalAlleleCount = 0;
                    for (int i = 0; i < alleles[1].length; ++i) {
                        totalAlleleCount += alleles[1][i];
                    }
                    for (int a = 0; a < numAlleles; ++a) {
                        byte allele = (byte)alleles[0][a];
                        float alleleFreq = (float)alleles[1][a] / (float)totalAlleleCount;
                        float alleleFreqTimes2 = alleleFreq * 2.0f;
                        sumpi[0] = sumpi[0] + (double)alleleFreq * (1.0 - (double)alleleFreq);
                        float[] term = new float[3];
                        if (allele != 15) {
                            term[0] = 0.0f - alleleFreqTimes2;
                            term[1] = 1.0f - alleleFreqTimes2;
                            term[2] = 2.0f - alleleFreqTimes2;
                            int siteNumIncrement = currentSiteNum * 8;
                            possibleTerms[siteNumIncrement + 1] = term[0] * term[0];
                            possibleTerms[siteNumIncrement + 3] = term[0] * term[1];
                            possibleTerms[siteNumIncrement + 5] = term[0] * term[2];
                            possibleTerms[siteNumIncrement + 2] = term[1] * term[1];
                            possibleTerms[siteNumIncrement + 6] = term[1] * term[2];
                            possibleTerms[siteNumIncrement + 4] = term[2] * term[2];
                            int temp = (allele & 7) << 6;
                            int shift = (5 - currentSiteNum - 1) * 3;
                            int mask = ~(7 << shift) & Short.MAX_VALUE;
                            for (int i = 0; i < this.myNumTaxa; ++i) {
                                alleleCount[i] = (short)(alleleCount[i] & (mask | PRECALCULATED_COUNTS[temp | (genotypes[i] & 0x70) >>> 1 | genotypes[i] & 7] << shift));
                            }
                        }
                        ++currentSiteNum;
                    }
                } else {
                    return new Tuple<short[], float[]>(alleleCount, possibleTerms);
                }
                ++currentSite;
                realSites[0] = realSites[0] + 1;
            }
            return new Tuple<short[], float[]>(alleleCount, possibleTerms);
        }

        @Override
        public boolean tryAdvance(Consumer<? super CountersDistances> action) {
            if (this.myCurrentSite < this.myFence) {
                this.forEachRemaining(action);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<CountersDistances> trySplit() {
            int lo = this.myCurrentSite;
            int mid = lo + this.myMinSitesToProcess;
            if (mid < this.myFence) {
                this.myCurrentSite = mid;
                return new EndelmanSiteSpliterator(this.myGenotypes, lo, mid, this.myMaxAlleles, this.myProgressListener);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.myFence - this.myCurrentSite;
        }

        @Override
        public int characteristics() {
            return 1024;
        }
    }

    private static class CountersDistances {
        private double mySumPi = 0.0;
        private final float[] myDistances;
        private final int myNumTaxa;

        public CountersDistances(int numTaxa) {
            this.myNumTaxa = numTaxa;
            this.myDistances = new float[this.myNumTaxa * (this.myNumTaxa + 1) / 2];
        }

        public void addAll(CountersDistances counters) {
            float[] otherDistances = counters.myDistances;
            int n = this.myDistances.length;
            for (int t = 0; t < n; ++t) {
                int n2 = t;
                this.myDistances[n2] = this.myDistances[n2] + otherDistances[t];
            }
            this.mySumPi += counters.mySumPi;
        }
    }
}

