/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.util.stream.IntStream;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix2Alleles;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix3Alleles;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.BitUtil;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Tuple;

public class IBSDistanceMatrix {
    private static final long TRUE_TRUE_LONG = 4398048608257L;
    private static final long TRUE_FALSE_LONG = 1L;
    private static final long FALSE_TRUE_LONG = 0x200000L;
    private static final long FALSE_FALSE_LONG = 0L;
    private static long[][] INCREMENT_FUNCTIONS = null;

    private IBSDistanceMatrix() {
    }

    public static DistanceMatrix getInstance(GenotypeTable theAlignment) {
        return IBSDistanceMatrix.getInstance(theAlignment, null);
    }

    public static DistanceMatrix getInstance(GenotypeTable theAlignment, ProgressListener listener) {
        return IBSDistanceMatrix.getInstance(theAlignment, 0, listener);
    }

    public static DistanceMatrix getInstance(GenotypeTable theAlignment, int minSiteComp, ProgressListener listener) {
        return IBSDistanceMatrix.getInstance(theAlignment, minSiteComp, false, listener, true);
    }

    public static DistanceMatrix getInstance(GenotypeTable theAlignment, int minSiteComp, boolean trueIBS, ProgressListener listener, boolean useThirdState) {
        if (useThirdState) {
            return IBSDistanceMatrix3Alleles.getInstance(theAlignment, minSiteComp, trueIBS, listener);
        }
        return IBSDistanceMatrix2Alleles.getInstance(theAlignment, minSiteComp, trueIBS, listener);
    }

    public static double[] computeHetDistances(byte[] first, byte[] second, int minSitesComp) {
        IBSDistanceMatrix.setupHetBitDistancesIncrementors();
        long counts = 0L;
        for (int i = 0; i < first.length; ++i) {
            int key1 = (first[i] & 0x70) >>> 1 | first[i] & 7;
            int key2 = (second[i] & 0x70) >>> 1 | second[i] & 7;
            counts += INCREMENT_FUNCTIONS[key1][key2];
        }
        int sameCount = (int)(counts & 0x1FFFFFL);
        int diffCount = (int)(counts >>> 21 & 0x1FFFFFL);
        int hetCount = (int)(counts >>> 42 & 0x1FFFFFL);
        long sites = sameCount + diffCount - hetCount;
        double identity = ((double)sameCount - 0.5 * (double)hetCount) / (double)sites;
        double dist = 1.0 - identity;
        if (sites < (long)minSitesComp) {
            dist = Double.NaN;
        }
        return new double[]{dist, sites};
    }

    private static Tuple<double[][], Double> computeHetBitDistances(boolean useThirdState, ProgressListener listener, GenotypeTable theTBA, boolean isTrueIBS, int minSitesComp) {
        int numSeqs = theTBA.numberOfTaxa();
        double avgTotalSites = 0.0;
        double[][] distance = new double[numSeqs][numSeqs];
        long numberOfTests = numSeqs * (numSeqs - 1) / 2;
        long time = System.currentTimeMillis();
        IntStream.range(0, numSeqs).parallel().forEach(i -> {
            long[] iMj = theTBA.allelePresenceForAllSites(i, WHICH_ALLELE.Major).getBits();
            long[] iMn = theTBA.allelePresenceForAllSites(i, WHICH_ALLELE.Minor).getBits();
            long[] iMn2 = null;
            if (useThirdState) {
                iMn2 = theTBA.allelePresenceForAllSites(i, WHICH_ALLELE.Minor2).getBits();
            }
            for (int j = i; j < numSeqs; ++j) {
                double[] result;
                if (j == i && !isTrueIBS) {
                    distance[i][i] = 0.0;
                    continue;
                }
                long[] jMj = theTBA.allelePresenceForAllSites(j, WHICH_ALLELE.Major).getBits();
                long[] jMn = theTBA.allelePresenceForAllSites(j, WHICH_ALLELE.Minor).getBits();
                if (useThirdState) {
                    long[] jMn2 = theTBA.allelePresenceForAllSites(j, WHICH_ALLELE.Minor2).getBits();
                    result = IBSDistanceMatrix.computeHetBitDistancesThirdState(iMj, iMn, iMn2, jMj, jMn, jMn2, minSitesComp);
                } else {
                    result = IBSDistanceMatrix.computeHetBitDistances(iMj, iMn, jMj, jMn, minSitesComp);
                }
                double d = result[0];
                distance[j][i] = d;
                distance[i][j] = d;
            }
        });
        System.out.println("computeHetBitDistances time = " + (System.currentTimeMillis() - time) / 1000L + " seconds");
        return new Tuple<double[][], Double>(distance, avgTotalSites);
    }

    public static double[] computeHetBitDistances(GenotypeTable theTBA, int taxon1, int taxon2) {
        return IBSDistanceMatrix.computeHetBitDistances(theTBA, taxon1, taxon2, 0);
    }

    public static double[] computeHetBitDistances(GenotypeTable theTBA, int taxon1, int taxon2, int minSitesCompared) {
        long[] iMj = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Major).getBits();
        long[] iMn = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Minor).getBits();
        long[] iMn2 = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Minor2).getBits();
        long[] jMj = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Major).getBits();
        long[] jMn = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Minor).getBits();
        long[] jMn2 = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Minor2).getBits();
        return IBSDistanceMatrix.computeHetBitDistancesThirdState(iMj, iMn, iMn2, jMj, jMn, jMn2, minSitesCompared, 0, iMj.length - 1);
    }

    public static double[] computeHetBitDistances(GenotypeTable theTBA, int taxon1, int taxon2, int minSitesCompared, int firstWord, int lastWord, BitSet maskBadSet) {
        long[] iMj = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Major).getBits();
        long[] iMn = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Minor).getBits();
        long[] iMn2 = theTBA.allelePresenceForAllSites(taxon1, WHICH_ALLELE.Minor2).getBits();
        if (maskBadSet != null) {
            int i;
            long[] maskBad = maskBadSet.getBits();
            for (i = 0; i < iMj.length; ++i) {
                iMj[i] = iMj[i] & maskBad[i];
            }
            for (i = 0; i < iMn.length; ++i) {
                iMn[i] = iMn[i] & maskBad[i];
            }
            for (i = 0; i < iMn2.length; ++i) {
                iMn2[i] = iMn2[i] & maskBad[i];
            }
        }
        long[] jMj = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Major).getBits();
        long[] jMn = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Minor).getBits();
        long[] jMn2 = theTBA.allelePresenceForAllSites(taxon2, WHICH_ALLELE.Minor2).getBits();
        return IBSDistanceMatrix.computeHetBitDistancesThirdState(iMj, iMn, iMn2, jMj, jMn, jMn2, minSitesCompared, firstWord, lastWord);
    }

    public static double[] computeHetBitDistances(long[] iMj, long[] iMn, long[] jMj, long[] jMn, int minSitesCompared) {
        return IBSDistanceMatrix.computeHetBitDistances(iMj, iMn, jMj, jMn, minSitesCompared, 0, iMj.length - 1);
    }

    public static double[] computeHetBitDistancesThirdState(long[] iMj, long[] iMn, long[] iMn2, long[] jMj, long[] jMn, long[] jMn2, int minSitesCompared) {
        return IBSDistanceMatrix.computeHetBitDistancesThirdState(iMj, iMn, iMn2, jMj, jMn, jMn2, minSitesCompared, 0, iMj.length - 1);
    }

    public static double[] computeHetBitDistances(long[] iMj, long[] iMn, long[] jMj, long[] jMn, int minSitesCompared, int firstWord, int lastWord) {
        int sameCnt = 0;
        int diffCnt = 0;
        int hetCnt = 0;
        for (int x = firstWord; x <= lastWord; ++x) {
            long same = iMj[x] & jMj[x] | iMn[x] & jMn[x];
            long diff = iMj[x] & jMn[x] | iMn[x] & jMj[x];
            long hets = same & diff;
            sameCnt += BitUtil.pop(same);
            diffCnt += BitUtil.pop(diff);
            hetCnt += BitUtil.pop(hets);
        }
        int sites = sameCnt + diffCnt - hetCnt;
        double identity = ((double)sameCnt - 0.5 * (double)hetCnt) / (double)sites;
        double dist = 1.0 - identity;
        if (sites > minSitesCompared) {
            return new double[]{dist, sites};
        }
        return new double[]{Double.NaN, sites};
    }

    public static double[] computeHetBitDistancesThirdState(long[] iMj, long[] iMn, long[] iMn2, long[] jMj, long[] jMn, long[] jMn2, int minSitesCompared, int firstWord, int lastWord) {
        int sameCnt = 0;
        int diffCnt = 0;
        int hetCnt = 0;
        for (int x = firstWord; x <= lastWord; ++x) {
            long same = iMj[x] & jMj[x] | iMn[x] & jMn[x] | iMn2[x] & jMn2[x];
            long diff = iMj[x] & jMn[x] | iMn[x] & jMj[x] | iMj[x] & jMn2[x] | iMn2[x] & jMj[x] | iMn[x] & jMn2[x] | iMn2[x] & jMn[x];
            long hets = same & diff;
            sameCnt += BitUtil.pop(same);
            diffCnt += BitUtil.pop(diff);
            hetCnt += BitUtil.pop(hets);
        }
        int sites = sameCnt + diffCnt - hetCnt;
        double identity = ((double)sameCnt - 0.5 * (double)hetCnt) / (double)sites;
        double dist = 1.0 - identity;
        if (sites > minSitesCompared) {
            return new double[]{dist, sites};
        }
        return new double[]{Double.NaN, sites};
    }

    private static void setupHetBitDistancesIncrementors() {
        if (INCREMENT_FUNCTIONS != null) {
            return;
        }
        INCREMENT_FUNCTIONS = new long[64][64];
        int[] possibleValues = new int[]{0, 1, 2, 3, 4, 5, 15};
        for (int a = 0; a < 7; ++a) {
            for (int b = 0; b < 7; ++b) {
                for (int c = 0; c < 7; ++c) {
                    for (int d = 0; d < 7; ++d) {
                        int key1 = (possibleValues[a] & 7) << 3 | possibleValues[b] & 7;
                        int key2 = (possibleValues[c] & 7) << 3 | possibleValues[d] & 7;
                        byte[] target = new byte[]{(byte)possibleValues[a], (byte)possibleValues[b]};
                        byte[] match = new byte[]{(byte)possibleValues[c], (byte)possibleValues[d]};
                        int[] result = new int[3];
                        result[0] = 0;
                        result[1] = 0;
                        if (target[0] != 15) {
                            if (target[0] == match[0] || target[0] == match[1]) {
                                result[0] = 1;
                            }
                            if (match[0] != 15 && match[0] != target[0]) {
                                result[1] = 1;
                            } else if (match[1] != 15 && match[1] != target[0]) {
                                result[1] = 1;
                            }
                        }
                        if (result[0] == 1 && result[1] == 1) {
                            IBSDistanceMatrix.INCREMENT_FUNCTIONS[key1][key2] = 4398048608257L;
                            continue;
                        }
                        if (target[1] != 15) {
                            if (target[1] == match[0] || target[1] == match[1]) {
                                result[0] = 1;
                            }
                            if (match[0] != 15 && match[0] != target[1]) {
                                result[1] = 1;
                            } else if (match[1] != 15 && match[1] != target[1]) {
                                result[1] = 1;
                            }
                        }
                        IBSDistanceMatrix.INCREMENT_FUNCTIONS[key1][key2] = result[0] == 1 && result[1] == 1 ? 4398048608257L : (result[0] == 1 ? 1L : (result[1] == 1 ? 0x200000L : 0L));
                    }
                }
            }
        }
    }
}

