/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.score.ReferenceProbability;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.taxa.distance.DistanceMatrix;

public class Kinship {
    public static double MATRIX_MULTIPLIER = 2.0;

    private Kinship() {
    }

    private static DistanceMatrix createKinship(GenotypeTable mar, KINSHIP_TYPE kinshipType, GenotypeTable.GENOTYPE_TABLE_COMPONENT dataType) {
        System.out.println("Starting Kinship.buildFromMarker().");
        long start = System.currentTimeMillis();
        if (kinshipType != KINSHIP_TYPE.Endelman) {
            throw new IllegalArgumentException("Kinship: createKinship: unknown kinship algorithm: " + (Object)((Object)kinshipType));
        }
        DistanceMatrix result = Kinship.buildFromMarker(mar, kinshipType, dataType);
        System.out.printf("Built Kinship in %d millisec.\n", System.currentTimeMillis() - start);
        return result;
    }

    private static DistanceMatrix buildFromMarker(GenotypeTable mar, KINSHIP_TYPE kinshipType, GenotypeTable.GENOTYPE_TABLE_COMPONENT dataType) {
        if (dataType == GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype) {
            return Kinship.calculateKinshipFromMarkers(mar);
        }
        if (dataType == GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability) {
            return Kinship.calculateRelationshipKinshipFromReferenceProbability(mar);
        }
        throw new IllegalArgumentException("The supplied data type is not currently supported by the Kinship method: " + (Object)((Object)dataType));
    }

    private static DistanceMatrix calculateKinshipFromMarkers(GenotypeTable mar) {
        byte missingAllele = 15;
        int ntaxa = mar.numberOfTaxa();
        int nsites = mar.numberOfSites();
        double[][] distance = new double[ntaxa][ntaxa];
        double sumpi = 0.0;
        for (int s = 0; s < nsites; ++s) {
            int[][] alleleFreq = mar.allelesSortedByFrequency(s);
            int nalleles = alleleFreq[0].length;
            int totalAlleleCount = mar.totalGametesNonMissingForSite(s);
            for (int a = 0; a < nalleles - 1; ++a) {
                double pi = (double)alleleFreq[1][a] / (double)totalAlleleCount;
                double pix2 = 2.0 * pi;
                sumpi += pi * (1.0 - pi);
                double[] scores = new double[ntaxa];
                for (int t = 0; t < ntaxa; ++t) {
                    byte[] geno = GenotypeTableUtils.getDiploidValues(mar.genotype(t, s));
                    double thisScore = 0.0;
                    if (geno[0] != missingAllele) {
                        if (geno[0] == alleleFreq[0][a]) {
                            thisScore += 1.0;
                        }
                        if (geno[1] == alleleFreq[0][a]) {
                            thisScore += 1.0;
                        }
                        thisScore -= pix2;
                    }
                    scores[t] = thisScore;
                }
                for (int r = 0; r < ntaxa; ++r) {
                    double rowval = scores[r];
                    double[] dArray = distance[r];
                    int n = r;
                    dArray[n] = dArray[n] + rowval * rowval;
                    for (int c = r + 1; c < ntaxa; ++c) {
                        double[] dArray2 = distance[r];
                        int n2 = c;
                        dArray2[n2] = dArray2[n2] + rowval * scores[c];
                    }
                }
            }
        }
        double sumpk = 2.0 * sumpi;
        for (int r = 0; r < ntaxa; ++r) {
            double[] dArray = distance[r];
            int n = r;
            dArray[n] = dArray[n] / sumpk;
            for (int c = r + 1; c < ntaxa; ++c) {
                double d = distance[r][c] / sumpk;
                distance[c][r] = d;
                distance[r][c] = d;
            }
        }
        return new DistanceMatrix(distance, mar.taxa());
    }

    private static DistanceMatrix calculateKinshipFromMarkersV2(GenotypeTable mar) {
        byte missingAllele = 15;
        int ntaxa = mar.numberOfTaxa();
        int nsites = mar.numberOfSites();
        double[][] distance = new double[ntaxa][ntaxa];
        double sumpq = IntStream.range(0, nsites).parallel().mapToDouble(s -> {
            int[][] alleleFreq = mar.allelesSortedByFrequency(s);
            int nalleles = alleleFreq[0].length;
            double totalAlleleCount = mar.totalGametesNonMissingForSite(s);
            double pq = 0.0;
            for (int a = 0; a < nalleles - 1; ++a) {
                double p = (double)alleleFreq[1][a] / totalAlleleCount;
                pq += p * (1.0 - p);
            }
            return pq;
        }).sum();
        BiConsumer<double[][], Integer> siteDistance = (dist, site) -> {
            int s = site;
            int[][] alleleFreq = mar.allelesSortedByFrequency(s);
            int nalleles = alleleFreq[0].length;
            int totalAlleleCount = mar.totalGametesNonMissingForSite(s);
            for (int a = 0; a < nalleles - 1; ++a) {
                double pi = (double)alleleFreq[1][a] / (double)totalAlleleCount;
                double pix2 = 2.0 * pi;
                double[] scores = new double[ntaxa];
                for (int t = 0; t < ntaxa; ++t) {
                    byte[] geno = GenotypeTableUtils.getDiploidValues(mar.genotype(t, s));
                    double thisScore = 0.0;
                    if (geno[0] != missingAllele) {
                        if (geno[0] == alleleFreq[0][a]) {
                            thisScore += 1.0;
                        }
                        if (geno[1] == alleleFreq[0][a]) {
                            thisScore += 1.0;
                        }
                        thisScore -= pix2;
                    }
                    scores[t] = thisScore;
                }
                for (int r = 0; r < ntaxa; ++r) {
                    double rowval = scores[r];
                    double[] dArray = dist[r];
                    int n = r;
                    dArray[n] = dArray[n] + rowval * rowval;
                    for (int c = r + 1; c < ntaxa; ++c) {
                        double[] dArray2 = dist[r];
                        int n2 = c;
                        dArray2[n2] = dArray2[n2] + rowval * scores[c];
                    }
                }
            }
        };
        BiConsumer<double[][], double[][]> mergeDistance = (d1, d2) -> {
            for (int r = 0; r < ntaxa; ++r) {
                double[] row1 = d1[r];
                double[] row2 = d2[r];
                for (int c = 0; c < ntaxa; ++c) {
                    int n = c;
                    row1[n] = row1[n] + row2[c];
                }
            }
        };
        distance = ((Stream)IntStream.range(0, nsites).boxed().parallel()).collect(() -> new double[ntaxa][ntaxa], siteDistance, mergeDistance);
        double sumpk = 2.0 * sumpq;
        for (int r = 0; r < ntaxa; ++r) {
            double[] dArray = distance[r];
            int n = r;
            dArray[n] = dArray[n] / sumpk;
            for (int c = r + 1; c < ntaxa; ++c) {
                double d = distance[r][c] / sumpk;
                distance[c][r] = d;
                distance[r][c] = d;
            }
        }
        return new DistanceMatrix(distance, mar.taxa());
    }

    private static DistanceMatrix calculateRelationshipKinshipFromReferenceProbability(GenotypeTable mar) {
        ReferenceProbability referenceP = mar.referenceProbability();
        int nrow = referenceP.numTaxa();
        int ncol = referenceP.numSites();
        double[][] W = new double[nrow][ncol];
        for (int r = 0; r < nrow; ++r) {
            for (int c = 0; c < ncol; ++c) {
                W[r][c] = (double)referenceP.value(r, c) * MATRIX_MULTIPLIER;
            }
        }
        double sumpq = 0.0;
        for (int c = 0; c < ncol; ++c) {
            double colTotal = 0.0;
            int colCount = 0;
            for (int r = 0; r < nrow; ++r) {
                if (Double.isNaN(W[r][c])) continue;
                colTotal += W[r][c];
                ++colCount;
            }
            double pi = colTotal / (double)colCount / 2.0;
            double pix2 = pi * 2.0;
            sumpq += pi * (1.0 - pi);
            for (int r = 0; r < nrow; ++r) {
                if (Double.isNaN(W[r][c])) {
                    W[r][c] = 0.0;
                    continue;
                }
                double[] dArray = W[r];
                int n = c;
                dArray[n] = dArray[n] - pix2;
            }
        }
        DoubleMatrix WWt = DoubleMatrixFactory.DEFAULT.make(W).tcrossproduct();
        double[][] scaledIBS = new double[nrow][nrow];
        for (int r = 0; r < nrow; ++r) {
            for (int c = 0; c < nrow; ++c) {
                scaledIBS[r][c] = WWt.get(r, c) / sumpq / 2.0;
            }
        }
        return new DistanceMatrix(scaledIBS, mar.taxa());
    }

    private static DistanceMatrix calculateRelationshipKinshipFromAlleleProbabilities() {
        return null;
    }

    public static enum KINSHIP_TYPE {
        Endelman;

    }
}

