/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.distance.RemoveNaNFromDistanceMatrixPlugin;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.stats.PCA.ClassicMds;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.TableReportBuilder;

public class MultiDimensionalScalingPlugin
extends AbstractPlugin {
    private PluginParameter<Integer> numberOfAxes = new PluginParameter.Builder<Integer>("axes", 5, Integer.class).description("The number of axes or dimensions and associated eigenvalues to be returned by the analysis.").guiName("Number of Axes").build();
    private PluginParameter<Boolean> removeNaN = new PluginParameter.Builder<Boolean>("removeNaN", true, Boolean.class).description("Remove NaNs from matrix before performing MDS").guiName("Remove NaNs").build();

    public MultiDimensionalScalingPlugin(Frame parent, boolean interactive) {
        super(parent, interactive);
    }

    @Override
    public DataSet processData(DataSet input) {
        ArrayList<Datum> resultList = new ArrayList<Datum>();
        List<Datum> myDatumList = input.getDataOfType(DistanceMatrix.class);
        if (myDatumList.size() < 1) {
            throw new RuntimeException("MDS requires a Distance Matrix as input.");
        }
        int ndata = myDatumList.size();
        this.fireProgress(10);
        int counter = 0;
        for (Datum myDatum : myDatumList) {
            DistanceMatrix myDistanceMatrix = (DistanceMatrix)myDatum.getData();
            if (this.removeNaN().booleanValue()) {
                myDistanceMatrix = RemoveNaNFromDistanceMatrixPlugin.runPlugin(myDistanceMatrix);
            }
            ClassicMds myMDS = new ClassicMds(myDistanceMatrix);
            int numberOfAxesToReport = this.numberOfAxes.value();
            ArrayList<PhenotypeAttribute> attrList = new ArrayList<PhenotypeAttribute>();
            ArrayList<Phenotype.ATTRIBUTE_TYPE> typeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            attrList.add(new TaxaAttribute(myDistanceMatrix.getTaxaList()));
            typeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
            int ntaxa = myDistanceMatrix.getSize();
            for (int i = 0; i < numberOfAxesToReport; ++i) {
                typeList.add(Phenotype.ATTRIBUTE_TYPE.covariate);
                float[] floatValues = AssociationUtils.convertDoubleArrayToFloat(myMDS.getPrincipalCoordinate(i));
                NumericAttribute pcAttr = new NumericAttribute("PC" + (i + 1), floatValues, new OpenBitSet(ntaxa));
                attrList.add(pcAttr);
            }
            Phenotype myPhenotype = new PhenotypeBuilder().fromAttributeList(attrList, typeList).build().get(0);
            String name = "MDS_PCs_" + myDatum.getName();
            String comment = "Principal Coordinates from MDS analysis of " + myDatum.getName();
            resultList.add(new Datum(name, myPhenotype, comment));
            Object[] colnames = new String[]{"PC", "eigenvalue"};
            TableReportBuilder reportBuilder = TableReportBuilder.getInstance("", colnames);
            for (int i = 0; i < numberOfAxesToReport; ++i) {
                reportBuilder.add(new Object[]{new Integer(i + 1), new Double(myMDS.getEigenvalue(i))});
            }
            name = "MDS_Eigenvalues_" + myDatum.getName();
            comment = "Eigenvalues from MDS analysis of " + myDatum.getName();
            resultList.add(new Datum(name, reportBuilder.build(), comment));
            this.fireProgress(Math.min(99, ++counter * 100 / ndata));
        }
        return new DataSet(resultList, (Plugin)this);
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = MultiDimensionalScalingPlugin.class.getResource("/net/maizegenetics/analysis/images/pca.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "MDS";
    }

    @Override
    public String getToolTipText() {
        return "Perform classic multidimensional scaling (principal coordinate analysis)";
    }

    @Override
    public String pluginDescription() {
        return "MultiDimensionalScalingPlugin takes a DistanceMatrix as input and performs classic multidimensional scaling, which is also know as principal coordinate analysis (PCO).";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel-5-source/wiki/UserManual/MDS/MDS";
    }

    public Integer numberOfAxes() {
        return this.numberOfAxes.value();
    }

    public MultiDimensionalScalingPlugin numberOfAxes(Integer value) {
        this.numberOfAxes = new PluginParameter<Integer>(this.numberOfAxes, value);
        return this;
    }

    public Boolean removeNaN() {
        return this.removeNaN.value();
    }

    public MultiDimensionalScalingPlugin removeNaN(Boolean value) {
        this.removeNaN = new PluginParameter<Boolean>(this.removeNaN, value);
        return this;
    }
}

