/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.distance.EndelmanDistanceMatrix;
import net.maizegenetics.analysis.distance.GCTADistanceMatrix;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.DistanceMatrixWithCounts;
import net.maizegenetics.taxa.distance.ReadDistanceMatrix;
import net.maizegenetics.util.GeneralAnnotation;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class SubtractDistanceMatrixPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SubtractDistanceMatrixPlugin.class);
    private PluginParameter<String> myWholeMatrix = new PluginParameter.Builder<String>("wholeMatrix", null, String.class).description("The filename of the whole matrix which will be used to subtract input sub-matrices.").inFile().required(true).build();
    private DistanceMatrix myCurrentlyLoadedMatrix = null;

    public SubtractDistanceMatrixPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> matrices = input.getDataOfType(DistanceMatrix.class);
        if (matrices.isEmpty()) {
            throw new IllegalArgumentException("SubtractDistanceMatrixPlugin: preProcessParameters: must input at least one Distance Matrix to subtract.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        if (this.myCurrentlyLoadedMatrix == null) {
            this.myCurrentlyLoadedMatrix = ReadDistanceMatrix.readDistanceMatrix(this.wholeMatrix());
        }
        GeneralAnnotation annotations = this.myCurrentlyLoadedMatrix.annotations();
        String matrixType = null;
        try {
            matrixType = annotations.getTextAnnotation("Matrix_Type")[0];
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("SubtractDistanceMatrixPlugin: processData: the whole matrix: " + this.wholeMatrix() + " doesn't have annotation: " + "Matrix_Type" + ". The matrix must be exported with a more recent build of Tassel.");
        }
        if (matrixType.equals(KinshipPlugin.KINSHIP_METHOD.Centered_IBS.toString())) {
            List<Datum> matricesList = input.getDataOfType(DistanceMatrix.class);
            DistanceMatrix[] matrices = new DistanceMatrix[matricesList.size()];
            for (int i = 0; i < matricesList.size(); ++i) {
                matrices[i] = (DistanceMatrix)matricesList.get(i).getData();
            }
            DistanceMatrix result = EndelmanDistanceMatrix.subtractEndelmanDistance(matrices, this.myCurrentlyLoadedMatrix, this);
            return new DataSet(new Datum(Utils.getFilename(this.wholeMatrix()) + "_Rest", result, null), (Plugin)this);
        }
        if (matrixType.equals(KinshipPlugin.KINSHIP_METHOD.Normalized_IBS.toString())) {
            List<Datum> matricesList = input.getDataOfType(DistanceMatrixWithCounts.class);
            if (matricesList.isEmpty()) {
                throw new IllegalArgumentException("SubtractDistanceMatrixPlugin: processData: must input at least one Distance Matrix with counts to subtract.");
            }
            DistanceMatrixWithCounts[] matrices = new DistanceMatrixWithCounts[matricesList.size()];
            for (int i = 0; i < matricesList.size(); ++i) {
                matrices[i] = (DistanceMatrixWithCounts)matricesList.get(i).getData();
            }
            DistanceMatrixWithCounts tempMatrix = null;
            try {
                tempMatrix = (DistanceMatrixWithCounts)this.myCurrentlyLoadedMatrix;
            }
            catch (ClassCastException ex) {
                myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                throw new IllegalArgumentException("SubtractDistanceMatrixPlugin: processData: whole matrix must have counts.");
            }
            DistanceMatrix result = GCTADistanceMatrix.subtractGCTADistance(matrices, tempMatrix, this);
            return new DataSet(new Datum(Utils.getFilename(this.wholeMatrix()) + "_Rest", result, null), (Plugin)this);
        }
        throw new UnsupportedOperationException("SubstractDistanceMatrixPlugin: processData: unsupported matrix type: " + matrixType);
    }

    public String wholeMatrix() {
        return this.myWholeMatrix.value();
    }

    public SubtractDistanceMatrixPlugin wholeMatrix(String value) {
        this.myWholeMatrix = new PluginParameter<String>(this.myWholeMatrix, value);
        this.myCurrentlyLoadedMatrix = null;
        return this;
    }

    public SubtractDistanceMatrixPlugin wholeMatrix(DistanceMatrix matrix) {
        this.myWholeMatrix = new PluginParameter<String>(this.myWholeMatrix, matrix.getTableTitle());
        this.myCurrentlyLoadedMatrix = matrix;
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Subtract Distance Matrix";
    }

    @Override
    public String getToolTipText() {
        return "Subtract Distance Matrix";
    }
}

