/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Frame;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import org.apache.log4j.Logger;

public class FilterSubsetPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterSubsetPlugin.class);
    private boolean myIsRandom = true;
    private double mySiteSubset = -1.0;
    private int[] mySitesToKeep = null;
    private double myTaxaSubset = -1.0;
    private int[] myTaxaToKeep = null;
    private TaxaList myTaxaList = null;

    public FilterSubsetPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> inputData = input.getDataOfType(GenotypeTable.class);
            if (inputData.size() != 1) {
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection. Please select a single alignment.");
                } else {
                    myLogger.error((Object)"performFunction: Please input a single alignment.");
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum td = this.processDatum(inputData.get(0), this.isInteractive());
            if (td == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet output = new DataSet(td, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, FilterSubsetPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum processDatum(Datum inDatum, boolean isInteractive) {
        GenotypeTable alignment = (GenotypeTable)inDatum.getData();
        if (isInteractive) {
            myLogger.error((Object)"Interactive random subset not implemented yet.");
        }
        if (this.mySiteSubset <= 0.0 && this.myTaxaSubset <= 0.0) {
            myLogger.error((Object)"Must provide a positive value (decimal or integer) to use for subsetting");
            return null;
        }
        GenotypeTable result = alignment;
        if (this.mySiteSubset > 0.0 && this.mySiteSubset < (double)alignment.numberOfSites()) {
            this.determineSitesToKeep(alignment);
            result = FilterGenotypeTable.getInstance(result, this.mySitesToKeep);
        }
        if (this.myTaxaSubset > 0.0 && this.myTaxaSubset < (double)alignment.numberOfTaxa()) {
            this.determineTaxaToKeep(alignment);
            result = FilterGenotypeTable.getInstance(result, this.myTaxaList);
        }
        String theName = inDatum.getName() + "_" + result.numberOfSites() + "_Sites";
        String theComment = "Subset of " + result.numberOfSites() + " from " + alignment.numberOfSites() + " Sites\n" + inDatum.getComment();
        return new Datum(theName, result, theComment);
    }

    private void determineSitesToKeep(GenotypeTable gt) {
        this.mySitesToKeep = this.getRandomSubset(this.mySiteSubset, gt.numberOfSites(), "sites");
    }

    private void determineTaxaToKeep(GenotypeTable gt) {
        this.myTaxaToKeep = this.getRandomSubset(this.myTaxaSubset, gt.numberOfTaxa(), "taxa");
        String[] taxa = new String[this.myTaxaToKeep.length];
        for (int i = 0; i < this.myTaxaToKeep.length; ++i) {
            taxa[i] = gt.taxaName(this.myTaxaToKeep[i]);
        }
        TaxaListBuilder builder = new TaxaListBuilder();
        builder.addAll(taxa);
        this.myTaxaList = builder.build();
    }

    private int[] getRandomSubset(double subset_val, int max, String type) {
        int[] result;
        int i;
        int n;
        if (subset_val >= 1.0) {
            n = (int)Math.round(subset_val);
        } else {
            n = (int)Math.round(subset_val * (double)max);
            if (n < 1) {
                myLogger.warn((Object)("Given values would result in <1 " + type + "; forcing minimum of 1"));
                n = 1;
            }
        }
        boolean flip = false;
        if ((double)n > (double)max / 2.0) {
            flip = true;
            n = max - n;
        }
        HashMap<Integer, Boolean> chosen = new HashMap<Integer, Boolean>();
        if (this.myIsRandom) {
            while (chosen.size() < n) {
                int index = (int)(Math.random() * (double)max);
                if (index >= max) {
                    index = max - 1;
                }
                chosen.put(index, true);
            }
        } else {
            double step = (double)max / (double)n;
            for (double current = 0.0; current < (double)max && chosen.size() < n; current += step) {
                chosen.put((int)Math.floor(current), true);
            }
        }
        if (flip) {
            HashMap<Integer, Boolean> flipped = new HashMap<Integer, Boolean>();
            for (i = 0; i < max; ++i) {
                if (chosen.containsKey(i)) continue;
                flipped.put(i, true);
            }
            chosen = flipped;
            n = max - n;
        }
        if ((result = new int[chosen.size()]).length != n) {
            myLogger.error((Object)("Output set for " + type + " has length " + result.length + " instead of specified length " + n));
        }
        i = 0;
        for (Integer c : chosen.keySet()) {
            result[i] = c;
            ++i;
        }
        Arrays.sort(result);
        return result;
    }

    public void setSiteSubset(double subset_val) {
        this.mySiteSubset = subset_val;
    }

    public void setTaxaSubset(double subset_val) {
        this.myTaxaSubset = subset_val;
    }

    public void setIsRandom(boolean isRandom) {
        this.myIsRandom = isRandom;
    }

    public double siteSubset() {
        return this.mySiteSubset;
    }

    public double taxaSubset() {
        return this.myTaxaSubset;
    }

    public int[] sitesToKeep() {
        return this.mySitesToKeep;
    }

    public int[] taxaToKeep() {
        return this.myTaxaToKeep;
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

