/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public class FilterTaxaPropertiesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterTaxaPropertiesPlugin.class);
    private PluginParameter<Double> myMinNotMissing = new PluginParameter.Builder<Double>("minNotMissing", 0.0, Double.class).guiName("Min Proportion of Sites Present").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();
    private PluginParameter<Double> myMinHeterozygous = new PluginParameter.Builder<Double>("minHeterozygous", 0.0, Double.class).guiName("Min Heterozygous Proportion").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();
    private PluginParameter<Double> myMaxHeterozygous = new PluginParameter.Builder<Double>("maxHeterozygous", 1.0, Double.class).guiName("Max Heterozygous Proportion").range((Range<Comparable<Double>>)Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0))).build();

    public FilterTaxaPropertiesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList.size() != 1) {
            throw new IllegalArgumentException("FilterTaxaPropertiesPlugin: preProcessParameters: Must select one Genotype Table.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> datumList = input.getDataOfType(GenotypeTable.class);
        Datum inDatum = datumList.get(0);
        GenotypeTable aa = (GenotypeTable)inDatum.getData();
        GenotypeTable result = this.getFilteredAlignment(aa);
        StringBuilder builder = new StringBuilder();
        builder.append("Filter Alignment by Taxa Properties...\n");
        builder.append("   Min. Proportion of Sites Present: ");
        builder.append(this.minProportionOfSitesPresent());
        builder.append("\n");
        builder.append("   Heterozygous Proportion: ");
        builder.append(this.minHeterozygousProportion());
        builder.append(" - ");
        builder.append(this.maxHeterozygousProportion());
        builder.append("\n");
        String theComment = builder.toString();
        if (result == aa) {
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "The Alignment is Unchanged.");
            } else {
                myLogger.warn((Object)("The Alignment is Unchanged: " + inDatum.getName()));
            }
        }
        if (result.numberOfTaxa() != 0) {
            String theName = inDatum.getName() + "_" + result.numberOfTaxa() + "Taxa";
            myLogger.info((Object)("Resulting Number Sequences: " + result.numberOfTaxa()));
            return new DataSet(new Datum(theName, result, theComment), (Plugin)this);
        }
        if (this.isInteractive()) {
            JOptionPane.showMessageDialog(this.getParentFrame(), "No remaining Taxa given filter parameters.");
        } else {
            myLogger.warn((Object)"No remaining Taxa given filter parameters.");
        }
        return null;
    }

    private GenotypeTable getFilteredAlignment(GenotypeTable alignment) {
        int numSites = alignment.numberOfSites();
        int numTaxa = alignment.numberOfTaxa();
        TaxaList ids = alignment.taxa();
        TaxaListBuilder keepTaxaList = new TaxaListBuilder();
        for (int t = 0; t < numTaxa; ++t) {
            int totalSitesNotMissing;
            int numHeterozygous;
            double percentHets;
            int totalNotMissing;
            double percentNotMissing;
            this.progress((int)((double)t / (double)numTaxa * 100.0), null);
            if (this.minProportionOfSitesPresent() != 0.0 && (percentNotMissing = (double)(totalNotMissing = alignment.totalNonMissingForTaxon(t)) / (double)numSites) < this.minProportionOfSitesPresent() || (this.minHeterozygousProportion() != 0.0 || this.maxHeterozygousProportion() != 1.0) && ((percentHets = (double)(numHeterozygous = alignment.heterozygousCountForTaxon(t)) / (double)(totalSitesNotMissing = alignment.totalNonMissingForTaxon(t))) < this.minHeterozygousProportion() || percentHets > this.maxHeterozygousProportion())) continue;
            keepTaxaList.add((Taxon)ids.get(t));
        }
        return FilterGenotypeTable.getInstance(alignment, keepTaxaList.build(), false);
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public Double minProportionOfSitesPresent() {
        return this.myMinNotMissing.value();
    }

    public FilterTaxaPropertiesPlugin minProportionOfSitesPresent(Double value) {
        this.myMinNotMissing = new PluginParameter<Double>(this.myMinNotMissing, value);
        return this;
    }

    public Double minHeterozygousProportion() {
        return this.myMinHeterozygous.value();
    }

    public FilterTaxaPropertiesPlugin minHeterozygousProportion(Double value) {
        this.myMinHeterozygous = new PluginParameter<Double>(this.myMinHeterozygous, value);
        return this;
    }

    public Double maxHeterozygousProportion() {
        return this.myMaxHeterozygous.value();
    }

    public FilterTaxaPropertiesPlugin maxHeterozygousProportion(Double value) {
        this.myMaxHeterozygous = new PluginParameter<Double>(this.myMaxHeterozygous, value);
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterTaxaPropertiesPlugin.class.getResource("/net/maizegenetics/analysis/images/Filter_horizontal.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Taxa";
    }

    @Override
    public String getToolTipText() {
        return "Filter Alignment Based Taxa Properties";
    }
}

