/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.util.Arrays;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.taxa.Taxon;

public class Barcode
implements Comparable<Barcode> {
    String barcodeS;
    String[] overhangS;
    String taxaName;
    String tissueName;
    String flowcell;
    String lane;
    String[] barWOverhangS;
    long[] barOverLong;
    int barOverLength;
    int barLength;
    int taxaIndex;
    int tissueIndex;
    private Taxon taxon;

    public Barcode(String barcodeS, String[] overhangSunsort, String taxa, int globalTaxaIndex, String flowcell, String lane) {
        this.barcodeS = barcodeS;
        Arrays.sort(overhangSunsort);
        this.overhangS = overhangSunsort;
        this.flowcell = flowcell;
        this.lane = lane;
        this.taxaName = taxa;
        this.tissueName = "";
        this.taxon = new Taxon(this.taxaName);
        this.taxaIndex = globalTaxaIndex;
        this.tissueIndex = -1;
        this.barOverLong = new long[this.overhangS.length];
        this.barWOverhangS = new String[this.overhangS.length];
        for (int i = 0; i < this.overhangS.length; ++i) {
            this.barWOverhangS[i] = barcodeS + this.overhangS[i];
            this.barOverLong[i] = BaseEncoder.getLongFromSeq(this.barWOverhangS[i]);
        }
        this.barOverLength = barcodeS.length() + this.overhangS[0].length();
        this.barLength = barcodeS.length();
    }

    public Barcode(String barcodeS, String[] overhangSunsort, String taxa, int globalTaxaIndex, String tissue, int globalTissueIndex, String flowcell, String lane) {
        this.barcodeS = barcodeS;
        Arrays.sort(overhangSunsort);
        this.overhangS = overhangSunsort;
        this.flowcell = flowcell;
        this.lane = lane;
        this.taxaName = taxa;
        this.tissueName = null;
        this.taxon = new Taxon(this.taxaName);
        this.taxaIndex = globalTaxaIndex;
        this.tissueIndex = globalTissueIndex;
        this.barOverLong = new long[this.overhangS.length];
        this.barWOverhangS = new String[this.overhangS.length];
        for (int i = 0; i < this.overhangS.length; ++i) {
            this.barWOverhangS[i] = barcodeS + this.overhangS[i];
            this.barOverLong[i] = BaseEncoder.getLongFromSeq(this.barWOverhangS[i]);
        }
        this.barOverLength = barcodeS.length() + this.overhangS[0].length();
        this.barLength = barcodeS.length();
    }

    public int compareSequence(long queryLong, int maxDivCheck) {
        int div = this.barOverLength;
        for (long targetLong : this.barOverLong) {
            byte c = BaseEncoder.seqDifferencesForSubset(targetLong, queryLong, this.barOverLength, maxDivCheck);
            if (c >= div) continue;
            div = c;
        }
        return div;
    }

    @Override
    public int compareTo(Barcode anotherBarcode) {
        if (this.barOverLong[0] < anotherBarcode.barOverLong[0]) {
            return -1;
        }
        if (this.barOverLong[0] > anotherBarcode.barOverLong[0]) {
            return 1;
        }
        return 0;
    }

    public String getTaxaName() {
        return this.taxaName;
    }

    public String getBarcodeString() {
        return this.barcodeS;
    }

    public long[] getBarWOverHangLong() {
        return this.barOverLong;
    }

    public String[] getBarWOverHang() {
        return this.barWOverhangS;
    }

    public int getBarWithOverHangLength() {
        return this.barOverLength;
    }

    public int getBarLength() {
        return this.barLength;
    }

    public int getTaxaIndex() {
        return this.taxaIndex;
    }

    public int getTissueIndex() {
        return this.tissueIndex;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public String toString() {
        return "Barcode{barcodeS='" + this.barcodeS + '\'' + ", overhangS=" + Arrays.toString(this.overhangS) + ", taxaName='" + this.taxaName + '\'' + ", tissueName='" + this.tissueName + '\'' + ", flowcell='" + this.flowcell + '\'' + ", lane='" + this.lane + '\'' + ", taxaIndex=" + this.taxaIndex + '}';
    }
}

