/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import com.google.common.collect.Range;
import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.HelperTags;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.UTagPairs;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class UTagPairToTOPMPlugin
extends AbstractPlugin {
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(UTagPairToTOPMPlugin.class);
    private UTagPairs tp;
    byte myStrand = 1;
    byte myMultimaps = 1;
    byte myDcoP = (byte)-128;
    byte myMapP = (byte)-128;
    private PluginParameter<Integer> chrom = new PluginParameter.Builder<Integer>("chrom", 1, Integer.class).description("Chromosome to start numbering at").guiName("Start chromosome").build();
    private PluginParameter<Integer> distance = new PluginParameter.Builder<Integer>("distance", 1000, Integer.class).description("Distance to pad between each tag pair").guiName("Pad distance").units("base pairs").range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).build();
    private PluginParameter<String> infile = new PluginParameter.Builder<String>("input", null, String.class).description("Input file of matched tag pairs").guiName("Input tag pair file").required(true).inFile().build();
    private PluginParameter<String> textOutputFile = new PluginParameter.Builder<String>("toText", null, String.class).description("File to output TOPM in text format").guiName("Output file (text)").required(false).outFile().build();
    private PluginParameter<String> binaryOutputFile = new PluginParameter.Builder<String>("toBinary", null, String.class).description("File to output TOPM in binary format").guiName("Output file (binary)").required(false).outFile().build();

    public UTagPairToTOPMPlugin() {
        super(null, false);
    }

    public UTagPairToTOPMPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        this.tp = new UTagPairs(this.input());
        TagsOnPhysicalMap myTopm = this.makeTopmFromTagPairs(this.tp);
        if (this.toText() != null) {
            this.logger.info((Object)("Outputting TOPM in text format to " + this.toText()));
            myTopm.writeTextFile(new File(this.toText()));
        }
        if (this.toBinary() != null) {
            this.logger.info((Object)("Outputting TOPM in binary format to " + this.toBinary()));
            myTopm.writeBinaryFile(new File(this.toBinary()));
        }
        return null;
    }

    private TagsOnPhysicalMap makeTopmFromTagPairs(UTagPairs tp) {
        HelperTags tempTags = new HelperTags(tp.getTagNum(), tp.getTag(0).length);
        for (int i = 0; i < tp.getTagNum(); ++i) {
            tempTags.setTag(i, tp.getTag(i), tp.getTagLength(i));
        }
        TagsOnPhysicalMap myTopm = new TagsOnPhysicalMap(tempTags);
        long currPos = 1L;
        int currChrom = this.startChromosome();
        for (int i = 0; i < tp.getTagNum(); ++i) {
            myTopm.setChromoPosition(i, currChrom, this.myStrand, (int)currPos, (int)currPos + tp.getTagLength(i) - 1);
            myTopm.setDivergence(i, (byte)0);
            myTopm.setDcoP(i, (byte)-128);
            myTopm.setMapP(i, (byte)-128);
            myTopm.setMultimaps(i, (byte)1);
            if (i % 2 == 1) {
                currPos += (long)this.padDistance().intValue();
            }
            if (currPos < Integer.MAX_VALUE) continue;
            ++currChrom;
            currPos = 1L;
        }
        return myTopm;
    }

    @Override
    protected void postProcessParameters() {
        if ((this.toBinary() == null || "".equals(this.toBinary())) && (this.toText() == null || "".equals(this.toText()))) {
            throw new IllegalArgumentException("\n\nMust specify at least one output file (text or binary).\n\n");
        }
        if (this.padDistance() < 100) {
            this.logger.warn((Object)"Warning! Setting the pad distance to <100 base pairs risks overlapping tags pairs with each other (and thus calling false SNPs)");
        }
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes a tag-pair file (from UTagCountToTagPairPlugin) and converts it into a TOPM (tags on physical map) file for use in the GBS pipeline. The resulting chromosome coordinates and other data are just filler to comply with the TOPM file specifications.";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Tag Pairs to TOPM";
    }

    @Override
    public String getToolTipText() {
        return "Deprecated: Reference Pipeline is Better";
    }

    public Integer startChromosome() {
        return this.chrom.value();
    }

    public UTagPairToTOPMPlugin startChromosome(Integer value) {
        this.chrom = new PluginParameter<Integer>(this.chrom, value);
        return this;
    }

    public Integer padDistance() {
        return this.distance.value();
    }

    public UTagPairToTOPMPlugin padDistance(Integer value) {
        this.distance = new PluginParameter<Integer>(this.distance, value);
        return this;
    }

    public String input() {
        return this.infile.value();
    }

    public UTagPairToTOPMPlugin input(String value) {
        this.infile = new PluginParameter<String>(this.infile, value);
        return this;
    }

    public String toText() {
        return this.textOutputFile.value();
    }

    public UTagPairToTOPMPlugin toText(String value) {
        this.textOutputFile = new PluginParameter<String>(this.textOutputFile, value);
        return this;
    }

    public String toBinary() {
        return this.binaryOutputFile.value();
    }

    public UTagPairToTOPMPlugin toBinary(String value) {
        this.binaryOutputFile = new PluginParameter<String>(this.binaryOutputFile, value);
        return this;
    }
}

