/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.neobio;

public class Factor {
    protected Factor ancestor;
    protected Factor next;
    protected int serial_number;
    protected int length;
    protected char new_char;

    public Factor() {
        this.ancestor = null;
        this.next = null;
        this.serial_number = 0;
        this.length = 0;
        this.new_char = '\u0000';
    }

    public Factor(Factor ancestor, int serial_number, char new_char) {
        this.ancestor = ancestor;
        this.serial_number = serial_number;
        this.new_char = new_char;
        if (ancestor == null) {
            throw new IllegalArgumentException("Ancestor factor cannot be null.");
        }
        this.length = ancestor.length() + 1;
    }

    public void setNext(Factor next) {
        this.next = next;
    }

    public Factor getAncestor() {
        return this.ancestor;
    }

    public int getAncestorSerialNumber() {
        return this.ancestor.getSerialNumber();
    }

    public Factor getNext() {
        return this.next;
    }

    public int getSerialNumber() {
        return this.serial_number;
    }

    public int length() {
        return this.length;
    }

    public char getNewChar() {
        return this.new_char;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Factor ancestor = this;
        while (ancestor.getAncestor() != null) {
            buf.insert(0, ancestor.getNewChar());
            ancestor = ancestor.getAncestor();
        }
        return buf.toString();
    }
}

