/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.pana;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class PanAMergeMappingResultPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(PanAMergeMappingResultPlugin.class);
    String subResultDirS = null;
    String mergedResultFileS = null;

    public PanAMergeMappingResultPlugin() {
        super(null, false);
    }

    public PanAMergeMappingResultPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -i  directory of mapping results of sub TBTs\n -o  filename of merged mapping result\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        Object[] files = new File(this.subResultDirS).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("txt");
            }
        });
        Arrays.sort(files);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.mergedResultFileS), 65536);
            BufferedReader br = new BufferedReader(new FileReader(((File)files[0]).getAbsolutePath()), 65536);
            String header = br.readLine();
            bw.write(header);
            bw.newLine();
            for (int i = 0; i < files.length; ++i) {
                String temp;
                br = new BufferedReader(new FileReader(((File)files[i]).getAbsolutePath()), 65536);
                br.readLine();
                while ((temp = br.readLine()) != null) {
                    bw.write(temp);
                    bw.newLine();
                }
                System.out.println(((File)files[i]).getAbsolutePath() + " is merged");
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-i", "--input-TBT", true);
            this.engine.add("-o", "--output-dir", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.subResultDirS = this.engine.getString("-i");
        if (!this.engine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        this.mergedResultFileS = this.engine.getString("-o");
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

